/*
 * Copyright (c) 2009-2019 ARM Limited. All rights reserved.
 * 
 * SPDX-License-Identifier: Apache-2.0
 * 
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @file     dpm32m030.h
 * @brief    CMSIS HeaderFile
 * @version  1.0
 * @date     11. September 2024
 * @note     Generated by SVDConv V3.3.42 on Wednesday, 11.09.2024 11:08:41
 *           from File 'dpm32m030.svd',
 *           last modified on Wednesday, 11.09.2024 03:08:40
 */



/** @addtogroup DP Ltd.
  * @{
  */


/** @addtogroup dpm32m030
  * @{
  */


#ifndef DPM32M030_H
#define DPM32M030_H

#ifdef __cplusplus
extern "C" {
#endif


/** @addtogroup Configuration_of_CMSIS
  * @{
  */



/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

typedef enum {
/* =======================================  ARM Cortex-M0 Specific Interrupt Numbers  ======================================== */
  Reset_IRQn                = -15,              /*!< -15  Reset Vector, invoked on Power up and warm reset                     */
  NonMaskableInt_IRQn       = -14,              /*!< -14  Non maskable Interrupt, cannot be stopped or preempted               */
  HardFault_IRQn            = -13,              /*!< -13  Hard Fault, all classes of Fault                                     */
  SVCall_IRQn               =  -5,              /*!< -5 System Service Call via SVC instruction                                */
  PendSV_IRQn               =  -2,              /*!< -2 Pendable request for system service                                    */
  SysTick_IRQn              =  -1,              /*!< -1 System Tick Timer                                                      */
/* =========================================  dpm32m030 Specific Interrupt Numbers  ========================================== */
  WDG_IRQn                  =   0,              /*!< 0  WDG interrupt                                                          */
  PVD_IRQn                  =   1,              /*!< 1  PVD Interrupt                                                          */
  TIM0_IRQn                 =   2,              /*!< 2  TIM0 interrupt                                                         */
  TIM1_IRQn                 =   3,              /*!< 3  TIM1 interrupt                                                         */
  CCT0_IRQn                 =   6,              /*!< 6  CCT0 interrupt                                                         */
  EPWM_IRQn                 =   8,              /*!< 8  EPWM interrupt                                                         */
  UART0_IRQn                =  12,              /*!< 12 UART0 interrupt                                                        */
  UART1_IRQn                =  13,              /*!< 13 UART1 interrupt                                                        */
  SPI0_IRQn                 =  15,              /*!< 15 SPI0 interrupt                                                         */
  I2C_IRQn                  =  17,              /*!< 17 I2C interrupt                                                          */
  LPTIM_IRQn                =  20,              /*!< 20 LPTIM Interrupt                                                        */
  ADC0_IRQn                 =  21,              /*!< 21 ADC0 interrupt                                                         */
  GPIOA_IRQn                =  23,              /*!< 23 GPIOA interrupt                                                        */
  GPIOB_IRQn                =  24,              /*!< 24 GPIOB interrupt                                                        */
  GPIOD_IRQn                =  25,              /*!< 25 GPIOD interrupt                                                        */
  ACMP_IRQn                 =  28               /*!< 28 ACMP Interrupt                                                         */
} IRQn_Type;



/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* ===========================  Configuration of the ARM Cortex-M0 Processor and Core Peripherals  =========================== */
#define __CM0_REV                 0x0000U       /*!< CM0 Core Revision                                                         */
#define __NVIC_PRIO_BITS               2        /*!< Number of Bits used for Priority Levels                                   */
#define __Vendor_SysTickConfig         0        /*!< Set to 1 if different SysTick Config is used                              */
#define __MPU_PRESENT                  0        /*!< MPU present                                                               */
#define __FPU_PRESENT                  0        /*!< FPU present                                                               */


/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm0.h"                           /*!< ARM Cortex-M0 processor and core peripherals                              */
#include "system_dpm32m0xx.h"                   /*!< dpm32m0xx System                                                          */

#ifndef __IM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __IM   __I
#endif
#ifndef __OM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __OM   __O
#endif
#ifndef __IOM                                   /*!< Fallback for older CMSIS versions                                         */
  #define __IOM  __IO
#endif

/* bit operations */
#define REG32(addr)         (*(volatile unsigned int *)(unsigned int)(addr))
#define REG16(addr)         (*(volatile unsigned short *)(unsigned int)(addr))
#define REG8(addr)          (*(volatile unsigned char *)(unsigned int)(addr))

/* ========================================  Start of section using anonymous unions  ======================================== */
#if defined(__CC_ARM)
#pragma push
#pragma anon_unions
#elif defined(__ICCARM__)
#pragma language = extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wc11-extensions"
#pragma clang diagnostic ignored "-Wreserved-id-macro"
#pragma clang diagnostic ignored "-Wgnu-anonymous-struct"
#pragma clang diagnostic ignored "-Wnested-anon-types"
#elif defined(__GNUC__)
/* anonymous unions are enabled by default */
#elif defined(__TMS470__)
/* anonymous unions are enabled by default */
#elif defined(__TASKING__)
#pragma warning 586
#elif defined(__CSMC__)
/* anonymous unions are enabled by default */
#else
#warning Not supported compiler type
#endif

#ifdef ASSERT_DEBUG
  /**
   * @brief  The PARAM_ASSERT macro is used for function's parameters check.
   * @param  expr: If expr is false, it calls Param_AssertHandler function
   *         which reports the name of the source file and the source
   *         line number of the call that failed.
   *         If expr is true, it returns no value.
   * @retval None
   **/
#define PARAM_ASSERT(x)                                                   \
  do                                                                      \
  {                                                                       \
    ((x) ? (void)0 : Param_AssertHandler((uint8_t *)__FILE__, __LINE__)); \
  } while (0)
  /* Exported function */
  __attribute__((weak)) void Param_AssertHandler(uint8_t *file, int16_t line);
#else
#define PARAM_ASSERT(x) (void)(0)
#endif /* ASSERT_DEBUG */

  /**
  ******************************************************************************
  * @brief functional state enumeration
  *****************************************************************************/
  typedef enum
  {
    DISABLE = 0,
    ENABLE = !DISABLE
  } FunctionalState;

  /**
  ******************************************************************************
  * @brief Error status enumeration
  *****************************************************************************/
  typedef enum
  {
    ERROR = 0,
    SUCCESS = !ERROR
  } ErrorState;

  /**
  ******************************************************************************
  * @brief Flag status enumeration
  *****************************************************************************/
  typedef enum
  {
    RESET = 0,
    SET = !RESET
  } FlagState;

#define IS_FUNCTION_STATE(x) (((x) == DISABLE) || \
                              ((x) == ENABLE))

#undef NULL
#define NULL 0 /* see <stddef.h> */

/*! Memory clear */
#define MEM_CLEAR_STRUCT(x)                \
  do                                       \
  {                                        \
    memset((void *)&(x), 0L, (sizeof(x))); \
  } while (0);


/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                           GPIO                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief General-purpose I/Os (GPIO)
  */

typedef struct {                                /*!< (@ 0x40080000) GPIO Structure                                            */
  __IOM uint32_t  MODE;                         /*!< (@ 0x00000000) GPIOx port mode register (x= A,B,D) MODEi[1:0]
                                                                    (i=0~15): 00: General input mode 01: General
                                                                    output mode  10: Alternate function mode
                                                                    11: Analog mode                                            */
  __IOM uint32_t  OUT_TYPE;                     /*!< (@ 0x00000004) GPIOx port output type register (x= A,B,D)
                                                                    OTYPEi (i=0~15): 0: Output pull_push 1:
                                                                    Output open_drain                                          */
  __IOM uint32_t  OUT_SPEED;                    /*!< (@ 0x00000008) GPIOx port output speed register (x= A,B,D)
                                                                    OSPEEDi (i=0~15): 00: Very low speed 01:
                                                                    Low speed 10: High speed 11: Very high speed               */
  __IOM uint32_t  PUPD;                         /*!< (@ 0x0000000C) GPIOx port pull up/pull down register (x= A,B,D)
                                                                    PUPD[1:0]i (i=0~15): 00: No pull up, pull
                                                                    down 01: Pull-up 10: Pull-down 11: Reserved                */
  __IM  uint32_t  DATA_IN;                      /*!< (@ 0x00000010) GPIOx port input data register(x= A,B,D)                   */
  __IOM uint32_t  DATA_OUT;                     /*!< (@ 0x00000014) GPIOx port output data register(x= A,B,D)                  */
  __OM  uint32_t  BIT_SET_RST;                  /*!< (@ 0x00000018) GPIOx port output data bit set/reset register(x=
                                                                    A,B,D) Set SETi to 1 will set DOUTi to
                                                                    1 (i=0~15) Set RSTi to 1 will reset DOUTi
                                                                    to 0 (i=0~15) When set both SETi and RSTi
                                                                    to 1 for the same pin, then SETi has a higher
                                                                    priority.                                                  */
  __OM  uint32_t  BIT_RST;                      /*!< (@ 0x0000001C) GPIOx port output data bit reset register(x=
                                                                    A,B,D) Set RSTi to 1 will reset DOUTi
                                                                    to 0 (i=0~15)                                              */
  __IOM uint32_t  LOCK;                         /*!< (@ 0x00000020) GPIOx port configuration Lock register (x= A,B,D)          */
  __IOM uint32_t  AF_LOW;                       /*!< (@ 0x00000024) GPIOx alternate function low register(x= A,B,D)
                                                                    AFSELi[3:0] (i=0~7): 0000: AF0 0001: AF1
                                                                    0010: AF2 0011: AF3 0100: AF4 0101: AF5
                                                                    0110: AF6 0111: AF7 1xxx: Reserved.                        */
  __IOM uint32_t  AF_HIGH;                      /*!< (@ 0x00000028) GPIOx alternate function high register(x= A,B,D)
                                                                    AFSELi[3:0] (i=15~8): 0000: AF0 0001: AF1
                                                                    0010: AF2 0011: AF3 0100: AF4 0101: AF5
                                                                    0110: AF6 0111: AF7 1xxx: Reserved.                        */
  __IOM uint32_t  ANA_AF;                       /*!< (@ 0x0000002C) GPIOx analog alternate function register(x= A,B,D)
                                                                    ANA_AFSELi[1:0] (i=15~0): 00: AF0 01: AF1
                                                                    10: Reserved. 11: Reserved.                                */
  __IOM uint32_t  INT_EN;                       /*!< (@ 0x00000030) GPIOx interrupts enable register(x= A,B,D)
                                                                    IEi (i=15~0): 0: disable interrupt 1: enable
                                                                    interrupt                                                  */
  __IOM uint32_t  INT_TYPE_LOW;                 /*!< (@ 0x00000034) GPIOx interrupts type low register(x= A,B,D)
                                                                    INT_TYPEi (i=7~0): 000: Rising edge 001:
                                                                    Falling edge 010: High level 011: Low level
                                                                    100: Rising edge abd Falling edge 101~111:
                                                                    Reserved.                                                  */
  __IOM uint32_t  INT_TYPE_HIGH;                /*!< (@ 0x00000038) GPIOx interrupts type high register(x= A,B,D)
                                                                    INT_TYPEi (i=15~8): 000: Rising edge 001:
                                                                    Falling edge 010: High level 011: Low level
                                                                    100: Rising edge abd Falling edge 101~111:
                                                                    Reserved.                                                  */
  __IOM uint32_t  INT_SR;                       /*!< (@ 0x0000003C) GPIOx interrupts status register(x= A,B,D)
                                                                    INTi (i=15~0): 0: no interrupt occur 1:
                                                                    interrupt occured                                          */
} GPIO_Type;                                    /*!< Size = 64 (0x40)                                                          */



/* =========================================================================================================================== */
/* ================                                           UART                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief UART register (UART)
  */

typedef struct {                                /*!< (@ 0x40008000) UART  Structure                                            */
  __IOM uint32_t  CR;                           /*!< (@ 0x00000000) UART control register                                      */
  __IOM uint32_t  ISR;                          /*!< (@ 0x00000004) UART interrupt and state register                          */
  __IOM uint32_t  BRR;                          /*!< (@ 0x00000008) UART baud rate register                                    */
  __IOM uint32_t  TDR;                          /*!< (@ 0x0000000C) UART transmit data register                                */
  __IM  uint32_t  RDR;                          /*!< (@ 0x00000010) UART reception data register                               */
} UART_Type;                                   /*!< Size = 20 (0x14)                                                          */



/* =========================================================================================================================== */
/* ================                                            RCC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Reset and Clock Control (RCC)
  */

typedef struct {                                /*!< (@ 0x40001000) RCC Structure                                              */
  __IOM uint32_t  COMMON_CR;                    /*!< (@ 0x00000000) RCC clock common configuration register                    */
  __IOM uint32_t  CLKEN_CR;                     /*!< (@ 0x00000004) RCC clock enable control register                          */
  __IM  uint32_t  RESERVED[2];
  __IOM uint32_t  RESET_SR;                     /*!< (@ 0x00000010) RCC reset source state register                            */
  __IOM uint32_t  LOCK_CR;                      /*!< (@ 0x00000014) RCC lock control register                                  */
  __IOM uint32_t  SYSTEM_CR;                    /*!< (@ 0x00000018) RCC system control register                                */
  __IM  uint32_t  RESERVED1;
  __IOM uint32_t  LPM_CR;                       /*!< (@ 0x00000020) RCC low power mode control register                        */
  __IOM uint32_t  DEEP_SLEEP_CR;                /*!< (@ 0x00000024) RCC deep sleep mode control register                            */
  __IM  uint32_t  RESERVED2;
  __IOM uint32_t  STOP_CR;                      /*!< (@ 0x0000002C) RCC stop mode control register                             */
} RCC_Type;                                     /*!< Size = 48 (0x30)                                                          */



/* =========================================================================================================================== */
/* ================                                            PGA                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief PGA (PGA)
  */

typedef struct {                                /*!< (@ 0x40001070) PGA Structure                                              */
  __IOM uint32_t  CR;                           /*!< (@ 0x00000000) PGA control register                                       */
} PGA_Type;                                     /*!< Size = 4 (0x4)                                                            */



/* =========================================================================================================================== */
/* ================                                            DBG                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Debug Support (DBG)
  */

typedef struct {                                /*!< (@ 0x40001060) DBG Structure                                              */
  __IOM uint32_t  CFG;                          /*!< (@ 0x00000000) DBG configuration register                                 */
} DBG_Type;                                     /*!< Size = 4 (0x4)                                                            */



/* =========================================================================================================================== */
/* ================                                            DES                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Device Electronic Signature (DES)
  */

typedef struct {                                /*!< (@ 0x10001C10) DES Structure                                              */
  __IM  uint32_t  UID_WORD0;                    /*!< (@ 0x00000000) Unique Device ID Word 0                                    */
  __IM  uint32_t  UID_WORD1;                    /*!< (@ 0x00000004) Unique Device ID Word 1                                    */
  __IM  uint32_t  UID_WORD2;                    /*!< (@ 0x00000008) Unique Device ID Word 2                                    */
  __IM  uint32_t  DEV_INFO0;                    /*!< (@ 0x0000000C) Device information 0 register                              */
  __IM  uint32_t  DEV_INFO1;                    /*!< (@ 0x00000010) Device information 1 register                              */
} DES_Type;                                     /*!< Size = 20 (0x14)                                                          */



/* =========================================================================================================================== */
/* ================                                           TIM                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Basic-timers (TIM)
  */

typedef struct {                                /*!< (@ 0x40019000) TIM Structure                                             */
  __IOM uint32_t  CNT;                          /*!< (@ 0x00000000) TIMx_CNT_VALUE                                             */
  __IOM uint32_t  ARR;                          /*!< (@ 0x00000004) Auto-reload value                                          */
  __IOM uint32_t  CR;                           /*!< (@ 0x00000008) TIMx_CTRL                                                  */
  __IOM uint32_t  SR;                           /*!< (@ 0x0000000C) TIMx_STATUS                                                */
} TIM_Type;                                     /*!< Size = 16 (0x10)                                                          */



/* =========================================================================================================================== */
/* ================                                           CCT                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Capture/Compare Timer (CCT)
  */

typedef struct {                                /*!< (@ 0x4001F000) CCT Structure                                             */
  __IM  uint32_t  CNT;                          /*!< (@ 0x00000000) CCTx_CNTR_VALUE                                            */
  __IOM uint32_t  ARR;                          /*!< (@ 0x00000004) CCTx _LOAD_VALUE                                           */
  __IOM uint32_t  CR;                           /*!< (@ 0x00000008) CCTx_CTRL                                                  */
  __IOM uint32_t  SR;                           /*!< (@ 0x0000000C) CCTx_STATUS                                                */
  __IOM uint32_t  CAP_CFG;                      /*!< (@ 0x00000010) CCTx_CAP_CFG                                               */
  __IOM uint32_t  CMP_CFG;                      /*!< (@ 0x00000014) CCTx_CMP_CFG                                               */
  __IOM uint32_t  CH0_VALUE;                    /*!< (@ 0x00000018) CCTx_CH0_VALUE                                             */
  __IOM uint32_t  CH1_VALUE;                    /*!< (@ 0x0000001C) CCTx_CH1_VALUE                                             */
  __IOM uint32_t  CH2_VALUE;                    /*!< (@ 0x00000020) CCTx_CH2_VALUE                                             */
} CCT_Type;                                    /*!< Size = 36 (0x24)                                                          */
                                 /*!< Size = 36 (0x24)                                                          */



/* =========================================================================================================================== */
/* ================                                           EPWM                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief EPWM registers (EPWM)
  */

typedef struct {                                /*!< (@ 0x40023000) EPWM Structure                                             */
  __IM  uint32_t  CNT;                          /*!< (@ 0x00000000) Counter value                                              */
  __IOM uint32_t  ARR;                          /*!< (@ 0x00000004) Auto-reload value register                                 */
  __IOM uint32_t  CR;                           /*!< (@ 0x00000008) Control register                                           */
  __IOM uint32_t  SR;                           /*!< (@ 0x0000000C) Status register                                            */
  __IOM uint32_t  CMP_CFG;                      /*!< (@ 0x00000010) Comparison value configuration                             */
  __IOM uint32_t  ADC_CMP1;                     /*!< (@ 0x00000014) ADC comparison value 1                                     */
  __IOM uint32_t  ADC_CMP2;                     /*!< (@ 0x00000018) ADC comparison value 2                                     */
  __IOM uint32_t  CH0_CMP1;                     /*!< (@ 0x0000001C) Channel0 comparison value 1                                */
  __IOM uint32_t  CH0_CMP2;                     /*!< (@ 0x00000020) Channel0 comparison value 2                                */
  __IOM uint32_t  CH1_CMP1;                     /*!< (@ 0x00000024) Channel1 comparison value 1                                */
  __IOM uint32_t  CH1_CMP2;                     /*!< (@ 0x00000028) Channel1 comparison value 2                                */
  __IOM uint32_t  CH2_CMP1;                     /*!< (@ 0x0000002C) Channel2 comparison value 1                                */
  __IOM uint32_t  CH2_CMP2;                     /*!< (@ 0x00000030) Channel2 comparison value 2                                */
  __IM  uint32_t  RESERVED[2];
  __OM  uint32_t  UPDATE;                       /*!< (@ 0x0000003C) Update shadow registers                                    */
  __IOM uint32_t  CH_CR;                        /*!< (@ 0x00000040) Channel control                                            */
  __IOM uint32_t  OUT_CR;                       /*!< (@ 0x00000044) Output control register                                    */
  __IOM uint32_t  DT_CR;                        /*!< (@ 0x00000048) Dead zone time control register                            */
  __IOM uint32_t  STOP_CR;                      /*!< (@ 0x0000004C) Stop control register                                      */
  __IOM uint32_t  STOP_SR;                      /*!< (@ 0x00000050) Stop status register                                       */
  __IOM uint32_t  LOCK;                         /*!< (@ 0x00000054) Lock register                                              */
} EPWM_Type;                                    /*!< Size = 92 (0x5c)                                                          */



/* =========================================================================================================================== */
/* ================                                            WDG                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief WATCH_DOOR_DOG (WDG)
  */

typedef struct {                                /*!< (@ 0x40027000) WDG Structure                                              */
  __IOM uint32_t  CSR;                          /*!< (@ 0x00000000) WDG_CONT_STATUE                                            */
  __OM  uint32_t  CLR;                          /*!< (@ 0x00000004) WDG_CLEAR                                                  */
} WDG_Type;                                     /*!< Size = 8 (0x8)                                                            */



/* =========================================================================================================================== */
/* ================                                           LPTIM                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief LPTIM (LPTIM)
  */

typedef struct {                                /*!< (@ 0x4002D000) LPTIM Structure                                            */
  __IOM uint32_t  CR;                           /*!< (@ 0x00000000) LPTIM_CTRL                                                 */
  __IOM uint32_t  SR;                           /*!< (@ 0x00000004) LPTIM_STATUS                                               */
  __IM  uint32_t  WAKEUP_CR;                    /*!< (@ 0x00000008) LPTIM_WAKEUP_CNTR                                          */
  __IOM uint32_t  WAKEUP_PERIOD;                /*!< (@ 0x0000000C) LPTIM WAKEUP PERIOD                                        */
} LPTIM_Type;                                   /*!< Size = 16 (0x10)                                                          */



/* =========================================================================================================================== */
/* ================                                           SPI                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief SPI (SPI)
  */

typedef struct {                                /*!< (@ 0x4000E000) SPI Structure                                             */
  __IOM uint32_t  CR;                           /*!< (@ 0x00000000) SPI control register                                       */
  __IOM uint32_t  ISR;                          /*!< (@ 0x00000004) SPI interrupt and state register                           */
  __IOM uint32_t  BRR;                          /*!< (@ 0x00000008) SPI baud rate register                                     */
  __IOM uint32_t  TDR;                          /*!< (@ 0x0000000C) SPI trasmit data register                                  */
  __IM  uint32_t  RDR;                          /*!< (@ 0x00000010) SPI receive data register                                  */
} SPI_Type;                                    /*!< Size = 20 (0x14)                                                          */



/* =========================================================================================================================== */
/* ================                                            CRC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Cyclic Redundancy Check Unit (CRC)
  */

typedef struct {                                /*!< (@ 0x4003C000) CRC Structure                                              */
  __IOM uint32_t  CR;                           /*!< (@ 0x00000000) CRC_CTRL                                                   */
  __IOM uint32_t  DATA;                         /*!< (@ 0x00000004) CRC_DATA                                                   */
  __IOM uint32_t  INIT;                         /*!< (@ 0x00000008) CRC_INIT                                                   */
  __IM  uint32_t  RESULT;                       /*!< (@ 0x0000000C) CRC_RESULT                                                 */
} CRC_Type;                                     /*!< Size = 16 (0x10)                                                          */



/* =========================================================================================================================== */
/* ================                                          ADC_COM                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief ADC COM REG (ADC_COM)
  */

typedef struct {                                /*!< (@ 0x40033000) ADC_COM Structure                                          */
  __IOM uint32_t  CR;                           /*!< (@ 0x00000000) ADC Common Control Register                                */
  __IOM uint32_t  SMPT;                         /*!< (@ 0x00000004) ADC Channel Sample Time Register                           */
  __IOM uint32_t  SMPC;                         /*!< (@ 0x00000008) ADC Channel Oversampling and Precision Register            */
  __IM  uint32_t  RESERVED[5];
  __IOM uint32_t  CH_OFFSET[3];                 /*!< (@ 0x00000020) ADC Channel Offset Value Register x (x=0~2)                */
} ADC_COM_Type;                                 /*!< Size = 44 (0x2C)                                                          */



/* =========================================================================================================================== */
/* ================                                           ADC                                             ================ */
/* =========================================================================================================================== */


/**
  * @brief ADC registers (ADC)
  */

typedef struct {                                /*!< (@ 0x40033100) ADC Structure                                              */
  __IOM uint32_t  ISR;                          /*!< (@ 0x00000000) ADC Interrupt State Register                               */
  __IOM uint32_t  IE;                           /*!< (@ 0x00000004) ADC Interrupt Enable Register                              */
  __IOM uint32_t  CFG;                          /*!< (@ 0x00000008) ADC Configuration Register                                 */
  __IOM uint32_t  FMT_CR;                       /*!< (@ 0x0000000C) ADC Format Config Register                                 */
  __IOM uint32_t  TRIG_CR;                      /*!< (@ 0x00000010) ADC Trigger Control Register                               */
  __IOM uint32_t  INJ_CR;                       /*!< (@ 0x00000014) ADC Inject Control Register                                */
  __IM  uint32_t  RESERVED1[2];
  __IOM uint32_t  SCAN_SQR0;                    /*!< (@ 0x00000020) ADC Channel Sample Sequence Register 0                     */
  __IOM uint32_t  SCAN_SQR1;                    /*!< (@ 0x00000024) ADC Channel Sample Sequence Register 1                     */
  __IM  uint32_t  RESERVED2;
  __IM  uint32_t  DR_INJ;                       /*!< (@ 0x0000002C) ADC Inject Sample Data Register                            */
  __IM  uint32_t  DR_TRIG0;                     /*!< (@ 0x00000030) ADC Trigger Sample Data Register 0                         */
  __IM  uint32_t  RESERVED3;
  __IM  uint32_t  DR_SCAN[10];                  /*!< (@ 0x00000038) ADC Sequence Sample Data Register n (n=0~9)                */
} ADC_Type;                                     /*!< Size = 96 (0x60)                                                          */



/* =========================================================================================================================== */
/* ================                                            I2C                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief I2C registers (I2C)
  */

typedef struct {                                /*!< (@ 0x40012000) I2C Structure                                              */
  __IOM uint32_t  CR1;                          /*!< (@ 0x00000000) I2C control register 1                                     */
  __IOM uint32_t  CR2;                          /*!< (@ 0x00000004) I2C control register 2                                     */
  __IOM uint32_t  ISR;                          /*!< (@ 0x00000008) I2C interrupt and status register                          */
  __IOM uint32_t  TIMING;                       /*!< (@ 0x0000000C) I2C timing register                                        */
  __IOM uint32_t  OAR;                          /*!< (@ 0x00000010) I2C own address register                                   */
  __IOM uint32_t  TDR;                          /*!< (@ 0x00000014) I2C Transmit data register                                 */
  __IM  uint32_t  RDR;                          /*!< (@ 0x00000018) I2C Receive data register                                  */
} I2C_Type;                                     /*!< Size = 28 (0x1c)                                                          */



/* =========================================================================================================================== */
/* ================                                           ACMP                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Analog Comparator (ACMP)
  */

typedef struct {                                /*!< (@ 0x4003A000) ACMP Structure                                             */
  __IOM uint32_t  CR;                           /*!< (@ 0x00000000) ACMP control register                                      */
  __IOM uint32_t  SR;                           /*!< (@ 0x00000004) ACMP status register                                       */
  __IOM uint32_t  ACMP0_CFG;                    /*!< (@ 0x00000008) ACMP0 configuration register                               */
  __IOM uint32_t  ACMP1_CFG;                    /*!< (@ 0x0000000C) ACMP1 configuration register                               */
} ACMP_Type;                                    /*!< Size = 16 (0x10)                                                          */



/* =========================================================================================================================== */
/* ================                                           FLASH                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Flash Controler (FLASH)
  */

typedef struct {                                /*!< (@ 0x40089000) FLASH Structure                                            */
  __IOM uint32_t  CR;                           /*!< (@ 0x00000000) Flash control register                                     */
  __IOM uint32_t  ADDR;                         /*!< (@ 0x00000004) Flash program or page erase address register               */
  __IOM uint32_t  DATA;                         /*!< (@ 0x00000008) Flash program data register                                */
  __IOM uint32_t  CR_LOCK;                      /*!< (@ 0x0000000C) Flash config registers lock register                       */
  __IOM uint32_t  SR;                           /*!< (@ 0x00000010) Flash status register                                      */
  __IOM uint32_t  FAC_REC;                      /*!< (@ 0x00000014) Flash factory mode recovery register                       */
} FLASH_Type;                                   /*!< Size = 24 (0x18)                                                          */



/* =========================================================================================================================== */
/* ================                                            PVD                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Power Voltage Detector (PVD)
  */

typedef struct {                                /*!< (@ 0x40039000) PVD Structure                                              */
  __IOM uint32_t  CR;                           /*!< (@ 0x00000000) PVD_CR                                                     */
  __IOM uint32_t  SR;                           /*!< (@ 0x00000004) PVD_SR                                                     */
} PVD_Type;                                     /*!< Size = 8 (0x8)                                                            */


/** @} */ /* End of group Device_Peripheral_peripherals */


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripheralAddr
  * @{
  */

#define GPIOA_BASE                  0x40080000UL
#define GPIOB_BASE                  0x40081000UL
#define GPIOD_BASE                  0x40083000UL
#define UART0_BASE                  0x40008000UL
#define UART1_BASE                  0x40009000UL
#define RCC_BASE                    0x40001000UL
#define PGA_BASE                    0x40001070UL
#define DBG_BASE                    0x40001060UL
#define DES_BASE                    0x10001C10UL
#define TIM0_BASE                   0x40019000UL
#define TIM1_BASE                   0x4001A000UL
#define CCT0_BASE                   0x4001F000UL
#define EPWM_BASE                   0x40023000UL
#define WDG_BASE                    0x40027000UL
#define LPTIM_BASE                  0x4002D000UL
#define SPI0_BASE                   0x4000E000UL
#define CRC_BASE                    0x4003C000UL
#define ADC_COM_BASE                0x40033000UL
#define ADC0_BASE                   0x40033100UL
#define I2C_BASE                    0x40012000UL
#define ACMP_BASE                   0x4003A000UL
#define FLASH_BASE                  0x40089000UL
#define PVD_BASE                    0x40039000UL

/** @} */ /* End of group Device_Peripheral_peripheralAddr */


/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_declaration
  * @{
  */

#define GPIOA                       ((GPIO_Type*)              GPIOA_BASE)
#define GPIOB                       ((GPIO_Type*)              GPIOB_BASE)
#define GPIOD                       ((GPIO_Type*)              GPIOD_BASE)
#define UART0                       ((UART_Type*)              UART0_BASE)
#define UART1                       ((UART_Type*)              UART1_BASE)
#define RCC                         ((RCC_Type*)               RCC_BASE)
#define PGA                         ((PGA_Type*)               PGA_BASE)
#define DBG                         ((DBG_Type*)               DBG_BASE)
#define DES                         ((DES_Type*)               DES_BASE)
#define TIM0                        ((TIM_Type*)               TIM0_BASE)
#define TIM1                        ((TIM_Type*)               TIM1_BASE)
#define CCT0                        ((CCT_Type*)               CCT0_BASE)
#define EPWM                        ((EPWM_Type*)              EPWM_BASE)
#define WDG                         ((WDG_Type*)               WDG_BASE)
#define LPTIM                       ((LPTIM_Type*)             LPTIM_BASE)
#define SPI0                        ((SPI_Type*)               SPI0_BASE)
#define CRC                         ((CRC_Type*)               CRC_BASE)
#define ADC_COM                     ((ADC_COM_Type*)           ADC_COM_BASE)
#define ADC0                        ((ADC_Type*)               ADC0_BASE)
#define I2C                         ((I2C_Type*)               I2C_BASE)
#define ACMP                        ((ACMP_Type*)              ACMP_BASE)
#define FLASH                       ((FLASH_Type*)             FLASH_BASE)
#define PVD                         ((PVD_Type*)               PVD_BASE)

/** @} */ /* End of group Device_Peripheral_declaration */
/* =========================================  End of section using anonymous unions  ========================================= */
#if defined (__CC_ARM)
  #pragma pop
#elif defined (__ICCARM__)
  /* leave anonymous unions enabled */
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning restore
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#endif


/* =========================================================================================================================== */
/* ================                                Pos/Mask Peripheral Section                                ================ */
/* =========================================================================================================================== */


/** @addtogroup PosMask_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                           GPIO                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  MODE  ========================================================== */
#define GPIO_MODE_MODE15_Pos              (30UL)                    /*!< MODE15 (Bit 30)                                       */
#define GPIO_MODE_MODE15_Msk              (0xc0000000UL)            /*!< MODE15 (Bitfield-Mask: 0x03)                          */
#define GPIO_MODE_MODE14_Pos              (28UL)                    /*!< MODE14 (Bit 28)                                       */
#define GPIO_MODE_MODE14_Msk              (0x30000000UL)            /*!< MODE14 (Bitfield-Mask: 0x03)                          */
#define GPIO_MODE_MODE13_Pos              (26UL)                    /*!< MODE13 (Bit 26)                                       */
#define GPIO_MODE_MODE13_Msk              (0xc000000UL)             /*!< MODE13 (Bitfield-Mask: 0x03)                          */
#define GPIO_MODE_MODE12_Pos              (24UL)                    /*!< MODE12 (Bit 24)                                       */
#define GPIO_MODE_MODE12_Msk              (0x3000000UL)             /*!< MODE12 (Bitfield-Mask: 0x03)                          */
#define GPIO_MODE_MODE11_Pos              (22UL)                    /*!< MODE11 (Bit 22)                                       */
#define GPIO_MODE_MODE11_Msk              (0xc00000UL)              /*!< MODE11 (Bitfield-Mask: 0x03)                          */
#define GPIO_MODE_MODE10_Pos              (20UL)                    /*!< MODE10 (Bit 20)                                       */
#define GPIO_MODE_MODE10_Msk              (0x300000UL)              /*!< MODE10 (Bitfield-Mask: 0x03)                          */
#define GPIO_MODE_MODE9_Pos               (18UL)                    /*!< MODE9 (Bit 18)                                        */
#define GPIO_MODE_MODE9_Msk               (0xc0000UL)               /*!< MODE9 (Bitfield-Mask: 0x03)                           */
#define GPIO_MODE_MODE8_Pos               (16UL)                    /*!< MODE8 (Bit 16)                                        */
#define GPIO_MODE_MODE8_Msk               (0x30000UL)               /*!< MODE8 (Bitfield-Mask: 0x03)                           */
#define GPIO_MODE_MODE7_Pos               (14UL)                    /*!< MODE7 (Bit 14)                                        */
#define GPIO_MODE_MODE7_Msk               (0xc000UL)                /*!< MODE7 (Bitfield-Mask: 0x03)                           */
#define GPIO_MODE_MODE6_Pos               (12UL)                    /*!< MODE6 (Bit 12)                                        */
#define GPIO_MODE_MODE6_Msk               (0x3000UL)                /*!< MODE6 (Bitfield-Mask: 0x03)                           */
#define GPIO_MODE_MODE5_Pos               (10UL)                    /*!< MODE5 (Bit 10)                                        */
#define GPIO_MODE_MODE5_Msk               (0xc00UL)                 /*!< MODE5 (Bitfield-Mask: 0x03)                           */
#define GPIO_MODE_MODE4_Pos               (8UL)                     /*!< MODE4 (Bit 8)                                         */
#define GPIO_MODE_MODE4_Msk               (0x300UL)                 /*!< MODE4 (Bitfield-Mask: 0x03)                           */
#define GPIO_MODE_MODE3_Pos               (6UL)                     /*!< MODE3 (Bit 6)                                         */
#define GPIO_MODE_MODE3_Msk               (0xc0UL)                  /*!< MODE3 (Bitfield-Mask: 0x03)                           */
#define GPIO_MODE_MODE2_Pos               (4UL)                     /*!< MODE2 (Bit 4)                                         */
#define GPIO_MODE_MODE2_Msk               (0x30UL)                  /*!< MODE2 (Bitfield-Mask: 0x03)                           */
#define GPIO_MODE_MODE1_Pos               (2UL)                     /*!< MODE1 (Bit 2)                                         */
#define GPIO_MODE_MODE1_Msk               (0xcUL)                   /*!< MODE1 (Bitfield-Mask: 0x03)                           */
#define GPIO_MODE_MODE0_Pos               (0UL)                     /*!< MODE0 (Bit 0)                                         */
#define GPIO_MODE_MODE0_Msk               (0x3UL)                   /*!< MODE0 (Bitfield-Mask: 0x03)                           */
/* =======================================================  OUT_TYPE  ======================================================== */
#define GPIO_OUT_TYPE_OTYPE15_Pos         (15UL)                    /*!< OTYPE15 (Bit 15)                                      */
#define GPIO_OUT_TYPE_OTYPE15_Msk         (0x8000UL)                /*!< OTYPE15 (Bitfield-Mask: 0x01)                         */
#define GPIO_OUT_TYPE_OTYPE14_Pos         (14UL)                    /*!< OTYPE14 (Bit 14)                                      */
#define GPIO_OUT_TYPE_OTYPE14_Msk         (0x4000UL)                /*!< OTYPE14 (Bitfield-Mask: 0x01)                         */
#define GPIO_OUT_TYPE_OTYPE13_Pos         (13UL)                    /*!< OTYPE13 (Bit 13)                                      */
#define GPIO_OUT_TYPE_OTYPE13_Msk         (0x2000UL)                /*!< OTYPE13 (Bitfield-Mask: 0x01)                         */
#define GPIO_OUT_TYPE_OTYPE12_Pos         (12UL)                    /*!< OTYPE12 (Bit 12)                                      */
#define GPIO_OUT_TYPE_OTYPE12_Msk         (0x1000UL)                /*!< OTYPE12 (Bitfield-Mask: 0x01)                         */
#define GPIO_OUT_TYPE_OTYPE11_Pos         (11UL)                    /*!< OTYPE11 (Bit 11)                                      */
#define GPIO_OUT_TYPE_OTYPE11_Msk         (0x800UL)                 /*!< OTYPE11 (Bitfield-Mask: 0x01)                         */
#define GPIO_OUT_TYPE_OTYPE10_Pos         (10UL)                    /*!< OTYPE10 (Bit 10)                                      */
#define GPIO_OUT_TYPE_OTYPE10_Msk         (0x400UL)                 /*!< OTYPE10 (Bitfield-Mask: 0x01)                         */
#define GPIO_OUT_TYPE_OTYPE9_Pos          (9UL)                     /*!< OTYPE9 (Bit 9)                                        */
#define GPIO_OUT_TYPE_OTYPE9_Msk          (0x200UL)                 /*!< OTYPE9 (Bitfield-Mask: 0x01)                          */
#define GPIO_OUT_TYPE_OTYPE8_Pos          (8UL)                     /*!< OTYPE8 (Bit 8)                                        */
#define GPIO_OUT_TYPE_OTYPE8_Msk          (0x100UL)                 /*!< OTYPE8 (Bitfield-Mask: 0x01)                          */
#define GPIO_OUT_TYPE_OTYPE7_Pos          (7UL)                     /*!< OTYPE7 (Bit 7)                                        */
#define GPIO_OUT_TYPE_OTYPE7_Msk          (0x80UL)                  /*!< OTYPE7 (Bitfield-Mask: 0x01)                          */
#define GPIO_OUT_TYPE_OTYPE6_Pos          (6UL)                     /*!< OTYPE6 (Bit 6)                                        */
#define GPIO_OUT_TYPE_OTYPE6_Msk          (0x40UL)                  /*!< OTYPE6 (Bitfield-Mask: 0x01)                          */
#define GPIO_OUT_TYPE_OTYPE5_Pos          (5UL)                     /*!< OTYPE5 (Bit 5)                                        */
#define GPIO_OUT_TYPE_OTYPE5_Msk          (0x20UL)                  /*!< OTYPE5 (Bitfield-Mask: 0x01)                          */
#define GPIO_OUT_TYPE_OTYPE4_Pos          (4UL)                     /*!< OTYPE4 (Bit 4)                                        */
#define GPIO_OUT_TYPE_OTYPE4_Msk          (0x10UL)                  /*!< OTYPE4 (Bitfield-Mask: 0x01)                          */
#define GPIO_OUT_TYPE_OTYPE3_Pos          (3UL)                     /*!< OTYPE3 (Bit 3)                                        */
#define GPIO_OUT_TYPE_OTYPE3_Msk          (0x8UL)                   /*!< OTYPE3 (Bitfield-Mask: 0x01)                          */
#define GPIO_OUT_TYPE_OTYPE2_Pos          (2UL)                     /*!< OTYPE2 (Bit 2)                                        */
#define GPIO_OUT_TYPE_OTYPE2_Msk          (0x4UL)                   /*!< OTYPE2 (Bitfield-Mask: 0x01)                          */
#define GPIO_OUT_TYPE_OTYPE1_Pos          (1UL)                     /*!< OTYPE1 (Bit 1)                                        */
#define GPIO_OUT_TYPE_OTYPE1_Msk          (0x2UL)                   /*!< OTYPE1 (Bitfield-Mask: 0x01)                          */
#define GPIO_OUT_TYPE_OTYPE0_Pos          (0UL)                     /*!< OTYPE0 (Bit 0)                                        */
#define GPIO_OUT_TYPE_OTYPE0_Msk          (0x1UL)                   /*!< OTYPE0 (Bitfield-Mask: 0x01)                          */
/* =======================================================  OUT_SPEED  ======================================================= */
#define GPIO_OUT_SPEED_OSPEED15_Pos       (30UL)                    /*!< OSPEED15 (Bit 30)                                     */
#define GPIO_OUT_SPEED_OSPEED15_Msk       (0xc0000000UL)            /*!< OSPEED15 (Bitfield-Mask: 0x03)                        */
#define GPIO_OUT_SPEED_OSPEED14_Pos       (28UL)                    /*!< OSPEED14 (Bit 28)                                     */
#define GPIO_OUT_SPEED_OSPEED14_Msk       (0x30000000UL)            /*!< OSPEED14 (Bitfield-Mask: 0x03)                        */
#define GPIO_OUT_SPEED_OSPEED13_Pos       (26UL)                    /*!< OSPEED13 (Bit 26)                                     */
#define GPIO_OUT_SPEED_OSPEED13_Msk       (0xc000000UL)             /*!< OSPEED13 (Bitfield-Mask: 0x03)                        */
#define GPIO_OUT_SPEED_OSPEED12_Pos       (24UL)                    /*!< OSPEED12 (Bit 24)                                     */
#define GPIO_OUT_SPEED_OSPEED12_Msk       (0x3000000UL)             /*!< OSPEED12 (Bitfield-Mask: 0x03)                        */
#define GPIO_OUT_SPEED_OSPEED11_Pos       (22UL)                    /*!< OSPEED11 (Bit 22)                                     */
#define GPIO_OUT_SPEED_OSPEED11_Msk       (0xc00000UL)              /*!< OSPEED11 (Bitfield-Mask: 0x03)                        */
#define GPIO_OUT_SPEED_OSPEED10_Pos       (20UL)                    /*!< OSPEED10 (Bit 20)                                     */
#define GPIO_OUT_SPEED_OSPEED10_Msk       (0x300000UL)              /*!< OSPEED10 (Bitfield-Mask: 0x03)                        */
#define GPIO_OUT_SPEED_OSPEED9_Pos        (18UL)                    /*!< OSPEED9 (Bit 18)                                      */
#define GPIO_OUT_SPEED_OSPEED9_Msk        (0xc0000UL)               /*!< OSPEED9 (Bitfield-Mask: 0x03)                         */
#define GPIO_OUT_SPEED_OSPEED8_Pos        (16UL)                    /*!< OSPEED8 (Bit 16)                                      */
#define GPIO_OUT_SPEED_OSPEED8_Msk        (0x30000UL)               /*!< OSPEED8 (Bitfield-Mask: 0x03)                         */
#define GPIO_OUT_SPEED_OSPEED7_Pos        (14UL)                    /*!< OSPEED7 (Bit 14)                                      */
#define GPIO_OUT_SPEED_OSPEED7_Msk        (0xc000UL)                /*!< OSPEED7 (Bitfield-Mask: 0x03)                         */
#define GPIO_OUT_SPEED_OSPEED6_Pos        (12UL)                    /*!< OSPEED6 (Bit 12)                                      */
#define GPIO_OUT_SPEED_OSPEED6_Msk        (0x3000UL)                /*!< OSPEED6 (Bitfield-Mask: 0x03)                         */
#define GPIO_OUT_SPEED_OSPEED5_Pos        (10UL)                    /*!< OSPEED5 (Bit 10)                                      */
#define GPIO_OUT_SPEED_OSPEED5_Msk        (0xc00UL)                 /*!< OSPEED5 (Bitfield-Mask: 0x03)                         */
#define GPIO_OUT_SPEED_OSPEED4_Pos        (8UL)                     /*!< OSPEED4 (Bit 8)                                       */
#define GPIO_OUT_SPEED_OSPEED4_Msk        (0x300UL)                 /*!< OSPEED4 (Bitfield-Mask: 0x03)                         */
#define GPIO_OUT_SPEED_OSPEED3_Pos        (6UL)                     /*!< OSPEED3 (Bit 6)                                       */
#define GPIO_OUT_SPEED_OSPEED3_Msk        (0xc0UL)                  /*!< OSPEED3 (Bitfield-Mask: 0x03)                         */
#define GPIO_OUT_SPEED_OSPEED2_Pos        (4UL)                     /*!< OSPEED2 (Bit 4)                                       */
#define GPIO_OUT_SPEED_OSPEED2_Msk        (0x30UL)                  /*!< OSPEED2 (Bitfield-Mask: 0x03)                         */
#define GPIO_OUT_SPEED_OSPEED1_Pos        (2UL)                     /*!< OSPEED1 (Bit 2)                                       */
#define GPIO_OUT_SPEED_OSPEED1_Msk        (0xcUL)                   /*!< OSPEED1 (Bitfield-Mask: 0x03)                         */
#define GPIO_OUT_SPEED_OSPEED0_Pos        (0UL)                     /*!< OSPEED0 (Bit 0)                                       */
#define GPIO_OUT_SPEED_OSPEED0_Msk        (0x3UL)                   /*!< OSPEED0 (Bitfield-Mask: 0x03)                         */
/* =========================================================  PUPD  ========================================================== */
#define GPIO_PUPD_PUPD15_Pos              (30UL)                    /*!< PUPD15 (Bit 30)                                       */
#define GPIO_PUPD_PUPD15_Msk              (0xc0000000UL)            /*!< PUPD15 (Bitfield-Mask: 0x03)                          */
#define GPIO_PUPD_PUPD14_Pos              (28UL)                    /*!< PUPD14 (Bit 28)                                       */
#define GPIO_PUPD_PUPD14_Msk              (0x30000000UL)            /*!< PUPD14 (Bitfield-Mask: 0x03)                          */
#define GPIO_PUPD_PUPD13_Pos              (26UL)                    /*!< PUPD13 (Bit 26)                                       */
#define GPIO_PUPD_PUPD13_Msk              (0xc000000UL)             /*!< PUPD13 (Bitfield-Mask: 0x03)                          */
#define GPIO_PUPD_PUPD12_Pos              (24UL)                    /*!< PUPD12 (Bit 24)                                       */
#define GPIO_PUPD_PUPD12_Msk              (0x3000000UL)             /*!< PUPD12 (Bitfield-Mask: 0x03)                          */
#define GPIO_PUPD_PUPD11_Pos              (22UL)                    /*!< PUPD11 (Bit 22)                                       */
#define GPIO_PUPD_PUPD11_Msk              (0xc00000UL)              /*!< PUPD11 (Bitfield-Mask: 0x03)                          */
#define GPIO_PUPD_PUPD10_Pos              (20UL)                    /*!< PUPD10 (Bit 20)                                       */
#define GPIO_PUPD_PUPD10_Msk              (0x300000UL)              /*!< PUPD10 (Bitfield-Mask: 0x03)                          */
#define GPIO_PUPD_PUPD9_Pos               (18UL)                    /*!< PUPD9 (Bit 18)                                        */
#define GPIO_PUPD_PUPD9_Msk               (0xc0000UL)               /*!< PUPD9 (Bitfield-Mask: 0x03)                           */
#define GPIO_PUPD_PUPD8_Pos               (16UL)                    /*!< PUPD8 (Bit 16)                                        */
#define GPIO_PUPD_PUPD8_Msk               (0x30000UL)               /*!< PUPD8 (Bitfield-Mask: 0x03)                           */
#define GPIO_PUPD_PUPD7_Pos               (14UL)                    /*!< PUPD7 (Bit 14)                                        */
#define GPIO_PUPD_PUPD7_Msk               (0xc000UL)                /*!< PUPD7 (Bitfield-Mask: 0x03)                           */
#define GPIO_PUPD_PUPD6_Pos               (12UL)                    /*!< PUPD6 (Bit 12)                                        */
#define GPIO_PUPD_PUPD6_Msk               (0x3000UL)                /*!< PUPD6 (Bitfield-Mask: 0x03)                           */
#define GPIO_PUPD_PUPD5_Pos               (10UL)                    /*!< PUPD5 (Bit 10)                                        */
#define GPIO_PUPD_PUPD5_Msk               (0xc00UL)                 /*!< PUPD5 (Bitfield-Mask: 0x03)                           */
#define GPIO_PUPD_PUPD4_Pos               (8UL)                     /*!< PUPD4 (Bit 8)                                         */
#define GPIO_PUPD_PUPD4_Msk               (0x300UL)                 /*!< PUPD4 (Bitfield-Mask: 0x03)                           */
#define GPIO_PUPD_PUPD3_Pos               (6UL)                     /*!< PUPD3 (Bit 6)                                         */
#define GPIO_PUPD_PUPD3_Msk               (0xc0UL)                  /*!< PUPD3 (Bitfield-Mask: 0x03)                           */
#define GPIO_PUPD_PUPD2_Pos               (4UL)                     /*!< PUPD2 (Bit 4)                                         */
#define GPIO_PUPD_PUPD2_Msk               (0x30UL)                  /*!< PUPD2 (Bitfield-Mask: 0x03)                           */
#define GPIO_PUPD_PUPD1_Pos               (2UL)                     /*!< PUPD1 (Bit 2)                                         */
#define GPIO_PUPD_PUPD1_Msk               (0xcUL)                   /*!< PUPD1 (Bitfield-Mask: 0x03)                           */
#define GPIO_PUPD_PUPD0_Pos               (0UL)                     /*!< PUPD0 (Bit 0)                                         */
#define GPIO_PUPD_PUPD0_Msk               (0x3UL)                   /*!< PUPD0 (Bitfield-Mask: 0x03)                           */
/* ========================================================  DATA_IN  ======================================================== */
#define GPIO_DATA_IN_DIN15_Pos            (15UL)                    /*!< DIN15 (Bit 15)                                        */
#define GPIO_DATA_IN_DIN15_Msk            (0x8000UL)                /*!< DIN15 (Bitfield-Mask: 0x01)                           */
#define GPIO_DATA_IN_DIN14_Pos            (14UL)                    /*!< DIN14 (Bit 14)                                        */
#define GPIO_DATA_IN_DIN14_Msk            (0x4000UL)                /*!< DIN14 (Bitfield-Mask: 0x01)                           */
#define GPIO_DATA_IN_DIN13_Pos            (13UL)                    /*!< DIN13 (Bit 13)                                        */
#define GPIO_DATA_IN_DIN13_Msk            (0x2000UL)                /*!< DIN13 (Bitfield-Mask: 0x01)                           */
#define GPIO_DATA_IN_DIN12_Pos            (12UL)                    /*!< DIN12 (Bit 12)                                        */
#define GPIO_DATA_IN_DIN12_Msk            (0x1000UL)                /*!< DIN12 (Bitfield-Mask: 0x01)                           */
#define GPIO_DATA_IN_DIN11_Pos            (11UL)                    /*!< DIN11 (Bit 11)                                        */
#define GPIO_DATA_IN_DIN11_Msk            (0x800UL)                 /*!< DIN11 (Bitfield-Mask: 0x01)                           */
#define GPIO_DATA_IN_DIN10_Pos            (10UL)                    /*!< DIN10 (Bit 10)                                        */
#define GPIO_DATA_IN_DIN10_Msk            (0x400UL)                 /*!< DIN10 (Bitfield-Mask: 0x01)                           */
#define GPIO_DATA_IN_DIN9_Pos             (9UL)                     /*!< DIN9 (Bit 9)                                          */
#define GPIO_DATA_IN_DIN9_Msk             (0x200UL)                 /*!< DIN9 (Bitfield-Mask: 0x01)                            */
#define GPIO_DATA_IN_DIN8_Pos             (8UL)                     /*!< DIN8 (Bit 8)                                          */
#define GPIO_DATA_IN_DIN8_Msk             (0x100UL)                 /*!< DIN8 (Bitfield-Mask: 0x01)                            */
#define GPIO_DATA_IN_DIN7_Pos             (7UL)                     /*!< DIN7 (Bit 7)                                          */
#define GPIO_DATA_IN_DIN7_Msk             (0x80UL)                  /*!< DIN7 (Bitfield-Mask: 0x01)                            */
#define GPIO_DATA_IN_DIN6_Pos             (6UL)                     /*!< DIN6 (Bit 6)                                          */
#define GPIO_DATA_IN_DIN6_Msk             (0x40UL)                  /*!< DIN6 (Bitfield-Mask: 0x01)                            */
#define GPIO_DATA_IN_DIN5_Pos             (5UL)                     /*!< DIN5 (Bit 5)                                          */
#define GPIO_DATA_IN_DIN5_Msk             (0x20UL)                  /*!< DIN5 (Bitfield-Mask: 0x01)                            */
#define GPIO_DATA_IN_DIN4_Pos             (4UL)                     /*!< DIN4 (Bit 4)                                          */
#define GPIO_DATA_IN_DIN4_Msk             (0x10UL)                  /*!< DIN4 (Bitfield-Mask: 0x01)                            */
#define GPIO_DATA_IN_DIN3_Pos             (3UL)                     /*!< DIN3 (Bit 3)                                          */
#define GPIO_DATA_IN_DIN3_Msk             (0x8UL)                   /*!< DIN3 (Bitfield-Mask: 0x01)                            */
#define GPIO_DATA_IN_DIN2_Pos             (2UL)                     /*!< DIN2 (Bit 2)                                          */
#define GPIO_DATA_IN_DIN2_Msk             (0x4UL)                   /*!< DIN2 (Bitfield-Mask: 0x01)                            */
#define GPIO_DATA_IN_DIN1_Pos             (1UL)                     /*!< DIN1 (Bit 1)                                          */
#define GPIO_DATA_IN_DIN1_Msk             (0x2UL)                   /*!< DIN1 (Bitfield-Mask: 0x01)                            */
#define GPIO_DATA_IN_DIN0_Pos             (0UL)                     /*!< DIN0 (Bit 0)                                          */
#define GPIO_DATA_IN_DIN0_Msk             (0x1UL)                   /*!< DIN0 (Bitfield-Mask: 0x01)                            */
/* =======================================================  DATA_OUT  ======================================================== */
#define GPIO_DATA_OUT_DOUT15_Pos          (15UL)                    /*!< DOUT15 (Bit 15)                                       */
#define GPIO_DATA_OUT_DOUT15_Msk          (0x8000UL)                /*!< DOUT15 (Bitfield-Mask: 0x01)                          */
#define GPIO_DATA_OUT_DOUT14_Pos          (14UL)                    /*!< DOUT14 (Bit 14)                                       */
#define GPIO_DATA_OUT_DOUT14_Msk          (0x4000UL)                /*!< DOUT14 (Bitfield-Mask: 0x01)                          */
#define GPIO_DATA_OUT_DOUT13_Pos          (13UL)                    /*!< DOUT13 (Bit 13)                                       */
#define GPIO_DATA_OUT_DOUT13_Msk          (0x2000UL)                /*!< DOUT13 (Bitfield-Mask: 0x01)                          */
#define GPIO_DATA_OUT_DOUT12_Pos          (12UL)                    /*!< DOUT12 (Bit 12)                                       */
#define GPIO_DATA_OUT_DOUT12_Msk          (0x1000UL)                /*!< DOUT12 (Bitfield-Mask: 0x01)                          */
#define GPIO_DATA_OUT_DOUT11_Pos          (11UL)                    /*!< DOUT11 (Bit 11)                                       */
#define GPIO_DATA_OUT_DOUT11_Msk          (0x800UL)                 /*!< DOUT11 (Bitfield-Mask: 0x01)                          */
#define GPIO_DATA_OUT_DOUT10_Pos          (10UL)                    /*!< DOUT10 (Bit 10)                                       */
#define GPIO_DATA_OUT_DOUT10_Msk          (0x400UL)                 /*!< DOUT10 (Bitfield-Mask: 0x01)                          */
#define GPIO_DATA_OUT_DOUT9_Pos           (9UL)                     /*!< DOUT9 (Bit 9)                                         */
#define GPIO_DATA_OUT_DOUT9_Msk           (0x200UL)                 /*!< DOUT9 (Bitfield-Mask: 0x01)                           */
#define GPIO_DATA_OUT_DOUT8_Pos           (8UL)                     /*!< DOUT8 (Bit 8)                                         */
#define GPIO_DATA_OUT_DOUT8_Msk           (0x100UL)                 /*!< DOUT8 (Bitfield-Mask: 0x01)                           */
#define GPIO_DATA_OUT_DOUT7_Pos           (7UL)                     /*!< DOUT7 (Bit 7)                                         */
#define GPIO_DATA_OUT_DOUT7_Msk           (0x80UL)                  /*!< DOUT7 (Bitfield-Mask: 0x01)                           */
#define GPIO_DATA_OUT_DOUT6_Pos           (6UL)                     /*!< DOUT6 (Bit 6)                                         */
#define GPIO_DATA_OUT_DOUT6_Msk           (0x40UL)                  /*!< DOUT6 (Bitfield-Mask: 0x01)                           */
#define GPIO_DATA_OUT_DOUT5_Pos           (5UL)                     /*!< DOUT5 (Bit 5)                                         */
#define GPIO_DATA_OUT_DOUT5_Msk           (0x20UL)                  /*!< DOUT5 (Bitfield-Mask: 0x01)                           */
#define GPIO_DATA_OUT_DOUT4_Pos           (4UL)                     /*!< DOUT4 (Bit 4)                                         */
#define GPIO_DATA_OUT_DOUT4_Msk           (0x10UL)                  /*!< DOUT4 (Bitfield-Mask: 0x01)                           */
#define GPIO_DATA_OUT_DOUT3_Pos           (3UL)                     /*!< DOUT3 (Bit 3)                                         */
#define GPIO_DATA_OUT_DOUT3_Msk           (0x8UL)                   /*!< DOUT3 (Bitfield-Mask: 0x01)                           */
#define GPIO_DATA_OUT_DOUT2_Pos           (2UL)                     /*!< DOUT2 (Bit 2)                                         */
#define GPIO_DATA_OUT_DOUT2_Msk           (0x4UL)                   /*!< DOUT2 (Bitfield-Mask: 0x01)                           */
#define GPIO_DATA_OUT_DOUT1_Pos           (1UL)                     /*!< DOUT1 (Bit 1)                                         */
#define GPIO_DATA_OUT_DOUT1_Msk           (0x2UL)                   /*!< DOUT1 (Bitfield-Mask: 0x01)                           */
#define GPIO_DATA_OUT_DOUT0_Pos           (0UL)                     /*!< DOUT0 (Bit 0)                                         */
#define GPIO_DATA_OUT_DOUT0_Msk           (0x1UL)                   /*!< DOUT0 (Bitfield-Mask: 0x01)                           */
/* ======================================================  BIT_SET_RST  ====================================================== */
#define GPIO_BIT_SET_RST_RST15_Pos        (31UL)                    /*!< RST15 (Bit 31)                                        */
#define GPIO_BIT_SET_RST_RST15_Msk        (0x80000000UL)            /*!< RST15 (Bitfield-Mask: 0x01)                           */
#define GPIO_BIT_SET_RST_RST14_Pos        (30UL)                    /*!< RST14 (Bit 30)                                        */
#define GPIO_BIT_SET_RST_RST14_Msk        (0x40000000UL)            /*!< RST14 (Bitfield-Mask: 0x01)                           */
#define GPIO_BIT_SET_RST_RST13_Pos        (29UL)                    /*!< RST13 (Bit 29)                                        */
#define GPIO_BIT_SET_RST_RST13_Msk        (0x20000000UL)            /*!< RST13 (Bitfield-Mask: 0x01)                           */
#define GPIO_BIT_SET_RST_RST12_Pos        (28UL)                    /*!< RST12 (Bit 28)                                        */
#define GPIO_BIT_SET_RST_RST12_Msk        (0x10000000UL)            /*!< RST12 (Bitfield-Mask: 0x01)                           */
#define GPIO_BIT_SET_RST_RST11_Pos        (27UL)                    /*!< RST11 (Bit 27)                                        */
#define GPIO_BIT_SET_RST_RST11_Msk        (0x8000000UL)             /*!< RST11 (Bitfield-Mask: 0x01)                           */
#define GPIO_BIT_SET_RST_RST10_Pos        (26UL)                    /*!< RST10 (Bit 26)                                        */
#define GPIO_BIT_SET_RST_RST10_Msk        (0x4000000UL)             /*!< RST10 (Bitfield-Mask: 0x01)                           */
#define GPIO_BIT_SET_RST_RST9_Pos         (25UL)                    /*!< RST9 (Bit 25)                                         */
#define GPIO_BIT_SET_RST_RST9_Msk         (0x2000000UL)             /*!< RST9 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_SET_RST_RST8_Pos         (24UL)                    /*!< RST8 (Bit 24)                                         */
#define GPIO_BIT_SET_RST_RST8_Msk         (0x1000000UL)             /*!< RST8 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_SET_RST_RST7_Pos         (23UL)                    /*!< RST7 (Bit 23)                                         */
#define GPIO_BIT_SET_RST_RST7_Msk         (0x800000UL)              /*!< RST7 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_SET_RST_RST6_Pos         (22UL)                    /*!< RST6 (Bit 22)                                         */
#define GPIO_BIT_SET_RST_RST6_Msk         (0x400000UL)              /*!< RST6 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_SET_RST_RST5_Pos         (21UL)                    /*!< RST5 (Bit 21)                                         */
#define GPIO_BIT_SET_RST_RST5_Msk         (0x200000UL)              /*!< RST5 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_SET_RST_RST4_Pos         (20UL)                    /*!< RST4 (Bit 20)                                         */
#define GPIO_BIT_SET_RST_RST4_Msk         (0x100000UL)              /*!< RST4 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_SET_RST_RST3_Pos         (19UL)                    /*!< RST3 (Bit 19)                                         */
#define GPIO_BIT_SET_RST_RST3_Msk         (0x80000UL)               /*!< RST3 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_SET_RST_RST2_Pos         (18UL)                    /*!< RST2 (Bit 18)                                         */
#define GPIO_BIT_SET_RST_RST2_Msk         (0x40000UL)               /*!< RST2 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_SET_RST_RST1_Pos         (17UL)                    /*!< RST1 (Bit 17)                                         */
#define GPIO_BIT_SET_RST_RST1_Msk         (0x20000UL)               /*!< RST1 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_SET_RST_RST0_Pos         (16UL)                    /*!< RST0 (Bit 16)                                         */
#define GPIO_BIT_SET_RST_RST0_Msk         (0x10000UL)               /*!< RST0 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_SET_RST_SET15_Pos        (15UL)                    /*!< SET15 (Bit 15)                                        */
#define GPIO_BIT_SET_RST_SET15_Msk        (0x8000UL)                /*!< SET15 (Bitfield-Mask: 0x01)                           */
#define GPIO_BIT_SET_RST_SET14_Pos        (14UL)                    /*!< SET14 (Bit 14)                                        */
#define GPIO_BIT_SET_RST_SET14_Msk        (0x4000UL)                /*!< SET14 (Bitfield-Mask: 0x01)                           */
#define GPIO_BIT_SET_RST_SET13_Pos        (13UL)                    /*!< SET13 (Bit 13)                                        */
#define GPIO_BIT_SET_RST_SET13_Msk        (0x2000UL)                /*!< SET13 (Bitfield-Mask: 0x01)                           */
#define GPIO_BIT_SET_RST_SET12_Pos        (12UL)                    /*!< SET12 (Bit 12)                                        */
#define GPIO_BIT_SET_RST_SET12_Msk        (0x1000UL)                /*!< SET12 (Bitfield-Mask: 0x01)                           */
#define GPIO_BIT_SET_RST_SET11_Pos        (11UL)                    /*!< SET11 (Bit 11)                                        */
#define GPIO_BIT_SET_RST_SET11_Msk        (0x800UL)                 /*!< SET11 (Bitfield-Mask: 0x01)                           */
#define GPIO_BIT_SET_RST_SET10_Pos        (10UL)                    /*!< SET10 (Bit 10)                                        */
#define GPIO_BIT_SET_RST_SET10_Msk        (0x400UL)                 /*!< SET10 (Bitfield-Mask: 0x01)                           */
#define GPIO_BIT_SET_RST_SET9_Pos         (9UL)                     /*!< SET9 (Bit 9)                                          */
#define GPIO_BIT_SET_RST_SET9_Msk         (0x200UL)                 /*!< SET9 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_SET_RST_SET8_Pos         (8UL)                     /*!< SET8 (Bit 8)                                          */
#define GPIO_BIT_SET_RST_SET8_Msk         (0x100UL)                 /*!< SET8 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_SET_RST_SET7_Pos         (7UL)                     /*!< SET7 (Bit 7)                                          */
#define GPIO_BIT_SET_RST_SET7_Msk         (0x80UL)                  /*!< SET7 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_SET_RST_SET6_Pos         (6UL)                     /*!< SET6 (Bit 6)                                          */
#define GPIO_BIT_SET_RST_SET6_Msk         (0x40UL)                  /*!< SET6 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_SET_RST_SET5_Pos         (5UL)                     /*!< SET5 (Bit 5)                                          */
#define GPIO_BIT_SET_RST_SET5_Msk         (0x20UL)                  /*!< SET5 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_SET_RST_SET4_Pos         (4UL)                     /*!< SET4 (Bit 4)                                          */
#define GPIO_BIT_SET_RST_SET4_Msk         (0x10UL)                  /*!< SET4 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_SET_RST_SET3_Pos         (3UL)                     /*!< SET3 (Bit 3)                                          */
#define GPIO_BIT_SET_RST_SET3_Msk         (0x8UL)                   /*!< SET3 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_SET_RST_SET2_Pos         (2UL)                     /*!< SET2 (Bit 2)                                          */
#define GPIO_BIT_SET_RST_SET2_Msk         (0x4UL)                   /*!< SET2 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_SET_RST_SET1_Pos         (1UL)                     /*!< SET1 (Bit 1)                                          */
#define GPIO_BIT_SET_RST_SET1_Msk         (0x2UL)                   /*!< SET1 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_SET_RST_SET0_Pos         (0UL)                     /*!< SET0 (Bit 0)                                          */
#define GPIO_BIT_SET_RST_SET0_Msk         (0x1UL)                   /*!< SET0 (Bitfield-Mask: 0x01)                            */
/* ========================================================  BIT_RST  ======================================================== */
#define GPIO_BIT_RST_RST15_Pos            (15UL)                    /*!< RST15 (Bit 15)                                        */
#define GPIO_BIT_RST_RST15_Msk            (0x8000UL)                /*!< RST15 (Bitfield-Mask: 0x01)                           */
#define GPIO_BIT_RST_RST14_Pos            (14UL)                    /*!< RST14 (Bit 14)                                        */
#define GPIO_BIT_RST_RST14_Msk            (0x4000UL)                /*!< RST14 (Bitfield-Mask: 0x01)                           */
#define GPIO_BIT_RST_RST13_Pos            (13UL)                    /*!< RST13 (Bit 13)                                        */
#define GPIO_BIT_RST_RST13_Msk            (0x2000UL)                /*!< RST13 (Bitfield-Mask: 0x01)                           */
#define GPIO_BIT_RST_RST12_Pos            (12UL)                    /*!< RST12 (Bit 12)                                        */
#define GPIO_BIT_RST_RST12_Msk            (0x1000UL)                /*!< RST12 (Bitfield-Mask: 0x01)                           */
#define GPIO_BIT_RST_RST11_Pos            (11UL)                    /*!< RST11 (Bit 11)                                        */
#define GPIO_BIT_RST_RST11_Msk            (0x800UL)                 /*!< RST11 (Bitfield-Mask: 0x01)                           */
#define GPIO_BIT_RST_RST10_Pos            (10UL)                    /*!< RST10 (Bit 10)                                        */
#define GPIO_BIT_RST_RST10_Msk            (0x400UL)                 /*!< RST10 (Bitfield-Mask: 0x01)                           */
#define GPIO_BIT_RST_RST9_Pos             (9UL)                     /*!< RST9 (Bit 9)                                          */
#define GPIO_BIT_RST_RST9_Msk             (0x200UL)                 /*!< RST9 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_RST_RST8_Pos             (8UL)                     /*!< RST8 (Bit 8)                                          */
#define GPIO_BIT_RST_RST8_Msk             (0x100UL)                 /*!< RST8 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_RST_RST7_Pos             (7UL)                     /*!< RST7 (Bit 7)                                          */
#define GPIO_BIT_RST_RST7_Msk             (0x80UL)                  /*!< RST7 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_RST_RST6_Pos             (6UL)                     /*!< RST6 (Bit 6)                                          */
#define GPIO_BIT_RST_RST6_Msk             (0x40UL)                  /*!< RST6 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_RST_RST5_Pos             (5UL)                     /*!< RST5 (Bit 5)                                          */
#define GPIO_BIT_RST_RST5_Msk             (0x20UL)                  /*!< RST5 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_RST_RST4_Pos             (4UL)                     /*!< RST4 (Bit 4)                                          */
#define GPIO_BIT_RST_RST4_Msk             (0x10UL)                  /*!< RST4 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_RST_RST3_Pos             (3UL)                     /*!< RST3 (Bit 3)                                          */
#define GPIO_BIT_RST_RST3_Msk             (0x8UL)                   /*!< RST3 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_RST_RST2_Pos             (2UL)                     /*!< RST2 (Bit 2)                                          */
#define GPIO_BIT_RST_RST2_Msk             (0x4UL)                   /*!< RST2 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_RST_RST1_Pos             (1UL)                     /*!< RST1 (Bit 1)                                          */
#define GPIO_BIT_RST_RST1_Msk             (0x2UL)                   /*!< RST1 (Bitfield-Mask: 0x01)                            */
#define GPIO_BIT_RST_RST0_Pos             (0UL)                     /*!< RST0 (Bit 0)                                          */
#define GPIO_BIT_RST_RST0_Msk             (0x1UL)                   /*!< RST0 (Bitfield-Mask: 0x01)                            */
/* =========================================================  LOCK  ========================================================== */
#define GPIO_LOCK_KEY_Pos                 (16UL)                    /*!< KEY (Bit 16)                                          */
#define GPIO_LOCK_KEY_Msk                 (0xffff0000UL)            /*!< KEY (Bitfield-Mask: 0xffff)                           */
#define GPIO_LOCK_LK_Pos                  (0UL)                     /*!< LK (Bit 0)                                            */
#define GPIO_LOCK_LK_Msk                  (0x1UL)                   /*!< LK (Bitfield-Mask: 0x01)                              */
/* ========================================================  AF_LOW  ========================================================= */
#define GPIO_AF_LOW_AFSEL7_Pos            (28UL)                    /*!< AFSEL7 (Bit 28)                                       */
#define GPIO_AF_LOW_AFSEL7_Msk            (0xf0000000UL)            /*!< AFSEL7 (Bitfield-Mask: 0x0f)                          */
#define GPIO_AF_LOW_AFSEL6_Pos            (24UL)                    /*!< AFSEL6 (Bit 24)                                       */
#define GPIO_AF_LOW_AFSEL6_Msk            (0xf000000UL)             /*!< AFSEL6 (Bitfield-Mask: 0x0f)                          */
#define GPIO_AF_LOW_AFSEL5_Pos            (20UL)                    /*!< AFSEL5 (Bit 20)                                       */
#define GPIO_AF_LOW_AFSEL5_Msk            (0xf00000UL)              /*!< AFSEL5 (Bitfield-Mask: 0x0f)                          */
#define GPIO_AF_LOW_AFSEL4_Pos            (16UL)                    /*!< AFSEL4 (Bit 16)                                       */
#define GPIO_AF_LOW_AFSEL4_Msk            (0xf0000UL)               /*!< AFSEL4 (Bitfield-Mask: 0x0f)                          */
#define GPIO_AF_LOW_AFSEL3_Pos            (12UL)                    /*!< AFSEL3 (Bit 12)                                       */
#define GPIO_AF_LOW_AFSEL3_Msk            (0xf000UL)                /*!< AFSEL3 (Bitfield-Mask: 0x0f)                          */
#define GPIO_AF_LOW_AFSEL2_Pos            (8UL)                     /*!< AFSEL2 (Bit 8)                                        */
#define GPIO_AF_LOW_AFSEL2_Msk            (0xf00UL)                 /*!< AFSEL2 (Bitfield-Mask: 0x0f)                          */
#define GPIO_AF_LOW_AFSEL1_Pos            (4UL)                     /*!< AFSEL1 (Bit 4)                                        */
#define GPIO_AF_LOW_AFSEL1_Msk            (0xf0UL)                  /*!< AFSEL1 (Bitfield-Mask: 0x0f)                          */
#define GPIO_AF_LOW_AFSEL0_Pos            (0UL)                     /*!< AFSEL0 (Bit 0)                                        */
#define GPIO_AF_LOW_AFSEL0_Msk            (0xfUL)                   /*!< AFSEL0 (Bitfield-Mask: 0x0f)                          */
/* ========================================================  AF_HIGH  ======================================================== */
#define GPIO_AF_HIGH_AFSEL15_Pos          (28UL)                    /*!< AFSEL15 (Bit 28)                                      */
#define GPIO_AF_HIGH_AFSEL15_Msk          (0xf0000000UL)            /*!< AFSEL15 (Bitfield-Mask: 0x0f)                         */
#define GPIO_AF_HIGH_AFSEL14_Pos          (24UL)                    /*!< AFSEL14 (Bit 24)                                      */
#define GPIO_AF_HIGH_AFSEL14_Msk          (0xf000000UL)             /*!< AFSEL14 (Bitfield-Mask: 0x0f)                         */
#define GPIO_AF_HIGH_AFSEL13_Pos          (20UL)                    /*!< AFSEL13 (Bit 20)                                      */
#define GPIO_AF_HIGH_AFSEL13_Msk          (0xf00000UL)              /*!< AFSEL13 (Bitfield-Mask: 0x0f)                         */
#define GPIO_AF_HIGH_AFSEL12_Pos          (16UL)                    /*!< AFSEL12 (Bit 16)                                      */
#define GPIO_AF_HIGH_AFSEL12_Msk          (0xf0000UL)               /*!< AFSEL12 (Bitfield-Mask: 0x0f)                         */
#define GPIO_AF_HIGH_AFSEL11_Pos          (12UL)                    /*!< AFSEL11 (Bit 12)                                      */
#define GPIO_AF_HIGH_AFSEL11_Msk          (0xf000UL)                /*!< AFSEL11 (Bitfield-Mask: 0x0f)                         */
#define GPIO_AF_HIGH_AFSEL10_Pos          (8UL)                     /*!< AFSEL10 (Bit 8)                                       */
#define GPIO_AF_HIGH_AFSEL10_Msk          (0xf00UL)                 /*!< AFSEL10 (Bitfield-Mask: 0x0f)                         */
#define GPIO_AF_HIGH_AFSEL9_Pos           (4UL)                     /*!< AFSEL9 (Bit 4)                                        */
#define GPIO_AF_HIGH_AFSEL9_Msk           (0xf0UL)                  /*!< AFSEL9 (Bitfield-Mask: 0x0f)                          */
#define GPIO_AF_HIGH_AFSEL8_Pos           (0UL)                     /*!< AFSEL8 (Bit 0)                                        */
#define GPIO_AF_HIGH_AFSEL8_Msk           (0xfUL)                   /*!< AFSEL8 (Bitfield-Mask: 0x0f)                          */
/* ========================================================  ANA_AF  ========================================================= */
#define GPIO_ANA_AF_ANA_AFSEL15_Pos       (30UL)                    /*!< ANA_AFSEL15 (Bit 30)                                  */
#define GPIO_ANA_AF_ANA_AFSEL15_Msk       (0xc0000000UL)            /*!< ANA_AFSEL15 (Bitfield-Mask: 0x03)                     */
#define GPIO_ANA_AF_ANA_AFSEL14_Pos       (28UL)                    /*!< ANA_AFSEL14 (Bit 28)                                  */
#define GPIO_ANA_AF_ANA_AFSEL14_Msk       (0x30000000UL)            /*!< ANA_AFSEL14 (Bitfield-Mask: 0x03)                     */
#define GPIO_ANA_AF_ANA_AFSEL13_Pos       (26UL)                    /*!< ANA_AFSEL13 (Bit 26)                                  */
#define GPIO_ANA_AF_ANA_AFSEL13_Msk       (0xc000000UL)             /*!< ANA_AFSEL13 (Bitfield-Mask: 0x03)                     */
#define GPIO_ANA_AF_ANA_AFSEL12_Pos       (24UL)                    /*!< ANA_AFSEL12 (Bit 24)                                  */
#define GPIO_ANA_AF_ANA_AFSEL12_Msk       (0x3000000UL)             /*!< ANA_AFSEL12 (Bitfield-Mask: 0x03)                     */
#define GPIO_ANA_AF_ANA_AFSEL11_Pos       (22UL)                    /*!< ANA_AFSEL11 (Bit 22)                                  */
#define GPIO_ANA_AF_ANA_AFSEL11_Msk       (0xc00000UL)              /*!< ANA_AFSEL11 (Bitfield-Mask: 0x03)                     */
#define GPIO_ANA_AF_ANA_AFSEL10_Pos       (20UL)                    /*!< ANA_AFSEL10 (Bit 20)                                  */
#define GPIO_ANA_AF_ANA_AFSEL10_Msk       (0x300000UL)              /*!< ANA_AFSEL10 (Bitfield-Mask: 0x03)                     */
#define GPIO_ANA_AF_ANA_AFSEL9_Pos        (18UL)                    /*!< ANA_AFSEL9 (Bit 18)                                   */
#define GPIO_ANA_AF_ANA_AFSEL9_Msk        (0xc0000UL)               /*!< ANA_AFSEL9 (Bitfield-Mask: 0x03)                      */
#define GPIO_ANA_AF_ANA_AFSEL8_Pos        (16UL)                    /*!< ANA_AFSEL8 (Bit 16)                                   */
#define GPIO_ANA_AF_ANA_AFSEL8_Msk        (0x30000UL)               /*!< ANA_AFSEL8 (Bitfield-Mask: 0x03)                      */
#define GPIO_ANA_AF_ANA_AFSEL7_Pos        (14UL)                    /*!< ANA_AFSEL7 (Bit 14)                                   */
#define GPIO_ANA_AF_ANA_AFSEL7_Msk        (0xc000UL)                /*!< ANA_AFSEL7 (Bitfield-Mask: 0x03)                      */
#define GPIO_ANA_AF_ANA_AFSEL6_Pos        (12UL)                    /*!< ANA_AFSEL6 (Bit 12)                                   */
#define GPIO_ANA_AF_ANA_AFSEL6_Msk        (0x3000UL)                /*!< ANA_AFSEL6 (Bitfield-Mask: 0x03)                      */
#define GPIO_ANA_AF_ANA_AFSEL5_Pos        (10UL)                    /*!< ANA_AFSEL5 (Bit 10)                                   */
#define GPIO_ANA_AF_ANA_AFSEL5_Msk        (0xc00UL)                 /*!< ANA_AFSEL5 (Bitfield-Mask: 0x03)                      */
#define GPIO_ANA_AF_ANA_AFSEL4_Pos        (8UL)                     /*!< ANA_AFSEL4 (Bit 8)                                    */
#define GPIO_ANA_AF_ANA_AFSEL4_Msk        (0x300UL)                 /*!< ANA_AFSEL4 (Bitfield-Mask: 0x03)                      */
#define GPIO_ANA_AF_ANA_AFSEL3_Pos        (6UL)                     /*!< ANA_AFSEL3 (Bit 6)                                    */
#define GPIO_ANA_AF_ANA_AFSEL3_Msk        (0xc0UL)                  /*!< ANA_AFSEL3 (Bitfield-Mask: 0x03)                      */
#define GPIO_ANA_AF_ANA_AFSEL2_Pos        (4UL)                     /*!< ANA_AFSEL2 (Bit 4)                                    */
#define GPIO_ANA_AF_ANA_AFSEL2_Msk        (0x30UL)                  /*!< ANA_AFSEL2 (Bitfield-Mask: 0x03)                      */
#define GPIO_ANA_AF_ANA_AFSEL1_Pos        (2UL)                     /*!< ANA_AFSEL1 (Bit 2)                                    */
#define GPIO_ANA_AF_ANA_AFSEL1_Msk        (0xcUL)                   /*!< ANA_AFSEL1 (Bitfield-Mask: 0x03)                      */
#define GPIO_ANA_AF_ANA_AFSEL0_Pos        (0UL)                     /*!< ANA_AFSEL0 (Bit 0)                                    */
#define GPIO_ANA_AF_ANA_AFSEL0_Msk        (0x3UL)                   /*!< ANA_AFSEL0 (Bitfield-Mask: 0x03)                      */
/* ========================================================  INT_EN  ========================================================= */
#define GPIO_INT_EN_IE15_Pos              (15UL)                    /*!< IE15 (Bit 15)                                         */
#define GPIO_INT_EN_IE15_Msk              (0x8000UL)                /*!< IE15 (Bitfield-Mask: 0x01)                            */
#define GPIO_INT_EN_IE14_Pos              (14UL)                    /*!< IE14 (Bit 14)                                         */
#define GPIO_INT_EN_IE14_Msk              (0x4000UL)                /*!< IE14 (Bitfield-Mask: 0x01)                            */
#define GPIO_INT_EN_IE13_Pos              (13UL)                    /*!< IE13 (Bit 13)                                         */
#define GPIO_INT_EN_IE13_Msk              (0x2000UL)                /*!< IE13 (Bitfield-Mask: 0x01)                            */
#define GPIO_INT_EN_IE12_Pos              (12UL)                    /*!< IE12 (Bit 12)                                         */
#define GPIO_INT_EN_IE12_Msk              (0x1000UL)                /*!< IE12 (Bitfield-Mask: 0x01)                            */
#define GPIO_INT_EN_IE11_Pos              (11UL)                    /*!< IE11 (Bit 11)                                         */
#define GPIO_INT_EN_IE11_Msk              (0x800UL)                 /*!< IE11 (Bitfield-Mask: 0x01)                            */
#define GPIO_INT_EN_IE10_Pos              (10UL)                    /*!< IE10 (Bit 10)                                         */
#define GPIO_INT_EN_IE10_Msk              (0x400UL)                 /*!< IE10 (Bitfield-Mask: 0x01)                            */
#define GPIO_INT_EN_IE9_Pos               (9UL)                     /*!< IE9 (Bit 9)                                           */
#define GPIO_INT_EN_IE9_Msk               (0x200UL)                 /*!< IE9 (Bitfield-Mask: 0x01)                             */
#define GPIO_INT_EN_IE8_Pos               (8UL)                     /*!< IE8 (Bit 8)                                           */
#define GPIO_INT_EN_IE8_Msk               (0x100UL)                 /*!< IE8 (Bitfield-Mask: 0x01)                             */
#define GPIO_INT_EN_IE7_Pos               (7UL)                     /*!< IE7 (Bit 7)                                           */
#define GPIO_INT_EN_IE7_Msk               (0x80UL)                  /*!< IE7 (Bitfield-Mask: 0x01)                             */
#define GPIO_INT_EN_IE6_Pos               (6UL)                     /*!< IE6 (Bit 6)                                           */
#define GPIO_INT_EN_IE6_Msk               (0x40UL)                  /*!< IE6 (Bitfield-Mask: 0x01)                             */
#define GPIO_INT_EN_IE5_Pos               (5UL)                     /*!< IE5 (Bit 5)                                           */
#define GPIO_INT_EN_IE5_Msk               (0x20UL)                  /*!< IE5 (Bitfield-Mask: 0x01)                             */
#define GPIO_INT_EN_IE4_Pos               (4UL)                     /*!< IE4 (Bit 4)                                           */
#define GPIO_INT_EN_IE4_Msk               (0x10UL)                  /*!< IE4 (Bitfield-Mask: 0x01)                             */
#define GPIO_INT_EN_IE3_Pos               (3UL)                     /*!< IE3 (Bit 3)                                           */
#define GPIO_INT_EN_IE3_Msk               (0x8UL)                   /*!< IE3 (Bitfield-Mask: 0x01)                             */
#define GPIO_INT_EN_IE2_Pos               (2UL)                     /*!< IE2 (Bit 2)                                           */
#define GPIO_INT_EN_IE2_Msk               (0x4UL)                   /*!< IE2 (Bitfield-Mask: 0x01)                             */
#define GPIO_INT_EN_IE1_Pos               (1UL)                     /*!< IE1 (Bit 1)                                           */
#define GPIO_INT_EN_IE1_Msk               (0x2UL)                   /*!< IE1 (Bitfield-Mask: 0x01)                             */
#define GPIO_INT_EN_IE0_Pos               (0UL)                     /*!< IE0 (Bit 0)                                           */
#define GPIO_INT_EN_IE0_Msk               (0x1UL)                   /*!< IE0 (Bitfield-Mask: 0x01)                             */
/* =====================================================  INT_TYPE_LOW  ====================================================== */
#define GPIO_INT_TYPE_LOW_INT_TYPE7_Pos   (28UL)                    /*!< INT_TYPE7 (Bit 28)                                    */
#define GPIO_INT_TYPE_LOW_INT_TYPE7_Msk   (0x70000000UL)            /*!< INT_TYPE7 (Bitfield-Mask: 0x07)                       */
#define GPIO_INT_TYPE_LOW_INT_TYPE6_Pos   (24UL)                    /*!< INT_TYPE6 (Bit 24)                                    */
#define GPIO_INT_TYPE_LOW_INT_TYPE6_Msk   (0x7000000UL)             /*!< INT_TYPE6 (Bitfield-Mask: 0x07)                       */
#define GPIO_INT_TYPE_LOW_INT_TYPE5_Pos   (20UL)                    /*!< INT_TYPE5 (Bit 20)                                    */
#define GPIO_INT_TYPE_LOW_INT_TYPE5_Msk   (0x700000UL)              /*!< INT_TYPE5 (Bitfield-Mask: 0x07)                       */
#define GPIO_INT_TYPE_LOW_INT_TYPE4_Pos   (16UL)                    /*!< INT_TYPE4 (Bit 16)                                    */
#define GPIO_INT_TYPE_LOW_INT_TYPE4_Msk   (0x70000UL)               /*!< INT_TYPE4 (Bitfield-Mask: 0x07)                       */
#define GPIO_INT_TYPE_LOW_INT_TYPE3_Pos   (12UL)                    /*!< INT_TYPE3 (Bit 12)                                    */
#define GPIO_INT_TYPE_LOW_INT_TYPE3_Msk   (0x7000UL)                /*!< INT_TYPE3 (Bitfield-Mask: 0x07)                       */
#define GPIO_INT_TYPE_LOW_INT_TYPE2_Pos   (8UL)                     /*!< INT_TYPE2 (Bit 8)                                     */
#define GPIO_INT_TYPE_LOW_INT_TYPE2_Msk   (0x700UL)                 /*!< INT_TYPE2 (Bitfield-Mask: 0x07)                       */
#define GPIO_INT_TYPE_LOW_INT_TYPE1_Pos   (4UL)                     /*!< INT_TYPE1 (Bit 4)                                     */
#define GPIO_INT_TYPE_LOW_INT_TYPE1_Msk   (0x70UL)                  /*!< INT_TYPE1 (Bitfield-Mask: 0x07)                       */
#define GPIO_INT_TYPE_LOW_INT_TYPE0_Pos   (0UL)                     /*!< INT_TYPE0 (Bit 0)                                     */
#define GPIO_INT_TYPE_LOW_INT_TYPE0_Msk   (0x7UL)                   /*!< INT_TYPE0 (Bitfield-Mask: 0x07)                       */
/* =====================================================  INT_TYPE_HIGH  ===================================================== */
#define GPIO_INT_TYPE_HIGH_INT_TYPE15_Pos  (28UL)                   /*!< INT_TYPE15 (Bit 28)                                   */
#define GPIO_INT_TYPE_HIGH_INT_TYPE15_Msk  (0x70000000UL)           /*!< INT_TYPE15 (Bitfield-Mask: 0x07)                      */
#define GPIO_INT_TYPE_HIGH_INT_TYPE14_Pos  (24UL)                   /*!< INT_TYPE14 (Bit 24)                                   */
#define GPIO_INT_TYPE_HIGH_INT_TYPE14_Msk  (0x7000000UL)            /*!< INT_TYPE14 (Bitfield-Mask: 0x07)                      */
#define GPIO_INT_TYPE_HIGH_INT_TYPE13_Pos  (20UL)                   /*!< INT_TYPE13 (Bit 20)                                   */
#define GPIO_INT_TYPE_HIGH_INT_TYPE13_Msk  (0x700000UL)             /*!< INT_TYPE13 (Bitfield-Mask: 0x07)                      */
#define GPIO_INT_TYPE_HIGH_INT_TYPE12_Pos  (16UL)                   /*!< INT_TYPE12 (Bit 16)                                   */
#define GPIO_INT_TYPE_HIGH_INT_TYPE12_Msk  (0x70000UL)              /*!< INT_TYPE12 (Bitfield-Mask: 0x07)                      */
#define GPIO_INT_TYPE_HIGH_INT_TYPE11_Pos  (12UL)                   /*!< INT_TYPE11 (Bit 12)                                   */
#define GPIO_INT_TYPE_HIGH_INT_TYPE11_Msk  (0x7000UL)               /*!< INT_TYPE11 (Bitfield-Mask: 0x07)                      */
#define GPIO_INT_TYPE_HIGH_INT_TYPE10_Pos  (8UL)                    /*!< INT_TYPE10 (Bit 8)                                    */
#define GPIO_INT_TYPE_HIGH_INT_TYPE10_Msk  (0x700UL)                /*!< INT_TYPE10 (Bitfield-Mask: 0x07)                      */
#define GPIO_INT_TYPE_HIGH_INT_TYPE9_Pos   (4UL)                    /*!< INT_TYPE9 (Bit 4)                                     */
#define GPIO_INT_TYPE_HIGH_INT_TYPE9_Msk   (0x70UL)                 /*!< INT_TYPE9 (Bitfield-Mask: 0x07)                       */
#define GPIO_INT_TYPE_HIGH_INT_TYPE8_Pos   (0UL)                    /*!< INT_TYPE8 (Bit 0)                                     */
#define GPIO_INT_TYPE_HIGH_INT_TYPE8_Msk   (0x7UL)                  /*!< INT_TYPE8 (Bitfield-Mask: 0x07)                       */
/* ========================================================  INT_SR  ========================================================= */
#define GPIO_INT_SR_INT15_Pos              (15UL)                    /*!< INT15 (Bit 15)                                        */
#define GPIO_INT_SR_INT15_Msk              (0x8000UL)                /*!< INT15 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT_SR_INT14_Pos              (14UL)                    /*!< INT14 (Bit 14)                                        */
#define GPIO_INT_SR_INT14_Msk              (0x4000UL)                /*!< INT14 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT_SR_INT13_Pos              (13UL)                    /*!< INT13 (Bit 13)                                        */
#define GPIO_INT_SR_INT13_Msk              (0x2000UL)                /*!< INT13 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT_SR_INT12_Pos              (12UL)                    /*!< INT12 (Bit 12)                                        */
#define GPIO_INT_SR_INT12_Msk              (0x1000UL)                /*!< INT12 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT_SR_INT11_Pos              (11UL)                    /*!< INT11 (Bit 11)                                        */
#define GPIO_INT_SR_INT11_Msk              (0x800UL)                 /*!< INT11 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT_SR_INT10_Pos              (10UL)                    /*!< INT10 (Bit 10)                                        */
#define GPIO_INT_SR_INT10_Msk              (0x400UL)                 /*!< INT10 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT_SR_INT9_Pos               (9UL)                     /*!< INT9 (Bit 9)                                          */
#define GPIO_INT_SR_INT9_Msk               (0x200UL)                 /*!< INT9 (Bitfield-Mask: 0x01)                            */
#define GPIO_INT_SR_INT8_Pos               (8UL)                     /*!< INT8 (Bit 8)                                          */
#define GPIO_INT_SR_INT8_Msk               (0x100UL)                 /*!< INT8 (Bitfield-Mask: 0x01)                            */
#define GPIO_INT_SR_INT7_Pos               (7UL)                     /*!< INT7 (Bit 7)                                          */
#define GPIO_INT_SR_INT7_Msk               (0x80UL)                  /*!< INT7 (Bitfield-Mask: 0x01)                            */
#define GPIO_INT_SR_INT6_Pos               (6UL)                     /*!< INT6 (Bit 6)                                          */
#define GPIO_INT_SR_INT6_Msk               (0x40UL)                  /*!< INT6 (Bitfield-Mask: 0x01)                            */
#define GPIO_INT_SR_INT5_Pos               (5UL)                     /*!< INT5 (Bit 5)                                          */
#define GPIO_INT_SR_INT5_Msk               (0x20UL)                  /*!< INT5 (Bitfield-Mask: 0x01)                            */
#define GPIO_INT_SR_INT4_Pos               (4UL)                     /*!< INT4 (Bit 4)                                          */
#define GPIO_INT_SR_INT4_Msk               (0x10UL)                  /*!< INT4 (Bitfield-Mask: 0x01)                            */
#define GPIO_INT_SR_INT3_Pos               (3UL)                     /*!< INT3 (Bit 3)                                          */
#define GPIO_INT_SR_INT3_Msk               (0x8UL)                   /*!< INT3 (Bitfield-Mask: 0x01)                            */
#define GPIO_INT_SR_INT2_Pos               (2UL)                     /*!< INT2 (Bit 2)                                          */
#define GPIO_INT_SR_INT2_Msk               (0x4UL)                   /*!< INT2 (Bitfield-Mask: 0x01)                            */
#define GPIO_INT_SR_INT1_Pos               (1UL)                     /*!< INT1 (Bit 1)                                          */
#define GPIO_INT_SR_INT1_Msk               (0x2UL)                   /*!< INT1 (Bitfield-Mask: 0x01)                            */
#define GPIO_INT_SR_INT0_Pos               (0UL)                     /*!< INT0 (Bit 0)                                          */
#define GPIO_INT_SR_INT0_Msk               (0x1UL)                   /*!< INT0 (Bitfield-Mask: 0x01)                            */


/* =========================================================================================================================== */
/* ================                                           UART                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  CR  =========================================================== */
#define UART_CR_HALF_DUP_Pos             (19UL)                    /*!< HALF_DUP (Bit 19)                                     */
#define UART_CR_HALF_DUP_Msk             (0x80000UL)               /*!< HALF_DUP (Bitfield-Mask: 0x01)                        */
#define UART_CR_MSB_FIRST_Pos            (18UL)                    /*!< MSB_FIRST (Bit 18)                                    */
#define UART_CR_MSB_FIRST_Msk            (0x40000UL)               /*!< MSB_FIRST (Bitfield-Mask: 0x01)                       */
#define UART_CR_IDLE_IE_Pos              (12UL)                    /*!< IDLE_IE (Bit 12)                                      */
#define UART_CR_IDLE_IE_Msk              (0x1000UL)                /*!< IDLE_IE (Bitfield-Mask: 0x01)                         */
#define UART_CR_ERR_IE_Pos               (11UL)                    /*!< ERR_IE (Bit 11)                                       */
#define UART_CR_ERR_IE_Msk               (0x800UL)                 /*!< ERR_IE (Bitfield-Mask: 0x01)                          */
#define UART_CR_TXE_IE_Pos               (10UL)                    /*!< TXE_IE (Bit 10)                                       */
#define UART_CR_TXE_IE_Msk               (0x400UL)                 /*!< TXE_IE (Bitfield-Mask: 0x01)                          */
#define UART_CR_TXC_IE_Pos               (9UL)                     /*!< TXC_IE (Bit 9)                                        */
#define UART_CR_TXC_IE_Msk               (0x200UL)                 /*!< TXC_IE (Bitfield-Mask: 0x01)                          */
#define UART_CR_RXNE_IE_Pos              (8UL)                     /*!< RXNE_IE (Bit 8)                                       */
#define UART_CR_RXNE_IE_Msk              (0x100UL)                 /*!< RXNE_IE (Bitfield-Mask: 0x01)                         */
#define UART_CR_PARITY_SEL_Pos           (7UL)                     /*!< PARITY_SEL (Bit 7)                                    */
#define UART_CR_PARITY_SEL_Msk           (0x80UL)                  /*!< PARITY_SEL (Bitfield-Mask: 0x01)                      */
#define UART_CR_PARITY_EN_Pos            (6UL)                     /*!< PARITY_EN (Bit 6)                                     */
#define UART_CR_PARITY_EN_Msk            (0x40UL)                  /*!< PARITY_EN (Bitfield-Mask: 0x01)                       */
#define UART_CR_STOP_LEN_Pos             (5UL)                     /*!< STOP_LEN (Bit 5)                                      */
#define UART_CR_STOP_LEN_Msk             (0x20UL)                  /*!< STOP_LEN (Bitfield-Mask: 0x01)                        */
#define UART_CR_DATA_LEN_Pos             (3UL)                     /*!< DATA_LEN (Bit 3)                                      */
#define UART_CR_DATA_LEN_Msk             (0x18UL)                  /*!< DATA_LEN (Bitfield-Mask: 0x03)                        */
#define UART_CR_TX_EN_Pos                (2UL)                     /*!< TX_EN (Bit 2)                                         */
#define UART_CR_TX_EN_Msk                (0x4UL)                   /*!< TX_EN (Bitfield-Mask: 0x01)                           */
#define UART_CR_RX_EN_Pos                (1UL)                     /*!< RX_EN (Bit 1)                                         */
#define UART_CR_RX_EN_Msk                (0x2UL)                   /*!< RX_EN (Bitfield-Mask: 0x01)                           */
#define UART_CR_EN_Pos                   (0UL)                     /*!< EN (Bit 0)                                            */
#define UART_CR_EN_Msk                   (0x1UL)                   /*!< EN (Bitfield-Mask: 0x01)                              */
/* ==========================================================  ISR  ========================================================== */
#define UART_ISR_IDLE_Pos                (6UL)                     /*!< IDLE (Bit 6)                                          */
#define UART_ISR_IDLE_Msk                (0x40UL)                  /*!< IDLE (Bitfield-Mask: 0x01)                            */
#define UART_ISR_OVRR_ERR_Pos            (5UL)                     /*!< OVRR_ERR (Bit 5)                                      */
#define UART_ISR_OVRR_ERR_Msk            (0x20UL)                  /*!< OVRR_ERR (Bitfield-Mask: 0x01)                        */
#define UART_ISR_FRAME_ERR_Pos           (4UL)                     /*!< FRAME_ERR (Bit 4)                                     */
#define UART_ISR_FRAME_ERR_Msk           (0x10UL)                  /*!< FRAME_ERR (Bitfield-Mask: 0x01)                       */
#define UART_ISR_PARITY_ERR_Pos          (3UL)                     /*!< PARITY_ERR (Bit 3)                                    */
#define UART_ISR_PARITY_ERR_Msk          (0x8UL)                   /*!< PARITY_ERR (Bitfield-Mask: 0x01)                      */
#define UART_ISR_TXE_Pos                 (2UL)                     /*!< TXE (Bit 2)                                           */
#define UART_ISR_TXE_Msk                 (0x4UL)                   /*!< TXE (Bitfield-Mask: 0x01)                             */
#define UART_ISR_TXC_Pos                 (1UL)                     /*!< TXC (Bit 1)                                           */
#define UART_ISR_TXC_Msk                 (0x2UL)                   /*!< TXC (Bitfield-Mask: 0x01)                             */
#define UART_ISR_RXNE_Pos                (0UL)                     /*!< RXNE (Bit 0)                                          */
#define UART_ISR_RXNE_Msk                (0x1UL)                   /*!< RXNE (Bitfield-Mask: 0x01)                            */
/* ==========================================================  BRR  ========================================================== */
#define UART_BRR_DIV_FRAC_Pos            (16UL)                    /*!< DIV_FRAC (Bit 16)                                     */
#define UART_BRR_DIV_FRAC_Msk            (0xf0000UL)               /*!< DIV_FRAC (Bitfield-Mask: 0x0f)                        */
#define UART_BRR_DIV_INT_Pos             (0UL)                     /*!< DIV_INT (Bit 0)                                       */
#define UART_BRR_DIV_INT_Msk             (0xffffUL)                /*!< DIV_INT (Bitfield-Mask: 0xffff)                       */
/* ==========================================================  TDR  ========================================================== */
#define UART_TDR_TDR_Pos                 (0UL)                     /*!< TDR (Bit 0)                                           */
#define UART_TDR_TDR_Msk                 (0x1ffUL)                 /*!< TDR (Bitfield-Mask: 0x1ff)                            */
/* ==========================================================  RDR  ========================================================== */
#define UART_RDR_RDR_Pos                 (0UL)                     /*!< RDR (Bit 0)                                           */
#define UART_RDR_RDR_Msk                 (0x1ffUL)                 /*!< RDR (Bitfield-Mask: 0x1ff)                            */


/* =========================================================================================================================== */
/* ================                                            RCC                                            ================ */
/* =========================================================================================================================== */

/* =======================================================  COMMON_CR  ======================================================= */
#define RCC_COMMON_CR_LSI_ST_Pos          (26UL)                    /*!< LSI_ST (Bit 26)                                       */
#define RCC_COMMON_CR_LSI_ST_Msk          (0xc000000UL)             /*!< LSI_ST (Bitfield-Mask: 0x03)                          */
#define RCC_COMMON_CR_HSI_ST_Pos          (24UL)                    /*!< HSI_ST (Bit 24)                                       */
#define RCC_COMMON_CR_HSI_ST_Msk          (0x3000000UL)             /*!< HSI_ST (Bitfield-Mask: 0x03)                          */
#define RCC_COMMON_CR_LSI_RDY_Pos         (21UL)                    /*!< LSI_RDY (Bit 21)                                      */
#define RCC_COMMON_CR_LSI_RDY_Msk         (0x200000UL)              /*!< LSI_RDY (Bitfield-Mask: 0x01)                         */
#define RCC_COMMON_CR_LSI_EN_Pos          (17UL)                    /*!< LSI_EN (Bit 17)                                       */
#define RCC_COMMON_CR_LSI_EN_Msk          (0x20000UL)               /*!< LSI_EN (Bitfield-Mask: 0x01)                          */
#define RCC_COMMON_CR_MCO_SEL_Pos         (13UL)                    /*!< MCO_SEL (Bit 13)                                      */
#define RCC_COMMON_CR_MCO_SEL_Msk         (0x2000UL)                /*!< MCO_SEL (Bitfield-Mask: 0x01)                         */
#define RCC_COMMON_CR_MCO_EN_Pos          (12UL)                    /*!< MCO_EN (Bit 12)                                       */
#define RCC_COMMON_CR_MCO_EN_Msk          (0x1000UL)                /*!< MCO_EN (Bitfield-Mask: 0x01)                          */
#define RCC_COMMON_CR_HCKD_Pos            (4UL)                     /*!< HCKD (Bit 4)                                          */
#define RCC_COMMON_CR_HCKD_Msk            (0x70UL)                  /*!< HCKD (Bitfield-Mask: 0x07)                            */
#define RCC_COMMON_CR_PCKD_Pos            (0UL)                     /*!< PCKD (Bit 0)                                          */
#define RCC_COMMON_CR_PCKD_Msk            (0x7UL)                   /*!< PCKD (Bitfield-Mask: 0x07)                            */
/* =======================================================  CLKEN_CR  ======================================================== */
#define RCC_CLKEN_CR_GPIO_Pos             (24UL)                    /*!< GPIO (Bit 24)                                         */
#define RCC_CLKEN_CR_GPIO_Msk             (0x1000000UL)             /*!< GPIO (Bitfield-Mask: 0x01)                            */
#define RCC_CLKEN_CR_CRC_Pos              (22UL)                    /*!< CRC (Bit 22)                                          */
#define RCC_CLKEN_CR_CRC_Msk              (0x400000UL)              /*!< CRC (Bitfield-Mask: 0x01)                             */
#define RCC_CLKEN_CR_ACMP_Pos             (18UL)                    /*!< ACMP (Bit 18)                                         */
#define RCC_CLKEN_CR_ACMP_Msk             (0x40000UL)               /*!< ACMP (Bitfield-Mask: 0x01)                            */
#define RCC_CLKEN_CR_I2C_Pos              (15UL)                    /*!< I2C (Bit 15)                                          */
#define RCC_CLKEN_CR_I2C_Msk              (0x8000UL)                /*!< I2C (Bitfield-Mask: 0x01)                             */
#define RCC_CLKEN_CR_ADC_Pos              (13UL)                    /*!< ADC (Bit 13)                                          */
#define RCC_CLKEN_CR_ADC_Msk              (0x2000UL)                /*!< ADC (Bitfield-Mask: 0x01)                             */
#define RCC_CLKEN_CR_PVD_Pos              (12UL)                    /*!< PVD (Bit 12)                                          */
#define RCC_CLKEN_CR_PVD_Msk              (0x1000UL)                /*!< PVD (Bitfield-Mask: 0x01)                             */
#define RCC_CLKEN_CR_EPWM_Pos             (11UL)                    /*!< EPWM (Bit 11)                                         */
#define RCC_CLKEN_CR_EPWM_Msk             (0x800UL)                 /*!< EPWM (Bitfield-Mask: 0x01)                            */
#define RCC_CLKEN_CR_CCT0_Pos             (9UL)                     /*!< CCT0 (Bit 9)                                          */
#define RCC_CLKEN_CR_CCT0_Msk             (0x200UL)                 /*!< CCT0 (Bitfield-Mask: 0x01)                            */
#define RCC_CLKEN_CR_TIM1_Pos             (6UL)                     /*!< TIM1 (Bit 6)                                          */
#define RCC_CLKEN_CR_TIM1_Msk             (0x40UL)                  /*!< TIM1 (Bitfield-Mask: 0x01)                            */
#define RCC_CLKEN_CR_TIM0_Pos             (5UL)                     /*!< TIM0 (Bit 5)                                          */
#define RCC_CLKEN_CR_TIM0_Msk             (0x20UL)                  /*!< TIM0 (Bitfield-Mask: 0x01)                            */
#define RCC_CLKEN_CR_SPI0_Pos             (3UL)                     /*!< SPI0 (Bit 3)                                          */
#define RCC_CLKEN_CR_SPI0_Msk             (0x8UL)                   /*!< SPI0 (Bitfield-Mask: 0x01)                            */
#define RCC_CLKEN_CR_UART1_Pos            (1UL)                     /*!< UART1 (Bit 1)                                         */
#define RCC_CLKEN_CR_UART1_Msk            (0x2UL)                   /*!< UART1 (Bitfield-Mask: 0x01)                           */
#define RCC_CLKEN_CR_UART0_Pos            (0UL)                     /*!< UART0 (Bit 0)                                         */
#define RCC_CLKEN_CR_UART0_Msk            (0x1UL)                   /*!< UART0 (Bitfield-Mask: 0x01)                           */
/* =======================================================  RESET_SR  ======================================================== */
#define RCC_RESET_SR_LKUPRST_EN_Pos       (18UL)                    /*!< LKUPRST_EN (Bit 18)                                   */
#define RCC_RESET_SR_LKUPRST_EN_Msk       (0x40000UL)               /*!< LKUPRST_EN (Bitfield-Mask: 0x01)                      */
#define RCC_RESET_SR_CLR_Pos              (16UL)                    /*!< CLR (Bit 16)                                          */
#define RCC_RESET_SR_CLR_Msk              (0x10000UL)               /*!< CLR (Bitfield-Mask: 0x01)                             */
#define RCC_RESET_SR_DSTB_DET_Pos         (7UL)                     /*!< DSTB_DET (Bit 7)                                      */
#define RCC_RESET_SR_DSTB_DET_Msk         (0x80UL)                  /*!< DSTB_DET (Bitfield-Mask: 0x01)                        */
#define RCC_RESET_SR_PVD_Pos              (6UL)                     /*!< PVD (Bit 6)                                           */
#define RCC_RESET_SR_PVD_Msk              (0x40UL)                  /*!< PVD (Bitfield-Mask: 0x01)                             */
#define RCC_RESET_SR_WDG_Pos              (5UL)                     /*!< WDG (Bit 5)                                           */
#define RCC_RESET_SR_WDG_Msk              (0x20UL)                  /*!< WDG (Bitfield-Mask: 0x01)                             */
#define RCC_RESET_SR_LOCKUP_Pos           (3UL)                     /*!< LOCKUP (Bit 3)                                        */
#define RCC_RESET_SR_LOCKUP_Msk           (0x8UL)                   /*!< LOCKUP (Bitfield-Mask: 0x01)                          */
#define RCC_RESET_SR_SW_Pos               (2UL)                     /*!< SW (Bit 2)                                            */
#define RCC_RESET_SR_SW_Msk               (0x4UL)                   /*!< SW (Bitfield-Mask: 0x01)                              */
#define RCC_RESET_SR_BUTTON_Pos           (1UL)                     /*!< BUTTON (Bit 1)                                        */
#define RCC_RESET_SR_BUTTON_Msk           (0x2UL)                   /*!< BUTTON (Bitfield-Mask: 0x01)                          */
#define RCC_RESET_SR_POR_Pos              (0UL)                     /*!< POR (Bit 0)                                           */
#define RCC_RESET_SR_POR_Msk              (0x1UL)                   /*!< POR (Bitfield-Mask: 0x01)                             */
/* ========================================================  LOCK_CR  ======================================================== */
#define RCC_LOCK_CR_KEY_Pos               (16UL)                    /*!< KEY (Bit 16)                                          */
#define RCC_LOCK_CR_KEY_Msk               (0xffff0000UL)            /*!< KEY (Bitfield-Mask: 0xffff)                           */
#define RCC_LOCK_CR_LOCK_EN_Pos           (0UL)                     /*!< LOCK_EN (Bit 0)                                       */
#define RCC_LOCK_CR_LOCK_EN_Msk           (0x1UL)                   /*!< LOCK_EN (Bitfield-Mask: 0x01)                         */
/* =======================================================  SYSTEM_CR  ======================================================= */
#define RCC_SYSTEM_CR_VTOR_Pos            (8UL)                     /*!< VTOR (Bit 8)                                          */
#define RCC_SYSTEM_CR_VTOR_Msk            (0xffffff00UL)            /*!< VTOR (Bitfield-Mask: 0xffffff)                        */
/* ========================================================  LPM_CR  ========================================================= */
#define RCC_LPM_CR_MODE_Pos               (0UL)                     /*!< MODE (Bit 0)                                          */
#define RCC_LPM_CR_MODE_Msk               (0x3UL)                   /*!< MODE (Bitfield-Mask: 0x03)                            */
/* ======================================================  DEEP_SLEEP_CR  ==================================================== */
#define RCC_DEEP_SLEEP_CR_GPIO_Pos        (24UL)                    /*!< GPIO (Bit 24)                                         */
#define RCC_DEEP_SLEEP_CR_GPIO_Msk        (0x1000000UL)             /*!< GPIO (Bitfield-Mask: 0x01)                            */
#define RCC_DEEP_SLEEP_CR_CRC_Pos         (22UL)                    /*!< CRC (Bit 22)                                          */
#define RCC_DEEP_SLEEP_CR_CRC_Msk         (0x400000UL)              /*!< CRC (Bitfield-Mask: 0x01)                             */
#define RCC_DEEP_SLEEP_CR_ACMP_Pos        (18UL)                    /*!< ACMP (Bit 18)                                         */
#define RCC_DEEP_SLEEP_CR_ACMP_Msk        (0x40000UL)               /*!< ACMP (Bitfield-Mask: 0x01)                            */
#define RCC_DEEP_SLEEP_CR_I2C_Pos         (15UL)                    /*!< I2C (Bit 15)                                          */
#define RCC_DEEP_SLEEP_CR_I2C_Msk         (0x8000UL)                /*!< I2C (Bitfield-Mask: 0x01)                             */
#define RCC_DEEP_SLEEP_CR_ADC_Pos         (13UL)                    /*!< ADC (Bit 13)                                          */
#define RCC_DEEP_SLEEP_CR_ADC_Msk         (0x2000UL)                /*!< ADC (Bitfield-Mask: 0x01)                             */
#define RCC_DEEP_SLEEP_CR_PVD_Pos         (12UL)                    /*!< PVD (Bit 12)                                          */
#define RCC_DEEP_SLEEP_CR_PVD_Msk         (0x1000UL)                /*!< PVD (Bitfield-Mask: 0x01)                             */
#define RCC_DEEP_SLEEP_CR_EPWM_Pos        (11UL)                    /*!< EPWM (Bit 11)                                         */
#define RCC_DEEP_SLEEP_CR_EPWM_Msk        (0x800UL)                 /*!< EPWM (Bitfield-Mask: 0x01)                            */
#define RCC_DEEP_SLEEP_CR_CCT0_Pos        (9UL)                     /*!< CCT0 (Bit 9)                                          */
#define RCC_DEEP_SLEEP_CR_CCT0_Msk        (0x200UL)                 /*!< CCT0 (Bitfield-Mask: 0x01)                            */
#define RCC_DEEP_SLEEP_CR_TIM1_Pos        (6UL)                     /*!< TIM1 (Bit 6)                                          */
#define RCC_DEEP_SLEEP_CR_TIM1_Msk        (0x40UL)                  /*!< TIM1 (Bitfield-Mask: 0x01)                            */
#define RCC_DEEP_SLEEP_CR_TIM0_Pos        (5UL)                     /*!< TIM0 (Bit 5)                                          */
#define RCC_DEEP_SLEEP_CR_TIM0_Msk        (0x20UL)                  /*!< TIM0 (Bitfield-Mask: 0x01)                            */
#define RCC_DEEP_SLEEP_CR_SPI0_Pos        (3UL)                     /*!< SPI0 (Bit 3)                                          */
#define RCC_DEEP_SLEEP_CR_SPI0_Msk        (0x8UL)                   /*!< SPI0 (Bitfield-Mask: 0x01)                            */
#define RCC_DEEP_SLEEP_CR_UART1_Pos       (1UL)                     /*!< UART1 (Bit 1)                                         */
#define RCC_DEEP_SLEEP_CR_UART1_Msk       (0x2UL)                   /*!< UART1 (Bitfield-Mask: 0x01)                           */
#define RCC_DEEP_SLEEP_CR_UART0_Pos       (0UL)                     /*!< UART0 (Bit 0)                                         */
#define RCC_DEEP_SLEEP_CR_UART0_Msk       (0x1UL)                   /*!< UART0 (Bitfield-Mask: 0x01)                           */
/* ========================================================  STOP_CR  ======================================================== */
#define RCC_STOP_CR_LSCLK_EN_Pos          (0UL)                     /*!< LSCLK_EN (Bit 0)                                      */
#define RCC_STOP_CR_LSCLK_EN_Msk          (0x1UL)                   /*!< LSCLK_EN (Bitfield-Mask: 0x01)                        */


/* =========================================================================================================================== */
/* ================                                            PGA                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CR  =========================================================== */
#define PGA_CR_OUT_FLT_SEL_Pos            (29UL)                    /*!< OUT_FLT_SEL (Bit 29)                                  */
#define PGA_CR_OUT_FLT_SEL_Msk            (0x60000000UL)            /*!< OUT_FLT_SEL (Bitfield-Mask: 0x03)                     */
#define PGA_CR_OUT_FLT_EN_Pos             (28UL)                    /*!< OUT_FLT_EN (Bit 28)                                   */
#define PGA_CR_OUT_FLT_EN_Msk             (0x10000000UL)            /*!< OUT_FLT_EN (Bitfield-Mask: 0x01)                      */
#define PGA_CR_PGA1_AMP_Pos               (20UL)                    /*!< PGA1_AMP (Bit 20)                                     */
#define PGA_CR_PGA1_AMP_Msk               (0x700000UL)              /*!< PGA1_AMP (Bitfield-Mask: 0x07)                        */
#define PGA_CR_PGA0_AMP_Pos               (16UL)                    /*!< PGA0_AMP (Bit 16)                                     */
#define PGA_CR_PGA0_AMP_Msk               (0x70000UL)               /*!< PGA0_AMP (Bitfield-Mask: 0x07)                        */
#define PGA_CR_OFFSET_SEL_Pos             (12UL)                    /*!< OFFSET_SEL (Bit 12)                                   */
#define PGA_CR_OFFSET_SEL_Msk             (0x1000UL)                /*!< OFFSET_SEL (Bitfield-Mask: 0x01)                      */
#define PGA_CR_PGA1_OFFSET_EN_Pos         (9UL)                     /*!< PGA1_OFFSET_EN (Bit 9)                                */
#define PGA_CR_PGA1_OFFSET_EN_Msk         (0x200UL)                 /*!< PGA1_OFFSET_EN (Bitfield-Mask: 0x01)                  */
#define PGA_CR_PGA0_OFFSET_EN_Pos         (8UL)                     /*!< PGA0_OFFSET_EN (Bit 8)                                */
#define PGA_CR_PGA0_OFFSET_EN_Msk         (0x100UL)                 /*!< PGA0_OFFSET_EN (Bitfield-Mask: 0x01)                  */
#define PGA_CR_PGA1_MODE_Pos              (5UL)                     /*!< PGA1_MODE (Bit 5)                                     */
#define PGA_CR_PGA1_MODE_Msk              (0x20UL)                  /*!< PGA1_MODE (Bitfield-Mask: 0x01)                       */
#define PGA_CR_PGA0_MODE_Pos              (4UL)                     /*!< PGA0_MODE (Bit 4)                                     */
#define PGA_CR_PGA0_MODE_Msk              (0x10UL)                  /*!< PGA0_MODE (Bitfield-Mask: 0x01)                       */
#define PGA_CR_PGA1_EN_Pos                (1UL)                     /*!< PGA1_EN (Bit 1)                                       */
#define PGA_CR_PGA1_EN_Msk                (0x2UL)                   /*!< PGA1_EN (Bitfield-Mask: 0x01)                         */
#define PGA_CR_PGA0_EN_Pos                (0UL)                     /*!< PGA0_EN (Bit 0)                                       */
#define PGA_CR_PGA0_EN_Msk                (0x1UL)                   /*!< PGA0_EN (Bitfield-Mask: 0x01)                         */


/* =========================================================================================================================== */
/* ================                                            DBG                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CFG  ========================================================== */
#define DBG_CFG_EPWM_HALT_Pos             (10UL)                    /*!< EPWM_HALT (Bit 10)                                    */
#define DBG_CFG_EPWM_HALT_Msk             (0x400UL)                 /*!< EPWM_HALT (Bitfield-Mask: 0x01)                       */
#define DBG_CFG_LPTIM_HALT_Pos            (9UL)                     /*!< LPTIM_HALT (Bit 9)                                    */
#define DBG_CFG_LPTIM_HALT_Msk            (0x200UL)                 /*!< LPTIM_HALT (Bitfield-Mask: 0x01)                      */
#define DBG_CFG_CCT0_HALT_Pos             (7UL)                     /*!< CCT0_HALT (Bit 7)                                     */
#define DBG_CFG_CCT0_HALT_Msk             (0x80UL)                  /*!< CCT0_HALT (Bitfield-Mask: 0x01)                       */
#define DBG_CFG_TIM1_HALT_Pos             (2UL)                     /*!< TIM1_HALT (Bit 2)                                     */
#define DBG_CFG_TIM1_HALT_Msk             (0x4UL)                   /*!< TIM1_HALT (Bitfield-Mask: 0x01)                       */
#define DBG_CFG_TIM0_HALT_Pos             (1UL)                     /*!< TIM0_HALT (Bit 1)                                     */
#define DBG_CFG_TIM0_HALT_Msk             (0x2UL)                   /*!< TIM0_HALT (Bitfield-Mask: 0x01)                       */
#define DBG_CFG_WDG_HALT_Pos              (0UL)                     /*!< WDG_HALT (Bit 0)                                      */
#define DBG_CFG_WDG_HALT_Msk              (0x1UL)                   /*!< WDG_HALT (Bitfield-Mask: 0x01)                        */


/* =========================================================================================================================== */
/* ================                                            DES                                            ================ */
/* =========================================================================================================================== */

/* =======================================================  UID_WORD0  ======================================================= */
#define DES_UID_WORD0_UID_Pos             (0UL)                     /*!< UID (Bit 0)                                           */
#define DES_UID_WORD0_UID_Msk             (0xffffffffUL)            /*!< UID (Bitfield-Mask: 0xffffffff)                       */
/* =======================================================  UID_WORD1  ======================================================= */
#define DES_UID_WORD1_UID_Pos             (0UL)                     /*!< UID (Bit 0)                                           */
#define DES_UID_WORD1_UID_Msk             (0xffffffffUL)            /*!< UID (Bitfield-Mask: 0xffffffff)                       */
/* =======================================================  UID_WORD2  ======================================================= */
#define DES_UID_WORD2_UID_Pos             (0UL)                     /*!< UID (Bit 0)                                           */
#define DES_UID_WORD2_UID_Msk             (0xffffffffUL)            /*!< UID (Bitfield-Mask: 0xffffffff)                       */
/* =======================================================  DEV_INFO0  ======================================================= */
#define DES_DEV_INFO0_PROD_TYPE_Pos       (28UL)                    /*!< PROD_TYPE (Bit 28)                                    */
#define DES_DEV_INFO0_PROD_TYPE_Msk       (0xf0000000UL)            /*!< PROD_TYPE (Bitfield-Mask: 0x0f)                       */
#define DES_DEV_INFO0_SUB_FAM_Pos         (12UL)                    /*!< SUB_FAM (Bit 12)                                      */
#define DES_DEV_INFO0_SUB_FAM_Msk         (0xffff000UL)             /*!< SUB_FAM (Bitfield-Mask: 0xffff)                       */
#define DES_DEV_INFO0_PIN_NUM_Pos         (8UL)                     /*!< PIN_NUM (Bit 8)                                       */
#define DES_DEV_INFO0_PIN_NUM_Msk         (0xf00UL)                 /*!< PIN_NUM (Bitfield-Mask: 0x0f)                         */
#define DES_DEV_INFO0_FLASH_SIZE_Pos      (4UL)                     /*!< FLASH_SIZE (Bit 4)                                    */
#define DES_DEV_INFO0_FLASH_SIZE_Msk      (0xf0UL)                  /*!< FLASH_SIZE (Bitfield-Mask: 0x0f)                      */
#define DES_DEV_INFO0_PKG_TYPE_Pos        (0UL)                     /*!< PKG_TYPE (Bit 0)                                      */
#define DES_DEV_INFO0_PKG_TYPE_Msk        (0xfUL)                   /*!< PKG_TYPE (Bitfield-Mask: 0x0f)                        */
/* =======================================================  DEV_INFO1  ======================================================= */
#define DES_DEV_INFO1_GATE_DRIVER_Pos     (28UL)                    /*!< GATE_DRIVER (Bit 28)                                  */
#define DES_DEV_INFO1_GATE_DRIVER_Msk     (0xf0000000UL)            /*!< GATE_DRIVER (Bitfield-Mask: 0x0f)                     */
#define DES_DEV_INFO1_INT_LDO_Pos         (24UL)                    /*!< INT_LDO (Bit 24)                                      */
#define DES_DEV_INFO1_INT_LDO_Msk         (0xf000000UL)             /*!< INT_LDO (Bitfield-Mask: 0x0f)                         */
#define DES_DEV_INFO1_INT_VERSION_Pos     (20UL)                    /*!< INT_VERSION (Bit 20)                                  */
#define DES_DEV_INFO1_INT_VERSION_Msk     (0xf00000UL)              /*!< INT_VERSION (Bitfield-Mask: 0x0f)                     */
#define DES_DEV_INFO1_TEMP_Pos            (16UL)                    /*!< TEMP (Bit 16)                                         */
#define DES_DEV_INFO1_TEMP_Msk            (0xf0000UL)               /*!< TEMP (Bitfield-Mask: 0x0f)                            */
#define DES_DEV_INFO1_PKG_VERSION_Pos     (12UL)                    /*!< PKG_VERSION (Bit 12)                                  */
#define DES_DEV_INFO1_PKG_VERSION_Msk     (0xf000UL)                /*!< PKG_VERSION (Bitfield-Mask: 0x0f)                     */
#define DES_DEV_INFO1_MCU_VERSION_Pos     (8UL)                     /*!< MCU_VERSION (Bit 8)                                   */
#define DES_DEV_INFO1_MCU_VERSION_Msk     (0xf00UL)                 /*!< MCU_VERSION (Bitfield-Mask: 0x0f)                     */
#define DES_DEV_INFO1_RAM_SIZE_Pos        (0UL)                     /*!< RAM_SIZE (Bit 0)                                      */
#define DES_DEV_INFO1_RAM_SIZE_Msk        (0xffUL)                  /*!< RAM_SIZE (Bitfield-Mask: 0xff)                        */


/* =========================================================================================================================== */
/* ================                                           TIM                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CNT  ========================================================== */
#define TIM_CNT_CNT_Pos                   (0UL)                     /*!< CNT (Bit 0)                                           */
#define TIM_CNT_CNT_Msk                   (0xffffffffUL)            /*!< CNT (Bitfield-Mask: 0xffffffff)                       */
/* =====================================  ===================  ARR  ========================================================== */
#define TIM_ARR_ARR_Pos                   (0UL)                     /*!< ARR (Bit 0)                                           */
#define TIM_ARR_ARR_Msk                   (0xffffffffUL)            /*!< ARR (Bitfield-Mask: 0xffffffff)                       */
/* =====================================  ===================  CR  =========================================================== */
#define TIM_CR_TRIG_TYPE_Pos              (12UL)                    /*!< TRIG_TYPE (Bit 12)                                    */
#define TIM_CR_TRIG_TYPE_Msk              (0x3000UL)                /*!< TRIG_TYPE (Bitfield-Mask: 0x03)                       */
#define TIM_CR_TRIG_SRC_Pos               (8UL)                     /*!< TRIG_SRC (Bit 8)                                      */
#define TIM_CR_TRIG_SRC_Msk               (0x300UL)                 /*!< TRIG_SRC (Bitfield-Mask: 0x03)                        */
#define TIM_CR_IE_Pos                     (2UL)                     /*!< IE (Bit 2)                                            */
#define TIM_CR_IE_Msk                     (0x4UL)                   /*!< IE (Bitfield-Mask: 0x01)                              */
#define TIM_CR_SINGLE_Pos                 (1UL)                     /*!< SINGLE (Bit 1)                                        */
#define TIM_CR_SINGLE_Msk                 (0x2UL)                   /*!< SINGLE (Bitfield-Mask: 0x01)                          */
#define TIM_CR_EN_Pos                     (0UL)                     /*!< EN (Bit 0)                                            */
#define TIM_CR_EN_Msk                     (0x1UL)                   /*!< EN (Bitfield-Mask: 0x01)                              */
/* =====================================  ===================  SR  =========================================================== */
#define TIM_SR_BUSY_Pos                   (1UL)                     /*!< BUSY (Bit 1)                                          */
#define TIM_SR_BUSY_Msk                   (0x2UL)                   /*!< BUSY (Bitfield-Mask: 0x01)                            */
#define TIM_SR_IF_Pos                     (0UL)                     /*!< IF (Bit 0)                                            */
#define TIM_SR_IF_Msk                     (0x1UL)                   /*!< IF (Bitfield-Mask: 0x01)                              */


/* =========================================================================================================================== */
/* ================                                           CCT                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CNT  ========================================================== */
#define CCT_CNT_CNT_Pos                   (0UL)                     /*!< CNT (Bit 0)                                           */
#define CCT_CNT_CNT_Msk                   (0xffffUL)                /*!< CNT (Bitfield-Mask: 0xffff)                           */
/* ==========================================================  ARR  ========================================================== */
#define CCT_ARR_ARR_Pos                   (0UL)                     /*!< ARR (Bit 0)                                           */
#define CCT_ARR_ARR_Msk                   (0xffffUL)                /*!< ARR (Bitfield-Mask: 0xffff)                           */
/* ==========================================================  CR  =========================================================== */
#define CCT_CR_IN2_ACMP_SEL_Pos           (29UL)                    /*!< IN2_ACMP_SEL (Bit 29)                                 */
#define CCT_CR_IN2_ACMP_SEL_Msk           (0x20000000UL)            /*!< IN2_ACMP_SEL (Bitfield-Mask: 0x01)                    */
#define CCT_CR_IN2_SEL_Pos                (28UL)                    /*!< IN2_IN_SEL (Bit 28)                                   */
#define CCT_CR_IN2_SEL_Msk                (0x10000000UL)            /*!< IN2_IN_SEL (Bitfield-Mask: 0x01)                      */
#define CCT_CR_IN1_ACMP_SEL_Pos           (27UL)                    /*!< IN1_ACMP_SEL (Bit 27)                                 */
#define CCT_CR_IN1_ACMP_SEL_Msk           (0x8000000UL)             /*!< IN1_ACMP_SEL (Bitfield-Mask: 0x01)                    */
#define CCT_CR_IN1_SEL_Pos                (26UL)                    /*!< IN1_IN_SEL (Bit 26)                                   */
#define CCT_CR_IN1_SEL_Msk                (0x4000000UL)             /*!< IN1_IN_SEL (Bitfield-Mask: 0x01)                      */
#define CCT_CR_IN0_ACMP_SEL_Pos           (25UL)                    /*!< IN0_ACMP_SEL (Bit 25)                                 */
#define CCT_CR_IN0_ACMP_SEL_Msk           (0x2000000UL)             /*!< IN0_ACMP_SEL (Bitfield-Mask: 0x01)                    */
#define CCT_CR_IN0_SEL_Pos                (24UL)                    /*!< IN0_IN_SEL (Bit 24)                                   */
#define CCT_CR_IN0_SEL_Msk                (0x1000000UL)             /*!< CH0_IN_SEL (Bitfield-Mask: 0x01)                      */
#define CCT_CR_CH2_CMP_IE_Pos             (22UL)                    /*!< CH2_CMP_IE (Bit 22)                                   */
#define CCT_CR_CH2_CMP_IE_Msk             (0x400000UL)              /*!< CH2_CMP_IE (Bitfield-Mask: 0x01)                      */
#define CCT_CR_CH1_CMP_IE_Pos             (21UL)                    /*!< CH1_CMP_IE (Bit 21)                                   */
#define CCT_CR_CH1_CMP_IE_Msk             (0x200000UL)              /*!< CH1_CMP_IE (Bitfield-Mask: 0x01)                      */
#define CCT_CR_CH0_CMP_IE_Pos             (20UL)                    /*!< CH0_CMP_IE (Bit 20)                                   */
#define CCT_CR_CH0_CMP_IE_Msk             (0x100000UL)              /*!< CH0_CMP_IE (Bitfield-Mask: 0x01)                      */
#define CCT_CR_CH2_CAP_IE_Pos             (18UL)                    /*!< CH2_CAP_IE (Bit 18)                                   */
#define CCT_CR_CH2_CAP_IE_Msk             (0x40000UL)               /*!< CH2_CAP_IE (Bitfield-Mask: 0x01)                      */
#define CCT_CR_CH1_CAP_IE_Pos             (17UL)                    /*!< CH1_CAP_IE (Bit 17)                                   */
#define CCT_CR_CH1_CAP_IE_Msk             (0x20000UL)               /*!< CH1_CAP_IE (Bitfield-Mask: 0x01)                      */
#define CCT_CR_CH0_CAP_IE_Pos             (16UL)                    /*!< CH0_CAP_IE (Bit 16)                                   */
#define CCT_CR_CH0_CAP_IE_Msk             (0x10000UL)               /*!< CH0_CAP_IE (Bitfield-Mask: 0x01)                      */
#define CCT_CR_CH2_MODE_Pos               (14UL)                    /*!< CH2_MODE (Bit 14)                                     */
#define CCT_CR_CH2_MODE_Msk               (0x4000UL)                /*!< CH2_MODE (Bitfield-Mask: 0x01)                        */
#define CCT_CR_CH1_MODE_Pos               (13UL)                    /*!< CH1_MODE (Bit 13)                                     */
#define CCT_CR_CH1_MODE_Msk               (0x2000UL)                /*!< CH1_MODE (Bitfield-Mask: 0x01)                        */
#define CCT_CR_CH0_MODE_Pos               (12UL)                    /*!< CH0_MODE (Bit 12)                                     */
#define CCT_CR_CH0_MODE_Msk               (0x1000UL)                /*!< CH0_MODE (Bitfield-Mask: 0x01)                        */
#define CCT_CR_CH2_EN_Pos                 (10UL)                    /*!< CH2_EN (Bit 10)                                       */
#define CCT_CR_CH2_EN_Msk                 (0x400UL)                 /*!< CH2_EN (Bitfield-Mask: 0x01)                          */
#define CCT_CR_CH1_EN_Pos                 (9UL)                     /*!< CH1_EN (Bit 9)                                        */
#define CCT_CR_CH1_EN_Msk                 (0x200UL)                 /*!< CH1_EN (Bitfield-Mask: 0x01)                          */
#define CCT_CR_CH0_EN_Pos                 (8UL)                     /*!< CH0_EN (Bit 8)                                        */
#define CCT_CR_CH0_EN_Msk                 (0x100UL)                 /*!< CH0_EN (Bitfield-Mask: 0x01)                          */
#define CCT_CR_LVAL_IE_Pos                (5UL)                     /*!< LVAL_IE (Bit 5)                                       */
#define CCT_CR_LVAL_IE_Msk                (0x20UL)                  /*!< LVAL_IE (Bitfield-Mask: 0x01)                         */
#define CCT_CR_CLK_DIV_Pos                (2UL)                     /*!< CLK_DIV (Bit 2)                                       */
#define CCT_CR_CLK_DIV_Msk                (0x1cUL)                  /*!< CLK_DIV (Bitfield-Mask: 0x07)                         */
#define CCT_CR_SINGLE_Pos                 (1UL)                     /*!< SINGLE (Bit 1)                                        */
#define CCT_CR_SINGLE_Msk                 (0x2UL)                   /*!< SINGLE (Bitfield-Mask: 0x01)                          */
#define CCT_CR_EN_Pos                     (0UL)                     /*!< EN (Bit 0)                                            */
#define CCT_CR_EN_Msk                     (0x1UL)                   /*!< EN (Bitfield-Mask: 0x01)                              */
/* ==========================================================  SR  =========================================================== */
#define CCT_SR_CH2_CMP_IF_Pos             (18UL)                    /*!< CH2_CMP_IF (Bit 18)                                   */
#define CCT_SR_CH2_CMP_IF_Msk             (0x40000UL)               /*!< CH2_CMP_IF (Bitfield-Mask: 0x01)                      */
#define CCT_SR_CH1_CMP_IF_Pos             (17UL)                    /*!< CH1_CMP_IF (Bit 17)                                   */
#define CCT_SR_CH1_CMP_IF_Msk             (0x20000UL)               /*!< CH1_CMP_IF (Bitfield-Mask: 0x01)                      */
#define CCT_SR_CH0_CMP_IF_Pos             (16UL)                    /*!< CH0_CMP_IF (Bit 16)                                   */
#define CCT_SR_CH0_CMP_IF_Msk             (0x10000UL)               /*!< CH0_CMP_IF (Bitfield-Mask: 0x01)                      */
#define CCT_SR_CH2_CAP_FE_Pos             (13UL)                    /*!< CH2_CAP_FE (Bit 13)                                   */
#define CCT_SR_CH2_CAP_FE_Msk             (0x2000UL)                /*!< CH2_CAP_FE (Bitfield-Mask: 0x01)                      */
#define CCT_SR_CH2_CAP_RE_Pos             (12UL)                    /*!< CH2_CAP_RE (Bit 12)                                   */
#define CCT_SR_CH2_CAP_RE_Msk             (0x1000UL)                /*!< CH2_CAP_RE (Bitfield-Mask: 0x01)                      */
#define CCT_SR_CH1_CAP_FE_Pos             (11UL)                    /*!< CH1_CAP_FE (Bit 11)                                   */
#define CCT_SR_CH1_CAP_FE_Msk             (0x800UL)                 /*!< CH1_CAP_FE (Bitfield-Mask: 0x01)                      */
#define CCT_SR_CH1_CAP_RE_Pos             (10UL)                    /*!< CH1_CAP_RE (Bit 10)                                   */
#define CCT_SR_CH1_CAP_RE_Msk             (0x400UL)                 /*!< CH1_CAP_RE (Bitfield-Mask: 0x01)                      */
#define CCT_SR_CH0_CAP_FE_Pos             (9UL)                     /*!< CH0_CAP_FE (Bit 9)                                    */
#define CCT_SR_CH0_CAP_FE_Msk             (0x200UL)                 /*!< CH0_CAP_FE (Bitfield-Mask: 0x01)                      */
#define CCT_SR_CH0_CAP_RE_Pos             (8UL)                     /*!< CH0_CAP_RE (Bit 8)                                    */
#define CCT_SR_CH0_CAP_RE_Msk             (0x100UL)                 /*!< CH0_CAP_RE (Bitfield-Mask: 0x01)                      */
#define CCT_SR_CH2_CAP_IF_Pos             (6UL)                     /*!< CH2_CAP_IF (Bit 6)                                    */
#define CCT_SR_CH2_CAP_IF_Msk             (0x40UL)                  /*!< CH2_CAP_IF (Bitfield-Mask: 0x01)                      */
#define CCT_SR_CH1_CAP_IF_Pos             (5UL)                     /*!< CH1_CAP_IF (Bit 5)                                    */
#define CCT_SR_CH1_CAP_IF_Msk             (0x20UL)                  /*!< CH1_CAP_IF (Bitfield-Mask: 0x01)                      */
#define CCT_SR_CH0_CAP_IF_Pos             (4UL)                     /*!< CH0_CAP_IF (Bit 4)                                    */
#define CCT_SR_CH0_CAP_IF_Msk             (0x10UL)                  /*!< CH0_CAP_IF (Bitfield-Mask: 0x01)                      */
#define CCT_SR_LVAL_IF_Pos                (0UL)                     /*!< LVAL_IF (Bit 0)                                       */
#define CCT_SR_LVAL_IF_Msk                (0x1UL)                   /*!< LVAL_IF (Bitfield-Mask: 0x01)                         */
/* ========================================================  CAP_CFG  ======================================================== */
#define CCT_CAP_CFG_CH2_EDGE_Pos          (21UL)                    /*!< CH2_EDGE (Bit 21)                                     */
#define CCT_CAP_CFG_CH2_EDGE_Msk          (0x600000UL)              /*!< CH2_EDGE (Bitfield-Mask: 0x03)                        */
#define CCT_CAP_CFG_CH2_CNT_CLR_Pos       (20UL)                    /*!< CH2_CNT_CLR (Bit 20)                                  */
#define CCT_CAP_CFG_CH2_CNT_CLR_Msk       (0x100000UL)              /*!< CH2_CNT_CLR (Bitfield-Mask: 0x01)                     */
#define CCT_CAP_CFG_CH2_FLT_LEN_Pos       (18UL)                    /*!< CH2_FLT_LEN (Bit 18)                                  */
#define CCT_CAP_CFG_CH2_FLT_LEN_Msk       (0xc0000UL)               /*!< CH2_FLT_LEN (Bitfield-Mask: 0x03)                     */
#define CCT_CAP_CFG_CH2_FLT_SAMPLE_Pos    (16UL)                    /*!< CH2_FLT_SAMPLE (Bit 16)                               */
#define CCT_CAP_CFG_CH2_FLT_SAMPLE_Msk    (0x30000UL)               /*!< CH2_FLT_SAMPLE (Bitfield-Mask: 0x03)                  */
#define CCT_CAP_CFG_CH1_EDGE_Pos          (13UL)                    /*!< CH1_EDGE (Bit 13)                                     */
#define CCT_CAP_CFG_CH1_EDGE_Msk          (0x6000UL)                /*!< CH1_EDGE (Bitfield-Mask: 0x03)                        */
#define CCT_CAP_CFG_CH1_CNT_CLR_Pos       (12UL)                    /*!< CH1_CNT_CLR (Bit 12)                                  */
#define CCT_CAP_CFG_CH1_CNT_CLR_Msk       (0x1000UL)                /*!< CH1_CNT_CLR (Bitfield-Mask: 0x01)                     */
#define CCT_CAP_CFG_CH1_FLT_LEN_Pos       (10UL)                    /*!< CH1_FLT_LEN (Bit 10)                                  */
#define CCT_CAP_CFG_CH1_FLT_LEN_Msk       (0xc00UL)                 /*!< CH1_FLT_LEN (Bitfield-Mask: 0x03)                     */
#define CCT_CAP_CFG_CH1_FLT_SAMPLE_Pos    (8UL)                     /*!< CH1_FLT_SAMPLE (Bit 8)                                */
#define CCT_CAP_CFG_CH1_FLT_SAMPLE_Msk    (0x300UL)                 /*!< CH1_FLT_SAMPLE (Bitfield-Mask: 0x03)                  */
#define CCT_CAP_CFG_CH0_EDGE_Pos          (5UL)                     /*!< CH0_EDGE (Bit 5)                                      */
#define CCT_CAP_CFG_CH0_EDGE_Msk          (0x60UL)                  /*!< CH0_EDGE (Bitfield-Mask: 0x03)                        */
#define CCT_CAP_CFG_CH0_CNT_CLR_Pos       (4UL)                     /*!< CH0_CNT_CLR (Bit 4)                                   */
#define CCT_CAP_CFG_CH0_CNT_CLR_Msk       (0x10UL)                  /*!< CH0_CNT_CLR (Bitfield-Mask: 0x01)                     */
#define CCT_CAP_CFG_CH0_FLT_LEN_Pos       (2UL)                     /*!< CH0_FLT_LEN (Bit 2)                                   */
#define CCT_CAP_CFG_CH0_FLT_LEN_Msk       (0xcUL)                   /*!< CH0_FLT_LEN (Bitfield-Mask: 0x03)                     */
#define CCT_CAP_CFG_CH0_FLT_SAMPLE_Pos    (0UL)                     /*!< CH0_FLT_SAMPLE (Bit 0)                                */
#define CCT_CAP_CFG_CH0_FLT_SAMPLE_Msk    (0x3UL)                   /*!< CH0_FLT_SAMPLE (Bitfield-Mask: 0x03)                  */
/* ========================================================  CMP_CFG  ======================================================== */
#define CCT_CMP_CFG_CH2_INIT_O_Pos        (2UL)                     /*!< CH2_INIT_O (Bit 2)                                    */
#define CCT_CMP_CFG_CH2_INIT_O_Msk        (0x4UL)                   /*!< CH2_INIT_O (Bitfield-Mask: 0x01)                      */
#define CCT_CMP_CFG_CH1_INIT_O_Pos        (1UL)                     /*!< CH1_INIT_O (Bit 1)                                    */
#define CCT_CMP_CFG_CH1_INIT_O_Msk        (0x2UL)                   /*!< CH1_INIT_O (Bitfield-Mask: 0x01)                      */
#define CCT_CMP_CFG_CH0_INIT_O_Pos        (0UL)                     /*!< CH0_INIT_O (Bit 0)                                    */
#define CCT_CMP_CFG_CH0_INIT_O_Msk        (0x1UL)                   /*!< CH0_INIT_O (Bitfield-Mask: 0x01)                      */
/* =======================================================  CH0_VALUE  ======================================================= */
#define CCT_CH0_VALUE_VAL_Pos             (0UL)                     /*!< VAL (Bit 0)                                           */
#define CCT_CH0_VALUE_VAL_Msk             (0xffffUL)                /*!< VAL (Bitfield-Mask: 0xffff)                           */
/* =======================================================  CH1_VALUE  ======================================================= */
#define CCT_CH1_VALUE_VAL_Pos             (0UL)                     /*!< VAL (Bit 0)                                           */
#define CCT_CH1_VALUE_VAL_Msk             (0xffffUL)                /*!< VAL (Bitfield-Mask: 0xffff)                           */
/* =======================================================  CH2_VALUE  ======================================================= */
#define CCT_CH2_VALUE_VAL_Pos             (0UL)                     /*!< VAL (Bit 0)                                           */
#define CCT_CH2_VALUE_VAL_Msk             (0xffffUL)                /*!< VAL (Bitfield-Mask: 0xffff)                           */


/* =========================================================================================================================== */
/* ================                                           EPWM                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CNT  ========================================================== */
#define EPWM_CNT_CNT_Pos                  (0UL)                     /*!< CNT (Bit 0)                                           */
#define EPWM_CNT_CNT_Msk                  (0xffffUL)                /*!< CNT (Bitfield-Mask: 0xffff)                           */
/* ==========================================================  ARR  ========================================================== */
#define EPWM_ARR_ARR_Pos                  (0UL)                     /*!< ARR (Bit 0)                                           */
#define EPWM_ARR_ARR_Msk                  (0xffffUL)                /*!< ARR (Bitfield-Mask: 0xffff)                           */
/* ==========================================================  CR  =========================================================== */
#define EPWM_CR_STOP_IE_Pos               (15UL)                    /*!< STOP_IE (Bit 15)                                      */
#define EPWM_CR_STOP_IE_Msk               (0x8000UL)                /*!< STOP_IE (Bitfield-Mask: 0x01)                         */
#define EPWM_CR_ADC_CMP2_IE_Pos           (14UL)                    /*!< ADC_CMP2_IE (Bit 14)                                  */
#define EPWM_CR_ADC_CMP2_IE_Msk           (0x4000UL)                /*!< ADC_CMP2_IE (Bitfield-Mask: 0x01)                     */
#define EPWM_CR_ADC_CMP1_IE_Pos           (13UL)                    /*!< ADC_CMP1_IE (Bit 13)                                  */
#define EPWM_CR_ADC_CMP1_IE_Msk           (0x2000UL)                /*!< ADC_CMP1_IE (Bitfield-Mask: 0x01)                     */
#define EPWM_CR_PERIOD_IE_Pos             (12UL)                    /*!< PERIOD_IE (Bit 12)                                    */
#define EPWM_CR_PERIOD_IE_Msk             (0x1000UL)                /*!< PERIOD_IE (Bitfield-Mask: 0x01)                       */
#define EPWM_CR_LOAD_VAL_IE_Pos           (11UL)                    /*!< LOAD_VAL_IE (Bit 11)                                  */
#define EPWM_CR_LOAD_VAL_IE_Msk           (0x800UL)                 /*!< LOAD_VAL_IE (Bitfield-Mask: 0x01)                     */
#define EPWM_CR_CLK_DIV_Pos               (8UL)                     /*!< CLK_DIV (Bit 8)                                       */
#define EPWM_CR_CLK_DIV_Msk               (0x700UL)                 /*!< CLK_DIV (Bitfield-Mask: 0x07)                         */
#define EPWM_CR_CH2_EN_Pos                (6UL)                     /*!< CH2_EN (Bit 6)                                        */
#define EPWM_CR_CH2_EN_Msk                (0x40UL)                  /*!< CH2_EN (Bitfield-Mask: 0x01)                          */
#define EPWM_CR_CH1_EN_Pos                (5UL)                     /*!< CH1_EN (Bit 5)                                        */
#define EPWM_CR_CH1_EN_Msk                (0x20UL)                  /*!< CH1_EN (Bitfield-Mask: 0x01)                          */
#define EPWM_CR_CH0_EN_Pos                (4UL)                     /*!< CH0_EN (Bit 4)                                        */
#define EPWM_CR_CH0_EN_Msk                (0x10UL)                  /*!< CH0_EN (Bitfield-Mask: 0x01)                          */
#define EPWM_CR_MODE_Pos                  (2UL)                     /*!< MODE (Bit 2)                                          */
#define EPWM_CR_MODE_Msk                  (0x4UL)                   /*!< MODE (Bitfield-Mask: 0x01)                            */
#define EPWM_CR_SINGLE_Pos                (1UL)                     /*!< SINGLE (Bit 1)                                        */
#define EPWM_CR_SINGLE_Msk                (0x2UL)                   /*!< SINGLE (Bitfield-Mask: 0x01)                          */
#define EPWM_CR_EN_Pos                    (0UL)                     /*!< EN (Bit 0)                                            */
#define EPWM_CR_EN_Msk                    (0x1UL)                   /*!< EN (Bitfield-Mask: 0x01)                              */
/* ==========================================================  SR  =========================================================== */
#define EPWM_SR_STOP_IF_Pos               (4UL)                     /*!< STOP_IF (Bit 4)                                       */
#define EPWM_SR_STOP_IF_Msk               (0x10UL)                  /*!< STOP_IF (Bitfield-Mask: 0x01)                         */
#define EPWM_SR_ADC_CMP2_IF_Pos           (3UL)                     /*!< ADC_CMP2_IF (Bit 3)                                   */
#define EPWM_SR_ADC_CMP2_IF_Msk           (0x8UL)                   /*!< ADC_CMP2_IF (Bitfield-Mask: 0x01)                     */
#define EPWM_SR_ADC_CMP1_IF_Pos           (2UL)                     /*!< ADC_CMP1_IF (Bit 2)                                   */
#define EPWM_SR_ADC_CMP1_IF_Msk           (0x4UL)                   /*!< ADC_CMP1_IF (Bitfield-Mask: 0x01)                     */
#define EPWM_SR_PERIOD_IF_Pos             (1UL)                     /*!< PERIOD_IF (Bit 1)                                     */
#define EPWM_SR_PERIOD_IF_Msk             (0x2UL)                   /*!< PERIOD_IF (Bitfield-Mask: 0x01)                       */
#define EPWM_SR_LOAD_VAL_IF_Pos           (0UL)                     /*!< LOAD_VAL_IF (Bit 0)                                   */
#define EPWM_SR_LOAD_VAL_IF_Msk           (0x1UL)                   /*!< LOAD_VAL_IF (Bitfield-Mask: 0x01)                     */
/* ========================================================  CMP_CFG  ======================================================== */
#define EPWM_CMP_CFG_ADC_CMP2_DIR_Pos     (18UL)                    /*!< ADC_CMP2_DIR (Bit 18)                                 */
#define EPWM_CMP_CFG_ADC_CMP2_DIR_Msk     (0xc0000UL)               /*!< ADC_CMP2_DIR (Bitfield-Mask: 0x03)                    */
#define EPWM_CMP_CFG_ADC_CMP1_DIR_Pos     (16UL)                    /*!< ADC_CMP1_DIR (Bit 16)                                 */
#define EPWM_CMP_CFG_ADC_CMP1_DIR_Msk     (0x30000UL)               /*!< ADC_CMP1_DIR (Bitfield-Mask: 0x03)                    */
#define EPWM_CMP_CFG_CH2_CMP2_DIR_Pos     (10UL)                    /*!< CH2_CMP2_DIR (Bit 10)                                 */
#define EPWM_CMP_CFG_CH2_CMP2_DIR_Msk     (0xc00UL)                 /*!< CH2_CMP2_DIR (Bitfield-Mask: 0x03)                    */
#define EPWM_CMP_CFG_CH2_CMP1_DIR_Pos     (8UL)                     /*!< CH2_CMP1_DIR (Bit 8)                                  */
#define EPWM_CMP_CFG_CH2_CMP1_DIR_Msk     (0x300UL)                 /*!< CH2_CMP1_DIR (Bitfield-Mask: 0x03)                    */
#define EPWM_CMP_CFG_CH1_CMP2_DIR_Pos     (6UL)                     /*!< CH1_CMP2_DIR (Bit 6)                                  */
#define EPWM_CMP_CFG_CH1_CMP2_DIR_Msk     (0xc0UL)                  /*!< CH1_CMP2_DIR (Bitfield-Mask: 0x03)                    */
#define EPWM_CMP_CFG_CH1_CMP1_DIR_Pos     (4UL)                     /*!< CH1_CMP1_DIR (Bit 4)                                  */
#define EPWM_CMP_CFG_CH1_CMP1_DIR_Msk     (0x30UL)                  /*!< CH1_CMP1_DIR (Bitfield-Mask: 0x03)                    */
#define EPWM_CMP_CFG_CH0_CMP2_DIR_Pos     (2UL)                     /*!< CH0_CMP2_DIR (Bit 2)                                  */
#define EPWM_CMP_CFG_CH0_CMP2_DIR_Msk     (0xcUL)                   /*!< CH0_CMP2_DIR (Bitfield-Mask: 0x03)                    */
#define EPWM_CMP_CFG_CH0_CMP1_DIR_Pos     (0UL)                     /*!< CH0_CMP1_DIR (Bit 0)                                  */
#define EPWM_CMP_CFG_CH0_CMP1_DIR_Msk     (0x3UL)                   /*!< CH0_CMP1_DIR (Bitfield-Mask: 0x03)                    */
/* =======================================================  ADC_CMP1  ======================================================== */
#define EPWM_ADC_CMP1_CMP_VAL_Pos         (0UL)                     /*!< CMP_VAL (Bit 0)                                       */
#define EPWM_ADC_CMP1_CMP_VAL_Msk         (0xffffUL)                /*!< CMP_VAL (Bitfield-Mask: 0xffff)                       */
/* =======================================================  ADC_CMP2  ======================================================== */
#define EPWM_ADC_CMP2_CMP_VAL_Pos         (0UL)                     /*!< CMP_VAL (Bit 0)                                       */
#define EPWM_ADC_CMP2_CMP_VAL_Msk         (0xffffUL)                /*!< CMP_VAL (Bitfield-Mask: 0xffff)                       */
/* =======================================================  CH0_CMP1  ======================================================== */
#define EPWM_CH0_CMP1_CMP_VAL_Pos         (0UL)                     /*!< CMP_VAL (Bit 0)                                       */
#define EPWM_CH0_CMP1_CMP_VAL_Msk         (0xffffUL)                /*!< CMP_VAL (Bitfield-Mask: 0xffff)                       */
/* =======================================================  CH0_CMP2  ======================================================== */
#define EPWM_CH0_CMP2_CMP_VAL_Pos         (0UL)                     /*!< CMP_VAL (Bit 0)                                       */
#define EPWM_CH0_CMP2_CMP_VAL_Msk         (0xffffUL)                /*!< CMP_VAL (Bitfield-Mask: 0xffff)                       */
/* =======================================================  CH1_CMP1  ======================================================== */
#define EPWM_CH1_CMP1_CMP_VAL_Pos         (0UL)                     /*!< CMP_VAL (Bit 0)                                       */
#define EPWM_CH1_CMP1_CMP_VAL_Msk         (0xffffUL)                /*!< CMP_VAL (Bitfield-Mask: 0xffff)                       */
/* =======================================================  CH1_CMP2  ======================================================== */
#define EPWM_CH1_CMP2_CMP_VAL_Pos         (0UL)                     /*!< CMP_VAL (Bit 0)                                       */
#define EPWM_CH1_CMP2_CMP_VAL_Msk         (0xffffUL)                /*!< CMP_VAL (Bitfield-Mask: 0xffff)                       */
/* =======================================================  CH2_CMP1  ======================================================== */
#define EPWM_CH2_CMP1_CMP_VAL_Pos         (0UL)                     /*!< CMP_VAL (Bit 0)                                       */
#define EPWM_CH2_CMP1_CMP_VAL_Msk         (0xffffUL)                /*!< CMP_VAL (Bitfield-Mask: 0xffff)                       */
/* =======================================================  CH2_CMP2  ======================================================== */
#define EPWM_CH2_CMP2_CMP_VAL_Pos         (0UL)                     /*!< CMP_VAL (Bit 0)                                       */
#define EPWM_CH2_CMP2_CMP_VAL_Msk         (0xffffUL)                /*!< CMP_VAL (Bitfield-Mask: 0xffff)                       */
/* ========================================================  UPDATE  ========================================================= */
#define EPWM_UPDATE_UPDATE_Pos            (0UL)                     /*!< UPDATE (Bit 0)                                        */
#define EPWM_UPDATE_UPDATE_Msk            (0x1UL)                   /*!< UPDATE (Bitfield-Mask: 0x01)                          */
/* =========================================================  CH_CR  ========================================================= */
#define EPWM_CH_CR_CH2_PP_Pos             (29UL)                    /*!< CH2_PP (Bit 29)                                       */
#define EPWM_CH_CR_CH2_PP_Msk             (0x20000000UL)            /*!< CH2_PP (Bitfield-Mask: 0x01)                          */
#define EPWM_CH_CR_CH2_NP_Pos             (28UL)                    /*!< CH2_NP (Bit 28)                                       */
#define EPWM_CH_CR_CH2_NP_Msk             (0x10000000UL)            /*!< CH2_NP (Bitfield-Mask: 0x01)                          */
#define EPWM_CH_CR_CH1_PP_Pos             (27UL)                    /*!< CH1_PP (Bit 27)                                       */
#define EPWM_CH_CR_CH1_PP_Msk             (0x8000000UL)             /*!< CH1_PP (Bitfield-Mask: 0x01)                          */
#define EPWM_CH_CR_CH1_NP_Pos             (26UL)                    /*!< CH1_NP (Bit 26)                                       */
#define EPWM_CH_CR_CH1_NP_Msk             (0x4000000UL)             /*!< CH1_NP (Bitfield-Mask: 0x01)                          */
#define EPWM_CH_CR_CH0_PP_Pos             (25UL)                    /*!< CH0_PP (Bit 25)                                       */
#define EPWM_CH_CR_CH0_PP_Msk             (0x2000000UL)             /*!< CH0_PP (Bitfield-Mask: 0x01)                          */
#define EPWM_CH_CR_CH0_NP_Pos             (24UL)                    /*!< CH0_NP (Bit 24)                                       */
#define EPWM_CH_CR_CH0_NP_Msk             (0x1000000UL)             /*!< CH0_NP (Bitfield-Mask: 0x01)                          */
#define EPWM_CH_CR_CH2_INIT_O_Pos         (18UL)                    /*!< CH2_INIT_O (Bit 18)                                   */
#define EPWM_CH_CR_CH2_INIT_O_Msk         (0x40000UL)               /*!< CH2_INIT_O (Bitfield-Mask: 0x01)                      */
#define EPWM_CH_CR_CH1_INIT_O_Pos         (17UL)                    /*!< CH1_INIT_O (Bit 17)                                   */
#define EPWM_CH_CR_CH1_INIT_O_Msk         (0x20000UL)               /*!< CH1_INIT_O (Bitfield-Mask: 0x01)                      */
#define EPWM_CH_CR_CH0_INIT_O_Pos         (16UL)                    /*!< CH0_INIT_O (Bit 16)                                   */
#define EPWM_CH_CR_CH0_INIT_O_Msk         (0x10000UL)               /*!< CH0_INIT_O (Bitfield-Mask: 0x01)                      */
#define EPWM_CH_CR_CH2_CMP2_ACT_Pos       (10UL)                    /*!< CH2_CMP2_ACT (Bit 10)                                 */
#define EPWM_CH_CR_CH2_CMP2_ACT_Msk       (0xc00UL)                 /*!< CH2_CMP2_ACT (Bitfield-Mask: 0x03)                    */
#define EPWM_CH_CR_CH2_CMP1_ACT_Pos       (8UL)                     /*!< CH2_CMP1_ACT (Bit 8)                                  */
#define EPWM_CH_CR_CH2_CMP1_ACT_Msk       (0x300UL)                 /*!< CH2_CMP1_ACT (Bitfield-Mask: 0x03)                    */
#define EPWM_CH_CR_CH1_CMP2_ACT_Pos       (6UL)                     /*!< CH1_CMP2_ACT (Bit 6)                                  */
#define EPWM_CH_CR_CH1_CMP2_ACT_Msk       (0xc0UL)                  /*!< CH1_CMP2_ACT (Bitfield-Mask: 0x03)                    */
#define EPWM_CH_CR_CH1_CMP1_ACT_Pos       (4UL)                     /*!< CH1_CMP1_ACT (Bit 4)                                  */
#define EPWM_CH_CR_CH1_CMP1_ACT_Msk       (0x30UL)                  /*!< CH1_CMP1_ACT (Bitfield-Mask: 0x03)                    */
#define EPWM_CH_CR_CH0_CMP2_ACT_Pos       (2UL)                     /*!< CH0_CMP2_ACT (Bit 2)                                  */
#define EPWM_CH_CR_CH0_CMP2_ACT_Msk       (0xcUL)                   /*!< CH0_CMP2_ACT (Bitfield-Mask: 0x03)                    */
#define EPWM_CH_CR_CH0_CMP1_ACT_Pos       (0UL)                     /*!< CH0_CMP1_ACT (Bit 0)                                  */
#define EPWM_CH_CR_CH0_CMP1_ACT_Msk       (0x3UL)                   /*!< CH0_CMP1_ACT (Bitfield-Mask: 0x03)                    */
/* ========================================================  OUT_CR  ========================================================= */
#define EPWM_OUT_CR_CH2_P_FORCE_O_Pos     (11UL)                    /*!< CH2_P_FORCE_O (Bit 11)                                */
#define EPWM_OUT_CR_CH2_P_FORCE_O_Msk     (0x800UL)                 /*!< CH2_P_FORCE_O (Bitfield-Mask: 0x01)                   */
#define EPWM_OUT_CR_CH2_N_FORCE_O_Pos     (10UL)                    /*!< CH2_N_FORCE_O (Bit 10)                                */
#define EPWM_OUT_CR_CH2_N_FORCE_O_Msk     (0x400UL)                 /*!< CH2_N_FORCE_O (Bitfield-Mask: 0x01)                   */
#define EPWM_OUT_CR_CH2_P_FORCE_EN_Pos    (9UL)                     /*!< CH2_P_FORCE_EN (Bit 9)                                */
#define EPWM_OUT_CR_CH2_P_FORCE_EN_Msk    (0x200UL)                 /*!< CH2_P_FORCE_EN (Bitfield-Mask: 0x01)                  */
#define EPWM_OUT_CR_CH2_N_FORCE_EN_Pos    (8UL)                     /*!< CH2_N_FORCE_EN (Bit 8)                                */
#define EPWM_OUT_CR_CH2_N_FORCE_EN_Msk    (0x100UL)                 /*!< CH2_N_FORCE_EN (Bitfield-Mask: 0x01)                  */
#define EPWM_OUT_CR_CH1_P_FORCE_O_Pos     (7UL)                     /*!< CH1_P_FORCE_O (Bit 7)                                 */
#define EPWM_OUT_CR_CH1_P_FORCE_O_Msk     (0x80UL)                  /*!< CH1_P_FORCE_O (Bitfield-Mask: 0x01)                   */
#define EPWM_OUT_CR_CH1_N_FORCE_O_Pos     (6UL)                     /*!< CH1_N_FORCE_O (Bit 6)                                 */
#define EPWM_OUT_CR_CH1_N_FORCE_O_Msk     (0x40UL)                  /*!< CH1_N_FORCE_O (Bitfield-Mask: 0x01)                   */
#define EPWM_OUT_CR_CH1_P_FORCE_EN_Pos    (5UL)                     /*!< CH1_P_FORCE_EN (Bit 5)                                */
#define EPWM_OUT_CR_CH1_P_FORCE_EN_Msk    (0x20UL)                  /*!< CH1_P_FORCE_EN (Bitfield-Mask: 0x01)                  */
#define EPWM_OUT_CR_CH1_N_FORCE_EN_Pos    (4UL)                     /*!< CH1_N_FORCE_EN (Bit 4)                                */
#define EPWM_OUT_CR_CH1_N_FORCE_EN_Msk    (0x10UL)                  /*!< CH1_N_FORCE_EN (Bitfield-Mask: 0x01)                  */
#define EPWM_OUT_CR_CH0_P_FORCE_O_Pos     (3UL)                     /*!< CH0_P_FORCE_O (Bit 3)                                 */
#define EPWM_OUT_CR_CH0_P_FORCE_O_Msk     (0x8UL)                   /*!< CH0_P_FORCE_O (Bitfield-Mask: 0x01)                   */
#define EPWM_OUT_CR_CH0_N_FORCE_O_Pos     (2UL)                     /*!< CH0_N_FORCE_O (Bit 2)                                 */
#define EPWM_OUT_CR_CH0_N_FORCE_O_Msk     (0x4UL)                   /*!< CH0_N_FORCE_O (Bitfield-Mask: 0x01)                   */
#define EPWM_OUT_CR_CH0_P_FORCE_EN_Pos    (1UL)                     /*!< CH0_P_FORCE_EN (Bit 1)                                */
#define EPWM_OUT_CR_CH0_P_FORCE_EN_Msk    (0x2UL)                   /*!< CH0_P_FORCE_EN (Bitfield-Mask: 0x01)                  */
#define EPWM_OUT_CR_CH0_N_FORCE_EN_Pos    (0UL)                     /*!< CH0_N_FORCE_EN (Bit 0)                                */
#define EPWM_OUT_CR_CH0_N_FORCE_EN_Msk    (0x1UL)                   /*!< CH0_N_FORCE_EN (Bitfield-Mask: 0x01)                  */
/* =========================================================  DT_CR  ========================================================= */
#define EPWM_DT_CR_DT_LEN_Pos             (0UL)                     /*!< DT_LEN (Bit 0)                                        */
#define EPWM_DT_CR_DT_LEN_Msk             (0x3ffUL)                 /*!< DT_LEN (Bitfield-Mask: 0x3ff)                         */
/* ========================================================  STOP_CR  ======================================================== */
#define EPWM_STOP_CR_CH2_P_STOP_OEN_Pos   (29UL)                    /*!< CH2_P_STOP_OEN (Bit 29)                               */
#define EPWM_STOP_CR_CH2_P_STOP_OEN_Msk   (0x20000000UL)            /*!< CH2_P_STOP_OEN (Bitfield-Mask: 0x01)                  */
#define EPWM_STOP_CR_CH2_N_STOP_OEN_Pos   (28UL)                    /*!< CH2_N_STOP_OEN (Bit 28)                               */
#define EPWM_STOP_CR_CH2_N_STOP_OEN_Msk   (0x10000000UL)            /*!< CH2_N_STOP_OEN (Bitfield-Mask: 0x01)                  */
#define EPWM_STOP_CR_CH1_P_STOP_OEN_Pos   (27UL)                    /*!< CH1_P_STOP_OEN (Bit 27)                               */
#define EPWM_STOP_CR_CH1_P_STOP_OEN_Msk   (0x8000000UL)             /*!< CH1_P_STOP_OEN (Bitfield-Mask: 0x01)                  */
#define EPWM_STOP_CR_CH1_N_STOP_OEN_Pos   (26UL)                    /*!< CH1_N_STOP_OEN (Bit 26)                               */
#define EPWM_STOP_CR_CH1_N_STOP_OEN_Msk   (0x4000000UL)             /*!< CH1_N_STOP_OEN (Bitfield-Mask: 0x01)                  */
#define EPWM_STOP_CR_CH0_P_STOP_OEN_Pos   (25UL)                    /*!< CH0_P_STOP_OEN (Bit 25)                               */
#define EPWM_STOP_CR_CH0_P_STOP_OEN_Msk   (0x2000000UL)             /*!< CH0_P_STOP_OEN (Bitfield-Mask: 0x01)                  */
#define EPWM_STOP_CR_CH0_N_STOP_OEN_Pos   (24UL)                    /*!< CH0_N_STOP_OEN (Bit 24)                               */
#define EPWM_STOP_CR_CH0_N_STOP_OEN_Msk   (0x1000000UL)             /*!< CH0_N_STOP_OEN (Bitfield-Mask: 0x01)                  */
#define EPWM_STOP_CR_CH2_P_STOP_O_Pos     (21UL)                    /*!< CH2_P_STOP_O (Bit 21)                                 */
#define EPWM_STOP_CR_CH2_P_STOP_O_Msk     (0x200000UL)              /*!< CH2_P_STOP_O (Bitfield-Mask: 0x01)                    */
#define EPWM_STOP_CR_CH2_N_STOP_O_Pos     (20UL)                    /*!< CH2_N_STOP_O (Bit 20)                                 */
#define EPWM_STOP_CR_CH2_N_STOP_O_Msk     (0x100000UL)              /*!< CH2_N_STOP_O (Bitfield-Mask: 0x01)                    */
#define EPWM_STOP_CR_CH1_P_STOP_O_Pos     (19UL)                    /*!< CH1_P_STOP_O (Bit 19)                                 */
#define EPWM_STOP_CR_CH1_P_STOP_O_Msk     (0x80000UL)               /*!< CH1_P_STOP_O (Bitfield-Mask: 0x01)                    */
#define EPWM_STOP_CR_CH1_N_STOP_O_Pos     (18UL)                    /*!< CH1_N_STOP_O (Bit 18)                                 */
#define EPWM_STOP_CR_CH1_N_STOP_O_Msk     (0x40000UL)               /*!< CH1_N_STOP_O (Bitfield-Mask: 0x01)                    */
#define EPWM_STOP_CR_CH0_P_STOP_O_Pos     (17UL)                    /*!< CH0_P_STOP_O (Bit 17)                                 */
#define EPWM_STOP_CR_CH0_P_STOP_O_Msk     (0x20000UL)               /*!< CH0_P_STOP_O (Bitfield-Mask: 0x01)                    */
#define EPWM_STOP_CR_CH0_N_STOP_O_Pos     (16UL)                    /*!< CH0_N_STOP_O (Bit 16)                                 */
#define EPWM_STOP_CR_CH0_N_STOP_O_Msk     (0x10000UL)               /*!< CH0_N_STOP_O (Bitfield-Mask: 0x01)                    */
#define EPWM_STOP_CR_ACMP_MODE_Pos        (15UL)                    /*!< ACMP_MODE (Bit 15)                                    */
#define EPWM_STOP_CR_ACMP_MODE_Msk        (0x8000UL)                /*!< ACMP_MODE (Bitfield-Mask: 0x01)                       */
#define EPWM_STOP_CR_DBG_STOP_EN_Pos      (14UL)                    /*!< DBG_STOP_EN (Bit 14)                                  */
#define EPWM_STOP_CR_DBG_STOP_EN_Msk      (0x4000UL)                /*!< DBG_STOP_EN (Bitfield-Mask: 0x01)                     */
#define EPWM_STOP_CR_ACMP_SEL_Pos         (12UL)                    /*!< ACMP_SEL (Bit 12)                                     */
#define EPWM_STOP_CR_ACMP_SEL_Msk         (0x1000UL)                /*!< ACMP_SEL (Bitfield-Mask: 0x01)                        */
#define EPWM_STOP_CR_ACMP_POL_SEL_Pos     (11UL)                    /*!< ACMP_POL_SEL (Bit 11)                                 */
#define EPWM_STOP_CR_ACMP_POL_SEL_Msk     (0x800UL)                 /*!< ACMP_POL_SEL (Bitfield-Mask: 0x01)                    */
#define EPWM_STOP_CR_ACMP_STOP_EN_Pos     (10UL)                    /*!< ACMP_STOP_EN (Bit 10)                                 */
#define EPWM_STOP_CR_ACMP_STOP_EN_Msk     (0x400UL)                 /*!< ACMP_STOP_EN (Bitfield-Mask: 0x01)                    */
#define EPWM_STOP_CR_EXT_POL_SEL_Pos      (9UL)                     /*!< EXT_POL_SEL (Bit 9)                                   */
#define EPWM_STOP_CR_EXT_POL_SEL_Msk      (0x200UL)                 /*!< EXT_POL_SEL (Bitfield-Mask: 0x01)                     */
#define EPWM_STOP_CR_EXT_STOP_EN_Pos      (8UL)                     /*!< EXT_STOP_EN (Bit 8)                                   */
#define EPWM_STOP_CR_EXT_STOP_EN_Msk      (0x100UL)                 /*!< EXT_STOP_EN (Bitfield-Mask: 0x01)                     */
#define EPWM_STOP_CR_FLT_LEN_Pos          (2UL)                     /*!< FLT_LEN (Bit 2)                                       */
#define EPWM_STOP_CR_FLT_LEN_Msk          (0xcUL)                   /*!< FLT_LEN (Bitfield-Mask: 0x03)                         */
#define EPWM_STOP_CR_FLT_SAMPLE_Pos       (0UL)                     /*!< FLT_SAMPLE (Bit 0)                                    */
#define EPWM_STOP_CR_FLT_SAMPLE_Msk       (0x3UL)                   /*!< FLT_SAMPLE (Bitfield-Mask: 0x03)                      */
/* ========================================================  STOP_SR  ======================================================== */
#define EPWM_STOP_SR_ACMP_PROT_Pos        (3UL)                     /*!< ACMP_PROT (Bit 3)                                     */
#define EPWM_STOP_SR_ACMP_PROT_Msk        (0x8UL)                   /*!< ACMP_PROT (Bitfield-Mask: 0x01)                       */
#define EPWM_STOP_SR_ACMP_TRIG_Pos        (2UL)                     /*!< ACMP_TRIG (Bit 2)                                     */
#define EPWM_STOP_SR_ACMP_TRIG_Msk        (0x4UL)                   /*!< ACMP_TRIG (Bitfield-Mask: 0x01)                       */
#define EPWM_STOP_SR_EXT_TRIG_Pos         (1UL)                     /*!< EXT_TRIG (Bit 1)                                      */
#define EPWM_STOP_SR_EXT_TRIG_Msk         (0x2UL)                   /*!< EXT_TRIG (Bitfield-Mask: 0x01)                        */
#define EPWM_STOP_SR_STOP_Pos             (0UL)                     /*!< STOP (Bit 0)                                          */
#define EPWM_STOP_SR_STOP_Msk             (0x1UL)                   /*!< STOP (Bitfield-Mask: 0x01)                            */
/* =========================================================  LOCK  ========================================================== */
#define EPWM_LOCK_KEY_Pos                 (16UL)                    /*!< KEY (Bit 16)                                          */
#define EPWM_LOCK_KEY_Msk                 (0xffff0000UL)            /*!< KEY (Bitfield-Mask: 0xffff)                           */
#define EPWM_LOCK_VAL_Pos                 (0UL)                     /*!< VAL (Bit 0)                                           */
#define EPWM_LOCK_VAL_Msk                 (0x1UL)                   /*!< VAL (Bitfield-Mask: 0x01)                             */


/* =========================================================================================================================== */
/* ================                                            WDG                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CSR  ========================================================== */
#define WDG_CSR_M_VAL_Pos                 (16UL)                    /*!< M_VAL (Bit 16)                                        */
#define WDG_CSR_M_VAL_Msk                 (0xffff0000UL)            /*!< M_VAL (Bitfield-Mask: 0xffff)                         */
#define WDG_CSR_MODE_Pos                  (4UL)                     /*!< MODE (Bit 4)                                          */
#define WDG_CSR_MODE_Msk                  (0xf0UL)                  /*!< MODE (Bitfield-Mask: 0x0f)                            */
#define WDG_CSR_MASK_Pos                  (3UL)                     /*!< MASK (Bit 3)                                          */
#define WDG_CSR_MASK_Msk                  (0x8UL)                   /*!< MASK (Bitfield-Mask: 0x01)                            */
#define WDG_CSR_IF_Pos                    (2UL)                     /*!< IF (Bit 2)                                            */
#define WDG_CSR_IF_Msk                    (0x4UL)                   /*!< IF (Bitfield-Mask: 0x01)                              */
#define WDG_CSR_IE_Pos                    (1UL)                     /*!< IE (Bit 1)                                            */
#define WDG_CSR_IE_Msk                    (0x2UL)                   /*!< IE (Bitfield-Mask: 0x01)                              */
#define WDG_CSR_EN_Pos                    (0UL)                     /*!< EN (Bit 0)                                            */
#define WDG_CSR_EN_Msk                    (0x1UL)                   /*!< EN (Bitfield-Mask: 0x01)                              */
/* ==========================================================  CLR  ========================================================== */
#define WDG_CLR_CLR_WDG_Pos               (0UL)                     /*!< CLR_WDG (Bit 0)                                       */
#define WDG_CLR_CLR_WDG_Msk               (0xffffffffUL)            /*!< CLR_WDG (Bitfield-Mask: 0xffffffff)                   */



/* =========================================================================================================================== */
/* ================                                           LPTIM                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  CR  =========================================================== */
#define LPTIM_CR_WK_IE_Pos                (8UL)                     /*!< WK_IE (Bit 8)                                         */
#define LPTIM_CR_WK_IE_Msk                (0x100UL)                 /*!< WK_IE (Bitfield-Mask: 0x01)                           */
#define LPTIM_CR_WK_EN_Pos                (0UL)                     /*!< WK_EN (Bit 0)                                         */
#define LPTIM_CR_WK_EN_Msk                (0x1UL)                   /*!< WK_EN (Bitfield-Mask: 0x01)                           */
/* ==========================================================  SR  =========================================================== */
#define LPTIM_SR_WK_IF_Pos                (0UL)                     /*!< WK_IF (Bit 0)                                         */
#define LPTIM_SR_WK_IF_Msk                (0x1UL)                   /*!< WK_IF (Bitfield-Mask: 0x01)                           */
/* =======================================================  WAKEUP_CR  ======================================================= */
#define LPTIM_WAKEUP_CR_CNT_Pos           (0UL)                     /*!< CNT (Bit 0)                                           */
#define LPTIM_WAKEUP_CR_CNT_Msk           (0xffffffffUL)            /*!< CNT (Bitfield-Mask: 0xffffffff)                       */
/* =====================================================  WAKEUP_PERIOD  ===================================================== */
#define LPTIM_WAKEUP_PERIOD_WK_P_Pos      (0UL)                     /*!< WK_P (Bit 0)                                          */
#define LPTIM_WAKEUP_PERIOD_WK_P_Msk      (0xffffffffUL)            /*!< WK_P (Bitfield-Mask: 0xffffffff)                      */


/* =========================================================================================================================== */
/* ================                                           SPI                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CR  =========================================================== */
#define SPI_CR_HS_SLAVE_Pos               (23UL)                    /*!< HS_SLAVE (Bit 23)                                     */
#define SPI_CR_HS_SLAVE_Msk               (0x800000UL)              /*!< HS_SLAVE (Bitfield-Mask: 0x01)                        */
#define SPI_CR_CONT_RCV_Pos               (22UL)                    /*!< CONT_RCV (Bit 22)                                     */
#define SPI_CR_CONT_RCV_Msk               (0x400000UL)              /*!< CONT_RCV (Bitfield-Mask: 0x01)                        */
#define SPI_CR_NSS_SEL_Pos                (21UL)                    /*!< NSS_SEL (Bit 21)                                      */
#define SPI_CR_NSS_SEL_Msk                (0x200000UL)              /*!< NSS_SEL (Bitfield-Mask: 0x01)                         */
#define SPI_CR_LSB_FIRST_Pos              (20UL)                    /*!< LSB_FIRST (Bit 20)                                    */
#define SPI_CR_LSB_FIRST_Msk              (0x100000UL)              /*!< LSB_FIRST (Bitfield-Mask: 0x01)                       */
#define SPI_CR_ERR_IE_Pos                 (18UL)                    /*!< ERR_IE (Bit 18)                                       */
#define SPI_CR_ERR_IE_Msk                 (0x40000UL)               /*!< ERR_IE (Bitfield-Mask: 0x01)                          */
#define SPI_CR_TXE_IE_Pos                 (17UL)                    /*!< TXE_IE (Bit 17)                                       */
#define SPI_CR_TXE_IE_Msk                 (0x20000UL)               /*!< TXE_IE (Bitfield-Mask: 0x01)                          */
#define SPI_CR_RXNE_IE_Pos                (16UL)                    /*!< RXNE_IE (Bit 16)                                      */
#define SPI_CR_RXNE_IE_Msk                (0x10000UL)               /*!< RXNE_IE (Bitfield-Mask: 0x01)                         */
#define SPI_CR_FRAME_INR_Pos              (12UL)                    /*!< FRAME_INR (Bit 12)                                    */
#define SPI_CR_FRAME_INR_Msk              (0xf000UL)                /*!< FRAME_INR (Bitfield-Mask: 0x0f)                       */
#define SPI_CR_DATA_SIZE_Pos              (8UL)                     /*!< DATA_SIZE (Bit 8)                                     */
#define SPI_CR_DATA_SIZE_Msk              (0xf00UL)                 /*!< DATA_SIZE (Bitfield-Mask: 0x0f)                       */
#define SPI_CR_TX_EN_Pos                  (5UL)                     /*!< TX_EN (Bit 5)                                         */
#define SPI_CR_TX_EN_Msk                  (0x20UL)                  /*!< TX_EN (Bitfield-Mask: 0x01)                           */
#define SPI_CR_RX_EN_Pos                  (4UL)                     /*!< RX_EN (Bit 4)                                         */
#define SPI_CR_RX_EN_Msk                  (0x10UL)                  /*!< RX_EN (Bitfield-Mask: 0x01)                           */
#define SPI_CR_CPOL_Pos                   (3UL)                     /*!< CPOL (Bit 3)                                          */
#define SPI_CR_CPOL_Msk                   (0x8UL)                   /*!< CPOL (Bitfield-Mask: 0x01)                            */
#define SPI_CR_CPHA_Pos                   (2UL)                     /*!< CPHA (Bit 2)                                          */
#define SPI_CR_CPHA_Msk                   (0x4UL)                   /*!< CPHA (Bitfield-Mask: 0x01)                            */
#define SPI_CR_MASTER_Pos                 (1UL)                     /*!< MASTER (Bit 1)                                        */
#define SPI_CR_MASTER_Msk                 (0x2UL)                   /*!< MASTER (Bitfield-Mask: 0x01)                          */
#define SPI_CR_EN_Pos                     (0UL)                     /*!< EN (Bit 0)                                            */
#define SPI_CR_EN_Msk                     (0x1UL)                   /*!< EN (Bitfield-Mask: 0x01)                              */
/* ==========================================================  ISR  ========================================================== */
#define SPI_ISR_BUSY_Pos                  (5UL)                     /*!< BUSY (Bit 5)                                          */
#define SPI_ISR_BUSY_Msk                  (0x20UL)                  /*!< BUSY (Bitfield-Mask: 0x01)                            */
#define SPI_ISR_FAULT_ERR_Pos             (3UL)                     /*!< FAULT_ERR (Bit 3)                                     */
#define SPI_ISR_FAULT_ERR_Msk             (0x8UL)                   /*!< FAULT_ERR (Bitfield-Mask: 0x01)                       */
#define SPI_ISR_OVRR_ERR_Pos              (2UL)                     /*!< OVRR_ERR (Bit 2)                                      */
#define SPI_ISR_OVRR_ERR_Msk              (0x4UL)                   /*!< OVRR_ERR (Bitfield-Mask: 0x01)                        */
#define SPI_ISR_TXE_Pos                   (1UL)                     /*!< TXE (Bit 1)                                           */
#define SPI_ISR_TXE_Msk                   (0x2UL)                   /*!< TXE (Bitfield-Mask: 0x01)                             */
#define SPI_ISR_RXNE_Pos                  (0UL)                     /*!< RXNE (Bit 0)                                          */
#define SPI_ISR_RXNE_Msk                  (0x1UL)                   /*!< RXNE (Bitfield-Mask: 0x01)                            */
/* ==========================================================  BRR  ========================================================== */
#define SPI_BRR_BRR_Pos                   (0UL)                     /*!< BRR (Bit 0)                                           */
#define SPI_BRR_BRR_Msk                   (0xffUL)                  /*!< BRR (Bitfield-Mask: 0xff)                             */
/* ==========================================================  TDR  ========================================================== */
#define SPI_TDR_TDR_Pos                   (0UL)                     /*!< TDR (Bit 0)                                           */
#define SPI_TDR_TDR_Msk                   (0xffffUL)                /*!< TDR (Bitfield-Mask: 0xffff)                           */
/* ==========================================================  RDR  ========================================================== */
#define SPI_RDR_RDR_Pos                   (0UL)                     /*!< RDR (Bit 0)                                           */
#define SPI_RDR_RDR_Msk                   (0xffffUL)                /*!< RDR (Bitfield-Mask: 0xffff)                           */


/* =========================================================================================================================== */
/* ================                                            CRC                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CR  =========================================================== */
#define CRC_CR_XOR_OUT_Pos                (5UL)                     /*!< XOR_OUT (Bit 5)                                       */
#define CRC_CR_XOR_OUT_Msk                (0x20UL)                  /*!< XOR_OUT (Bitfield-Mask: 0x01)                         */
#define CRC_CR_REV_OUT_Pos                (4UL)                     /*!< REV_OUT (Bit 4)                                       */
#define CRC_CR_REV_OUT_Msk                (0x10UL)                  /*!< REV_OUT (Bitfield-Mask: 0x01)                         */
#define CRC_CR_REV_IN_Pos                 (2UL)                     /*!< REV_IN (Bit 2)                                        */
#define CRC_CR_REV_IN_Msk                 (0xcUL)                   /*!< REV_IN (Bitfield-Mask: 0x03)                          */
#define CRC_CR_MODE_Pos                   (0UL)                     /*!< MODE (Bit 0)                                          */
#define CRC_CR_MODE_Msk                   (0x3UL)                   /*!< MODE (Bitfield-Mask: 0x03)                            */
/* =========================================================  DATA  ========================================================== */
#define CRC_DATA_DATA_Pos                 (0UL)                     /*!< DATA (Bit 0)                                          */
#define CRC_DATA_DATA_Msk                 (0xffffffffUL)            /*!< DATA (Bitfield-Mask: 0xffffffff)                      */
/* =========================================================  INIT  ========================================================== */
#define CRC_INIT_INIT_Pos                 (0UL)                     /*!< INIT (Bit 0)                                          */
#define CRC_INIT_INIT_Msk                 (0xffffffffUL)            /*!< INIT (Bitfield-Mask: 0xffffffff)                      */
/* ========================================================  RESULT  ========================================================= */
#define CRC_RESULT_RESULT_Pos             (0UL)                     /*!< RESULT (Bit 0)                                        */
#define CRC_RESULT_RESULT_Msk             (0xffffffffUL)            /*!< RESULT (Bitfield-Mask: 0xffffffff)                    */


/* =========================================================================================================================== */
/* ================                                          ADC_COM                                          ================ */
/* =========================================================================================================================== */

/* ==========================================================  CR  =========================================================== */
#define ADC_COM_CR_SPEED_Pos              (25UL)                    /*!< SPEED (Bit 25)                                        */
#define ADC_COM_CR_SPEED_Msk              (0x2000000UL)             /*!< SPEED (Bitfield-Mask: 0x01)                           */
#define ADC_COM_CR_VREF_SEL_Pos           (24UL)                    /*!< VREF_SEL (Bit 24)                                     */
#define ADC_COM_CR_VREF_SEL_Msk           (0x1000000UL)             /*!< VREF_SEL (Bitfield-Mask: 0x01)                        */
#define ADC_COM_CR_PRESC_Pos              (20UL)                    /*!< PRESC (Bit 20)                                        */
#define ADC_COM_CR_PRESC_Msk              (0x700000UL)              /*!< PRESC (Bitfield-Mask: 0x07)                           */
#define ADC_COM_CR_PGA_SEL1_Pos           (17UL)                    /*!< PGA_SEL1 (Bit 17)                                     */
#define ADC_COM_CR_PGA_SEL1_Msk           (0x20000UL)               /*!< PGA_SEL1 (Bitfield-Mask: 0x01)                        */
#define ADC_COM_CR_PGA_SEL0_Pos           (16UL)                    /*!< PGA_SEL0 (Bit 16)                                     */
#define ADC_COM_CR_PGA_SEL0_Msk           (0x10000UL)               /*!< PGA_SEL0 (Bitfield-Mask: 0x01)                        */
#define ADC_COM_CR_IN15_SEL_Pos           (0UL)                     /*!< IN15_SEL (Bit 0)                                      */
#define ADC_COM_CR_IN15_SEL_Msk           (0x3UL)                   /*!< IN15_SEL (Bitfield-Mask: 0x03)                        */
/* =========================================================  SMPT  ========================================================== */
#define ADC_COM_SMPT_SMPT1_Pos            (28UL)                    /*!< SMPT1 (Bit 28)                                        */
#define ADC_COM_SMPT_SMPT1_Msk            (0x70000000UL)            /*!< SMPT1 (Bitfield-Mask: 0x07)                           */
#define ADC_COM_SMPT_SMPT0_Pos            (24UL)                    /*!< SMPT0 (Bit 24)                                        */
#define ADC_COM_SMPT_SMPT0_Msk            (0x7000000UL)             /*!< SMPT0 (Bitfield-Mask: 0x07)                           */
#define ADC_COM_SMPT_SMPT_SEL15_Pos       (15UL)                    /*!< SMPT_SEL15 (Bit 15)                                   */
#define ADC_COM_SMPT_SMPT_SEL15_Msk       (0x8000UL)                /*!< SMPT_SEL15 (Bitfield-Mask: 0x01)                      */
#define ADC_COM_SMPT_SMPT_SEL14_Pos       (14UL)                    /*!< SMPT_SEL14 (Bit 14)                                   */
#define ADC_COM_SMPT_SMPT_SEL14_Msk       (0x4000UL)                /*!< SMPT_SEL14 (Bitfield-Mask: 0x01)                      */
#define ADC_COM_SMPT_SMPT_SEL13_Pos       (13UL)                    /*!< SMPT_SEL13 (Bit 13)                                   */
#define ADC_COM_SMPT_SMPT_SEL13_Msk       (0x2000UL)                /*!< SMPT_SEL13 (Bitfield-Mask: 0x01)                      */
#define ADC_COM_SMPT_SMPT_SEL12_Pos       (12UL)                    /*!< SMPT_SEL12 (Bit 12)                                   */
#define ADC_COM_SMPT_SMPT_SEL12_Msk       (0x1000UL)                /*!< SMPT_SEL12 (Bitfield-Mask: 0x01)                      */
#define ADC_COM_SMPT_SMPT_SEL11_Pos       (11UL)                    /*!< SMPT_SEL11 (Bit 11)                                   */
#define ADC_COM_SMPT_SMPT_SEL11_Msk       (0x800UL)                 /*!< SMPT_SEL11 (Bitfield-Mask: 0x01)                      */
#define ADC_COM_SMPT_SMPT_SEL10_Pos       (10UL)                    /*!< SMPT_SEL10 (Bit 10)                                   */
#define ADC_COM_SMPT_SMPT_SEL10_Msk       (0x400UL)                 /*!< SMPT_SEL10 (Bitfield-Mask: 0x01)                      */
#define ADC_COM_SMPT_SMPT_SEL9_Pos        (9UL)                     /*!< SMPT_SEL9 (Bit 9)                                     */
#define ADC_COM_SMPT_SMPT_SEL9_Msk        (0x200UL)                 /*!< SMPT_SEL9 (Bitfield-Mask: 0x01)                       */
#define ADC_COM_SMPT_SMPT_SEL8_Pos        (8UL)                     /*!< SMPT_SEL8 (Bit 8)                                     */
#define ADC_COM_SMPT_SMPT_SEL8_Msk        (0x100UL)                 /*!< SMPT_SEL8 (Bitfield-Mask: 0x01)                       */
#define ADC_COM_SMPT_SMPT_SEL7_Pos        (7UL)                     /*!< SMPT_SEL7 (Bit 7)                                     */
#define ADC_COM_SMPT_SMPT_SEL7_Msk        (0x80UL)                  /*!< SMPT_SEL7 (Bitfield-Mask: 0x01)                       */
#define ADC_COM_SMPT_SMPT_SEL6_Pos        (6UL)                     /*!< SMPT_SEL6 (Bit 6)                                     */
#define ADC_COM_SMPT_SMPT_SEL6_Msk        (0x40UL)                  /*!< SMPT_SEL6 (Bitfield-Mask: 0x01)                       */
#define ADC_COM_SMPT_SMPT_SEL5_Pos        (5UL)                     /*!< SMPT_SEL5 (Bit 5)                                     */
#define ADC_COM_SMPT_SMPT_SEL5_Msk        (0x20UL)                  /*!< SMPT_SEL5 (Bitfield-Mask: 0x01)                       */
#define ADC_COM_SMPT_SMPT_SEL4_Pos        (4UL)                     /*!< SMPT_SEL4 (Bit 4)                                     */
#define ADC_COM_SMPT_SMPT_SEL4_Msk        (0x10UL)                  /*!< SMPT_SEL4 (Bitfield-Mask: 0x01)                       */
#define ADC_COM_SMPT_SMPT_SEL3_Pos        (3UL)                     /*!< SMPT_SEL3 (Bit 3)                                     */
#define ADC_COM_SMPT_SMPT_SEL3_Msk        (0x8UL)                   /*!< SMPT_SEL3 (Bitfield-Mask: 0x01)                       */
#define ADC_COM_SMPT_SMPT_SEL2_Pos        (2UL)                     /*!< SMPT_SEL2 (Bit 2)                                     */
#define ADC_COM_SMPT_SMPT_SEL2_Msk        (0x4UL)                   /*!< SMPT_SEL2 (Bitfield-Mask: 0x01)                       */
#define ADC_COM_SMPT_SMPT_SEL1_Pos        (1UL)                     /*!< SMPT_SEL1 (Bit 1)                                     */
#define ADC_COM_SMPT_SMPT_SEL1_Msk        (0x2UL)                   /*!< SMPT_SEL1 (Bitfield-Mask: 0x01)                       */
#define ADC_COM_SMPT_SMPT_SEL0_Pos        (0UL)                     /*!< SMPT_SEL0 (Bit 0)                                     */
#define ADC_COM_SMPT_SMPT_SEL0_Msk        (0x1UL)                   /*!< SMPT_SEL0 (Bitfield-Mask: 0x01)                       */
/* =========================================================  SMPC  ========================================================== */
#define ADC_COM_SMPC_OVS_RATE_Pos         (29UL)                    /*!< OVS_RATE (Bit 29)                                     */
#define ADC_COM_SMPC_OVS_RATE_Msk         (0x60000000UL)            /*!< OVS_RATE (Bitfield-Mask: 0x03)                        */
#define ADC_COM_SMPC_OVS_RES_Pos          (26UL)                    /*!< OVS_RES (Bit 26)                                      */
#define ADC_COM_SMPC_OVS_RES_Msk          (0x1c000000UL)            /*!< OVS_RES (Bitfield-Mask: 0x07)                         */
#define ADC_COM_SMPC_NORM_RES_Pos         (24UL)                    /*!< NORM_RES (Bit 24)                                     */
#define ADC_COM_SMPC_NORM_RES_Msk         (0x3000000UL)             /*!< NORM_RES (Bitfield-Mask: 0x03)                        */
#define ADC_COM_SMPC_OVSEN15_Pos          (15UL)                    /*!< OVSEN15 (Bit 15)                                      */
#define ADC_COM_SMPC_OVSEN15_Msk          (0x8000UL)                /*!< OVSEN15 (Bitfield-Mask: 0x01)                         */
#define ADC_COM_SMPC_OVSEN14_Pos          (14UL)                    /*!< OVSEN14 (Bit 14)                                      */
#define ADC_COM_SMPC_OVSEN14_Msk          (0x4000UL)                /*!< OVSEN14 (Bitfield-Mask: 0x01)                         */
#define ADC_COM_SMPC_OVSEN13_Pos          (13UL)                    /*!< OVSEN13 (Bit 13)                                      */
#define ADC_COM_SMPC_OVSEN13_Msk          (0x2000UL)                /*!< OVSEN13 (Bitfield-Mask: 0x01)                         */
#define ADC_COM_SMPC_OVSEN12_Pos          (12UL)                    /*!< OVSEN12 (Bit 12)                                      */
#define ADC_COM_SMPC_OVSEN12_Msk          (0x1000UL)                /*!< OVSEN12 (Bitfield-Mask: 0x01)                         */
#define ADC_COM_SMPC_OVSEN11_Pos          (11UL)                    /*!< OVSEN11 (Bit 11)                                      */
#define ADC_COM_SMPC_OVSEN11_Msk          (0x800UL)                 /*!< OVSEN11 (Bitfield-Mask: 0x01)                         */
#define ADC_COM_SMPC_OVSEN10_Pos          (10UL)                    /*!< OVSEN10 (Bit 10)                                      */
#define ADC_COM_SMPC_OVSEN10_Msk          (0x400UL)                 /*!< OVSEN10 (Bitfield-Mask: 0x01)                         */
#define ADC_COM_SMPC_OVSEN9_Pos           (9UL)                     /*!< OVSEN9 (Bit 9)                                        */
#define ADC_COM_SMPC_OVSEN9_Msk           (0x200UL)                 /*!< OVSEN9 (Bitfield-Mask: 0x01)                          */
#define ADC_COM_SMPC_OVSEN8_Pos           (8UL)                     /*!< OVSEN8 (Bit 8)                                        */
#define ADC_COM_SMPC_OVSEN8_Msk           (0x100UL)                 /*!< OVSEN8 (Bitfield-Mask: 0x01)                          */
#define ADC_COM_SMPC_OVSEN7_Pos           (7UL)                     /*!< OVSEN7 (Bit 7)                                        */
#define ADC_COM_SMPC_OVSEN7_Msk           (0x80UL)                  /*!< OVSEN7 (Bitfield-Mask: 0x01)                          */
#define ADC_COM_SMPC_OVSEN6_Pos           (6UL)                     /*!< OVSEN6 (Bit 6)                                        */
#define ADC_COM_SMPC_OVSEN6_Msk           (0x40UL)                  /*!< OVSEN6 (Bitfield-Mask: 0x01)                          */
#define ADC_COM_SMPC_OVSEN5_Pos           (5UL)                     /*!< OVSEN5 (Bit 5)                                        */
#define ADC_COM_SMPC_OVSEN5_Msk           (0x20UL)                  /*!< OVSEN5 (Bitfield-Mask: 0x01)                          */
#define ADC_COM_SMPC_OVSEN4_Pos           (4UL)                     /*!< OVSEN4 (Bit 4)                                        */
#define ADC_COM_SMPC_OVSEN4_Msk           (0x10UL)                  /*!< OVSEN4 (Bitfield-Mask: 0x01)                          */
#define ADC_COM_SMPC_OVSEN3_Pos           (3UL)                     /*!< OVSEN3 (Bit 3)                                        */
#define ADC_COM_SMPC_OVSEN3_Msk           (0x8UL)                   /*!< OVSEN3 (Bitfield-Mask: 0x01)                          */
#define ADC_COM_SMPC_OVSEN2_Pos           (2UL)                     /*!< OVSEN2 (Bit 2)                                        */
#define ADC_COM_SMPC_OVSEN2_Msk           (0x4UL)                   /*!< OVSEN2 (Bitfield-Mask: 0x01)                          */
#define ADC_COM_SMPC_OVSEN1_Pos           (1UL)                     /*!< OVSEN1 (Bit 1)                                        */
#define ADC_COM_SMPC_OVSEN1_Msk           (0x2UL)                   /*!< OVSEN1 (Bitfield-Mask: 0x01)                          */
#define ADC_COM_SMPC_OVSEN0_Pos           (0UL)                     /*!< OVSEN0 (Bit 0)                                        */
#define ADC_COM_SMPC_OVSEN0_Msk           (0x1UL)                   /*!< OVSEN0 (Bitfield-Mask: 0x01)                          */
/* ======================================================  CH_OFFSET  ======================================================== */
#define ADC_COM_CH_OFFSET_VALUE_Pos       (0UL)                     /*!< VALUE (Bit 0)                                         */
#define ADC_COM_CH_OFFSET_VALUE_Msk       (0xfffUL)                 /*!< VALUE (Bitfield-Mask: 0xfff)                          */


/* =========================================================================================================================== */
/* ================                                           ADC                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  ISR  ========================================================== */
#define ADC_ISR_OVR_EOI_Pos               (14UL)                    /*!< OVR_EOI (Bit 14)                                      */
#define ADC_ISR_OVR_EOI_Msk               (0x4000UL)                /*!< OVR_EOI (Bitfield-Mask: 0x01)                         */
#define ADC_ISR_OVR_EOC_Pos               (13UL)                    /*!< OVR_EOC (Bit 13)                                      */
#define ADC_ISR_OVR_EOC_Msk               (0x2000UL)                /*!< OVR_EOC (Bitfield-Mask: 0x01)                         */
#define ADC_ISR_OVR_EOT1_Pos              (12UL)                    /*!< OVR_EOT1 (Bit 12)                                     */
#define ADC_ISR_OVR_EOT1_Msk              (0x1000UL)                /*!< OVR_EOT1 (Bitfield-Mask: 0x01)                        */
#define ADC_ISR_OVR_EOT0_Pos              (11UL)                    /*!< OVR_EOT0 (Bit 11)                                     */
#define ADC_ISR_OVR_EOT0_Msk              (0x800UL)                 /*!< OVR_EOT0 (Bitfield-Mask: 0x01)                        */
#define ADC_ISR_OVR_EOS_Pos               (10UL)                    /*!< OVR_EOS (Bit 10)                                      */
#define ADC_ISR_OVR_EOS_Msk               (0x400UL)                 /*!< OVR_EOS (Bitfield-Mask: 0x01)                         */
#define ADC_ISR_EOI_Pos                   (8UL)                     /*!< EOI (Bit 8)                                           */
#define ADC_ISR_EOI_Msk                   (0x100UL)                 /*!< EOI (Bitfield-Mask: 0x01)                             */
#define ADC_ISR_EOC_Pos                   (7UL)                     /*!< EOC (Bit 7)                                           */
#define ADC_ISR_EOC_Msk                   (0x80UL)                  /*!< EOC (Bitfield-Mask: 0x01)                             */
#define ADC_ISR_EOT1_Pos                  (6UL)                     /*!< EOT1 (Bit 6)                                          */
#define ADC_ISR_EOT1_Msk                  (0x40UL)                  /*!< EOT1 (Bitfield-Mask: 0x01)                            */
#define ADC_ISR_EOT0_Pos                  (5UL)                     /*!< EOT0 (Bit 5)                                          */
#define ADC_ISR_EOT0_Msk                  (0x20UL)                  /*!< EOT0 (Bitfield-Mask: 0x01)                            */
#define ADC_ISR_EOS_Pos                   (4UL)                     /*!< EOS (Bit 4)                                           */
#define ADC_ISR_EOS_Msk                   (0x10UL)                  /*!< EOS (Bitfield-Mask: 0x01)                             */
#define ADC_ISR_OVR_SUM_Pos               (1UL)                     /*!< OVR_SUM (Bit 1)                                       */
#define ADC_ISR_OVR_SUM_Msk               (0x2UL)                   /*!< OVR_SUM (Bitfield-Mask: 0x01)                         */
#define ADC_ISR_EO_SUM_Pos                (0UL)                     /*!< EO_SUM (Bit 0)                                        */
#define ADC_ISR_EO_SUM_Msk                (0x1UL)                   /*!< EO_SUM (Bitfield-Mask: 0x01)                          */
/* ==========================================================  IE  =========================================================== */
#define ADC_IE_OVR_Pos                    (12UL)                    /*!< OVR (Bit 12)                                          */
#define ADC_IE_OVR_Msk                    (0x1000UL)                /*!< OVR (Bitfield-Mask: 0x01)                             */
#define ADC_IE_EOI_Pos                    (8UL)                     /*!< EOI (Bit 8)                                           */
#define ADC_IE_EOI_Msk                    (0x100UL)                 /*!< EOI (Bitfield-Mask: 0x01)                             */
#define ADC_IE_EOC_Pos                    (7UL)                     /*!< EOC (Bit 7)                                           */
#define ADC_IE_EOC_Msk                    (0x80UL)                  /*!< EOC (Bitfield-Mask: 0x01)                             */
#define ADC_IE_EOT1_Pos                   (6UL)                     /*!< EOT1 (Bit 6)                                          */
#define ADC_IE_EOT1_Msk                   (0x40UL)                  /*!< EOT1 (Bitfield-Mask: 0x01)                            */
#define ADC_IE_EOT0_Pos                   (5UL)                     /*!< EOT0 (Bit 5)                                          */
#define ADC_IE_EOT0_Msk                   (0x20UL)                  /*!< EOT0 (Bitfield-Mask: 0x01)                            */
#define ADC_IE_EOS_Pos                    (4UL)                     /*!< EOS (Bit 4)                                           */
#define ADC_IE_EOS_Msk                    (0x10UL)                  /*!< EOS (Bitfield-Mask: 0x01)                             */
/* ==========================================================  CFG  ========================================================== */
#define ADC_CFG_ADC_EN_Pos                (0UL)                     /*!< ADC_EN (Bit 0)                                        */
#define ADC_CFG_ADC_EN_Msk                (0x1UL)                   /*!< ADC_EN (Bitfield-Mask: 0x01)                          */
/* ========================================================  FMT_CR  ========================================================= */
#define ADC_FMT_CR_ALIGN15_Pos            (31UL)                    /*!< ALIGN15 (Bit 31)                                      */
#define ADC_FMT_CR_ALIGN15_Msk            (0x80000000UL)            /*!< ALIGN15 (Bitfield-Mask: 0x01)                         */
#define ADC_FMT_CR_ALIGN14_Pos            (30UL)                    /*!< ALIGN14 (Bit 30)                                      */
#define ADC_FMT_CR_ALIGN14_Msk            (0x40000000UL)            /*!< ALIGN14 (Bitfield-Mask: 0x01)                         */
#define ADC_FMT_CR_ALIGN13_Pos            (29UL)                    /*!< ALIGN13 (Bit 29)                                      */
#define ADC_FMT_CR_ALIGN13_Msk            (0x20000000UL)            /*!< ALIGN13 (Bitfield-Mask: 0x01)                         */
#define ADC_FMT_CR_ALIGN12_Pos            (28UL)                    /*!< ALIGN12 (Bit 28)                                      */
#define ADC_FMT_CR_ALIGN12_Msk            (0x10000000UL)            /*!< ALIGN12 (Bitfield-Mask: 0x01)                         */
#define ADC_FMT_CR_ALIGN11_Pos            (27UL)                    /*!< ALIGN11 (Bit 27)                                      */
#define ADC_FMT_CR_ALIGN11_Msk            (0x8000000UL)             /*!< ALIGN11 (Bitfield-Mask: 0x01)                         */
#define ADC_FMT_CR_ALIGN10_Pos            (26UL)                    /*!< ALIGN10 (Bit 26)                                      */
#define ADC_FMT_CR_ALIGN10_Msk            (0x4000000UL)             /*!< ALIGN10 (Bitfield-Mask: 0x01)                         */
#define ADC_FMT_CR_ALIGN9_Pos             (25UL)                    /*!< ALIGN9 (Bit 25)                                       */
#define ADC_FMT_CR_ALIGN9_Msk             (0x2000000UL)             /*!< ALIGN9 (Bitfield-Mask: 0x01)                          */
#define ADC_FMT_CR_ALIGN8_Pos             (24UL)                    /*!< ALIGN8 (Bit 24)                                       */
#define ADC_FMT_CR_ALIGN8_Msk             (0x1000000UL)             /*!< ALIGN8 (Bitfield-Mask: 0x01)                          */
#define ADC_FMT_CR_ALIGN7_Pos             (23UL)                    /*!< ALIGN7 (Bit 23)                                       */
#define ADC_FMT_CR_ALIGN7_Msk             (0x800000UL)              /*!< ALIGN7 (Bitfield-Mask: 0x01)                          */
#define ADC_FMT_CR_ALIGN6_Pos             (22UL)                    /*!< ALIGN6 (Bit 22)                                       */
#define ADC_FMT_CR_ALIGN6_Msk             (0x400000UL)              /*!< ALIGN6 (Bitfield-Mask: 0x01)                          */
#define ADC_FMT_CR_ALIGN5_Pos             (21UL)                    /*!< ALIGN5 (Bit 21)                                       */
#define ADC_FMT_CR_ALIGN5_Msk             (0x200000UL)              /*!< ALIGN5 (Bitfield-Mask: 0x01)                          */
#define ADC_FMT_CR_ALIGN4_Pos             (20UL)                    /*!< ALIGN4 (Bit 20)                                       */
#define ADC_FMT_CR_ALIGN4_Msk             (0x100000UL)              /*!< ALIGN4 (Bitfield-Mask: 0x01)                          */
#define ADC_FMT_CR_ALIGN3_Pos             (19UL)                    /*!< ALIGN3 (Bit 19)                                       */
#define ADC_FMT_CR_ALIGN3_Msk             (0x80000UL)               /*!< ALIGN3 (Bitfield-Mask: 0x01)                          */
#define ADC_FMT_CR_ALIGN2_Pos             (18UL)                    /*!< ALIGN2 (Bit 18)                                       */
#define ADC_FMT_CR_ALIGN2_Msk             (0x40000UL)               /*!< ALIGN2 (Bitfield-Mask: 0x01)                          */
#define ADC_FMT_CR_ALIGN1_Pos             (17UL)                    /*!< ALIGN1 (Bit 17)                                       */
#define ADC_FMT_CR_ALIGN1_Msk             (0x20000UL)               /*!< ALIGN1 (Bitfield-Mask: 0x01)                          */
#define ADC_FMT_CR_ALIGN0_Pos             (16UL)                    /*!< ALIGN0 (Bit 16)                                       */
#define ADC_FMT_CR_ALIGN0_Msk             (0x10000UL)               /*!< ALIGN0 (Bitfield-Mask: 0x01)                          */
#define ADC_FMT_CR_SIGN15_Pos             (15UL)                    /*!< SIGN15 (Bit 15)                                       */
#define ADC_FMT_CR_SIGN15_Msk             (0x8000UL)                /*!< SIGN15 (Bitfield-Mask: 0x01)                          */
#define ADC_FMT_CR_SIGN14_Pos             (14UL)                    /*!< SIGN14 (Bit 14)                                       */
#define ADC_FMT_CR_SIGN14_Msk             (0x4000UL)                /*!< SIGN14 (Bitfield-Mask: 0x01)                          */
#define ADC_FMT_CR_SIGN13_Pos             (13UL)                    /*!< SIGN13 (Bit 13)                                       */
#define ADC_FMT_CR_SIGN13_Msk             (0x2000UL)                /*!< SIGN13 (Bitfield-Mask: 0x01)                          */
#define ADC_FMT_CR_SIGN12_Pos             (12UL)                    /*!< SIGN12 (Bit 12)                                       */
#define ADC_FMT_CR_SIGN12_Msk             (0x1000UL)                /*!< SIGN12 (Bitfield-Mask: 0x01)                          */
#define ADC_FMT_CR_SIGN11_Pos             (11UL)                    /*!< SIGN11 (Bit 11)                                       */
#define ADC_FMT_CR_SIGN11_Msk             (0x800UL)                 /*!< SIGN11 (Bitfield-Mask: 0x01)                          */
#define ADC_FMT_CR_SIGN10_Pos             (10UL)                    /*!< SIGN10 (Bit 10)                                       */
#define ADC_FMT_CR_SIGN10_Msk             (0x400UL)                 /*!< SIGN10 (Bitfield-Mask: 0x01)                          */
#define ADC_FMT_CR_SIGN9_Pos              (9UL)                     /*!< SIGN9 (Bit 9)                                         */
#define ADC_FMT_CR_SIGN9_Msk              (0x200UL)                 /*!< SIGN9 (Bitfield-Mask: 0x01)                           */
#define ADC_FMT_CR_SIGN8_Pos              (8UL)                     /*!< SIGN8 (Bit 8)                                         */
#define ADC_FMT_CR_SIGN8_Msk              (0x100UL)                 /*!< SIGN8 (Bitfield-Mask: 0x01)                           */
#define ADC_FMT_CR_SIGN7_Pos              (7UL)                     /*!< SIGN7 (Bit 7)                                         */
#define ADC_FMT_CR_SIGN7_Msk              (0x80UL)                  /*!< SIGN7 (Bitfield-Mask: 0x01)                           */
#define ADC_FMT_CR_SIGN6_Pos              (6UL)                     /*!< SIGN6 (Bit 6)                                         */
#define ADC_FMT_CR_SIGN6_Msk              (0x40UL)                  /*!< SIGN6 (Bitfield-Mask: 0x01)                           */
#define ADC_FMT_CR_SIGN5_Pos              (5UL)                     /*!< SIGN5 (Bit 5)                                         */
#define ADC_FMT_CR_SIGN5_Msk              (0x20UL)                  /*!< SIGN5 (Bitfield-Mask: 0x01)                           */
#define ADC_FMT_CR_SIGN4_Pos              (4UL)                     /*!< SIGN4 (Bit 4)                                         */
#define ADC_FMT_CR_SIGN4_Msk              (0x10UL)                  /*!< SIGN4 (Bitfield-Mask: 0x01)                           */
#define ADC_FMT_CR_SIGN3_Pos              (3UL)                     /*!< SIGN3 (Bit 3)                                         */
#define ADC_FMT_CR_SIGN3_Msk              (0x8UL)                   /*!< SIGN3 (Bitfield-Mask: 0x01)                           */
#define ADC_FMT_CR_SIGN2_Pos              (2UL)                     /*!< SIGN2 (Bit 2)                                         */
#define ADC_FMT_CR_SIGN2_Msk              (0x4UL)                   /*!< SIGN2 (Bitfield-Mask: 0x01)                           */
#define ADC_FMT_CR_SIGN1_Pos              (1UL)                     /*!< SIGN1 (Bit 1)                                         */
#define ADC_FMT_CR_SIGN1_Msk              (0x2UL)                   /*!< SIGN1 (Bitfield-Mask: 0x01)                           */
#define ADC_FMT_CR_SIGN0_Pos              (0UL)                     /*!< SIGN0 (Bit 0)                                         */
#define ADC_FMT_CR_SIGN0_Msk              (0x1UL)                   /*!< SIGN0 (Bitfield-Mask: 0x01)                           */
/* ========================================================  TRIG_CR  ======================================================== */
#define ADC_TRIG_CR_HW1_CH_Pos            (28UL)                    /*!< HW1_CH (Bit 28)                                       */
#define ADC_TRIG_CR_HW1_CH_Msk            (0xf0000000UL)            /*!< HW1_CH (Bitfield-Mask: 0x0f)                          */
#define ADC_TRIG_CR_HW1_SRC_Pos           (24UL)                    /*!< HW1_SRC (Bit 24)                                      */
#define ADC_TRIG_CR_HW1_SRC_Msk           (0xf000000UL)             /*!< HW1_SRC (Bitfield-Mask: 0x0f)                         */
#define ADC_TRIG_CR_HW0_CH_Pos            (20UL)                    /*!< HW0_CH (Bit 20)                                       */
#define ADC_TRIG_CR_HW0_CH_Msk            (0xf00000UL)              /*!< HW0_CH (Bitfield-Mask: 0x0f)                          */
#define ADC_TRIG_CR_HW0_SRC_Pos           (16UL)                    /*!< HW0_SRC (Bit 16)                                      */
#define ADC_TRIG_CR_HW0_SRC_Msk           (0xf0000UL)               /*!< HW0_SRC (Bitfield-Mask: 0x0f)                         */
#define ADC_TRIG_CR_SW_CH_Pos             (12UL)                    /*!< SW_CH (Bit 12)                                        */
#define ADC_TRIG_CR_SW_CH_Msk             (0xf000UL)                /*!< SW_CH (Bitfield-Mask: 0x0f)                           */
#define ADC_TRIG_CR_CONT_WAIT_Pos         (8UL)                     /*!< CONT_WAIT (Bit 8)                                     */
#define ADC_TRIG_CR_CONT_WAIT_Msk         (0x700UL)                 /*!< CONT_WAIT (Bitfield-Mask: 0x07)                       */
#define ADC_TRIG_CR_STOP_Pos              (7UL)                     /*!< STOP (Bit 7)                                          */
#define ADC_TRIG_CR_STOP_Msk              (0x80UL)                  /*!< STOP (Bitfield-Mask: 0x01)                            */
#define ADC_TRIG_CR_HW1_EN_Pos            (6UL)                     /*!< HW1_EN (Bit 6)                                        */
#define ADC_TRIG_CR_HW1_EN_Msk            (0x40UL)                  /*!< HW1_EN (Bitfield-Mask: 0x01)                          */
#define ADC_TRIG_CR_HW0_EN_Pos            (5UL)                     /*!< HW0_EN (Bit 5)                                        */
#define ADC_TRIG_CR_HW0_EN_Msk            (0x20UL)                  /*!< HW0_EN (Bitfield-Mask: 0x01)                          */
#define ADC_TRIG_CR_SW_START_Pos          (4UL)                     /*!< SW_START (Bit 4)                                      */
#define ADC_TRIG_CR_SW_START_Msk          (0x10UL)                  /*!< SW_START (Bitfield-Mask: 0x01)                        */
#define ADC_TRIG_CR_MODE_Pos              (0UL)                     /*!< MODE (Bit 0)                                          */
#define ADC_TRIG_CR_MODE_Msk              (0x7UL)                   /*!< MODE (Bitfield-Mask: 0x07)                            */
/* ========================================================  INJ_CR  ========================================================= */
#define ADC_INJ_CR_START_Pos              (4UL)                     /*!< START (Bit 4)                                         */
#define ADC_INJ_CR_START_Msk              (0x10UL)                  /*!< START (Bitfield-Mask: 0x01)                           */
#define ADC_INJ_CR_CH_Pos                 (0UL)                     /*!< CH (Bit 0)                                            */
#define ADC_INJ_CR_CH_Msk                 (0xfUL)                   /*!< CH (Bitfield-Mask: 0x0f)                              */
/* =======================================================  SCAN_SQR0  ======================================================= */
#define ADC_SCAN_SQR0_SQ5_CH_Pos          (28UL)                    /*!< SQ5_CH (Bit 28)                                       */
#define ADC_SCAN_SQR0_SQ5_CH_Msk          (0xf0000000UL)            /*!< SQ5_CH (Bitfield-Mask: 0x0f)                          */
#define ADC_SCAN_SQR0_SQ4_CH_Pos          (24UL)                    /*!< SQ4_CH (Bit 24)                                       */
#define ADC_SCAN_SQR0_SQ4_CH_Msk          (0xf000000UL)             /*!< SQ4_CH (Bitfield-Mask: 0x0f)                          */
#define ADC_SCAN_SQR0_SQ3_CH_Pos          (20UL)                    /*!< SQ3_CH (Bit 20)                                       */
#define ADC_SCAN_SQR0_SQ3_CH_Msk          (0xf00000UL)              /*!< SQ3_CH (Bitfield-Mask: 0x0f)                          */
#define ADC_SCAN_SQR0_SQ2_CH_Pos          (16UL)                    /*!< SQ2_CH (Bit 16)                                       */
#define ADC_SCAN_SQR0_SQ2_CH_Msk          (0xf0000UL)               /*!< SQ2_CH (Bitfield-Mask: 0x0f)                          */
#define ADC_SCAN_SQR0_SQ1_CH_Pos          (12UL)                    /*!< SQ1_CH (Bit 12)                                       */
#define ADC_SCAN_SQR0_SQ1_CH_Msk          (0xf000UL)                /*!< SQ1_CH (Bitfield-Mask: 0x0f)                          */
#define ADC_SCAN_SQR0_SQ0_CH_Pos          (8UL)                     /*!< SQ0_CH (Bit 8)                                        */
#define ADC_SCAN_SQR0_SQ0_CH_Msk          (0xf00UL)                 /*!< SQ0_CH (Bitfield-Mask: 0x0f)                          */
#define ADC_SCAN_SQR0_LEN_Pos             (0UL)                     /*!< LEN (Bit 0)                                           */
#define ADC_SCAN_SQR0_LEN_Msk             (0xfUL)                   /*!< LEN (Bitfield-Mask: 0x0f)                             */
/* =======================================================  SCAN_SQR1  ======================================================= */
#define ADC_SCAN_SQR1_SQ9_CH_Pos          (12UL)                    /*!< SQ9_CH (Bit 12)                                       */
#define ADC_SCAN_SQR1_SQ9_CH_Msk          (0xf000UL)                /*!< SQ9_CH (Bitfield-Mask: 0x0f)                          */
#define ADC_SCAN_SQR1_SQ8_CH_Pos          (8UL)                     /*!< SQ8_CH (Bit 8)                                        */
#define ADC_SCAN_SQR1_SQ8_CH_Msk          (0xf00UL)                 /*!< SQ8_CH (Bitfield-Mask: 0x0f)                          */
#define ADC_SCAN_SQR1_SQ7_CH_Pos          (4UL)                     /*!< SQ7_CH (Bit 4)                                        */
#define ADC_SCAN_SQR1_SQ7_CH_Msk          (0xf0UL)                  /*!< SQ7_CH (Bitfield-Mask: 0x0f)                          */
#define ADC_SCAN_SQR1_SQ6_CH_Pos          (0UL)                     /*!< SQ6_CH (Bit 0)                                        */
#define ADC_SCAN_SQR1_SQ6_CH_Msk          (0xfUL)                   /*!< SQ6_CH (Bitfield-Mask: 0x0f)                          */
/* ========================================================  DR_INJ  ========================================================= */
#define ADC_DR_INJ_DATA_Pos               (0UL)                     /*!< DATA (Bit 0)                                          */
#define ADC_DR_INJ_DATA_Msk               (0xffffUL)                /*!< DATA (Bitfield-Mask: 0xffff)                          */
/* =======================================================  DR_TRIG0  ======================================================== */
#define ADC_DR_TRIG0_DATA_Pos             (0UL)                     /*!< DATA (Bit 0)                                          */
#define ADC_DR_TRIG0_DATA_Msk             (0xffffUL)                /*!< DATA (Bitfield-Mask: 0xffff)                          */
/* =======================================================  DR_SCANx  ======================================================== */
#define ADC_DR_SCAN_DATA_Pos              (0UL)                     /*!< DATA (Bit 0)                                          */
#define ADC_DR_SCAN_DATA_Msk              (0xffffUL)                /*!< DATA (Bitfield-Mask: 0xffff)                          */


/* =========================================================================================================================== */
/* ================                                            I2C                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CR1  ========================================================== */
#define I2C_CR1_PRESC_Pos                 (27UL)                    /*!< PRESC (Bit 27)                                        */
#define I2C_CR1_PRESC_Msk                 (0xf8000000UL)            /*!< PRESC (Bitfield-Mask: 0x1f)                           */
#define I2C_CR1_STARTF_IE_Pos             (25UL)                    /*!< STARTF_IE (Bit 25)                                    */
#define I2C_CR1_STARTF_IE_Msk             (0x2000000UL)             /*!< STARTF_IE (Bitfield-Mask: 0x01)                       */
#define I2C_CR1_ERR_IE_Pos                (24UL)                    /*!< ERR_IE (Bit 24)                                       */
#define I2C_CR1_ERR_IE_Msk                (0x1000000UL)             /*!< ERR_IE (Bitfield-Mask: 0x01)                          */
#define I2C_CR1_RXC_IE_Pos                (23UL)                    /*!< RXC_IE (Bit 23)                                       */
#define I2C_CR1_RXC_IE_Msk                (0x800000UL)              /*!< RXC_IE (Bitfield-Mask: 0x01)                          */
#define I2C_CR1_GC_IE_Pos                 (22UL)                    /*!< GC_IE (Bit 22)                                        */
#define I2C_CR1_GC_IE_Msk                 (0x400000UL)              /*!< GC_IE (Bitfield-Mask: 0x01)                           */
#define I2C_CR1_NACKF_IE_Pos              (21UL)                    /*!< NACKF_IE (Bit 21)                                     */
#define I2C_CR1_NACKF_IE_Msk              (0x200000UL)              /*!< NACKF_IE (Bitfield-Mask: 0x01)                        */
#define I2C_CR1_STOPF_IE_Pos              (20UL)                    /*!< STOPF_IE (Bit 20)                                     */
#define I2C_CR1_STOPF_IE_Msk              (0x100000UL)              /*!< STOPF_IE (Bitfield-Mask: 0x01)                        */
#define I2C_CR1_ADDRM_IE_Pos              (19UL)                    /*!< ADDRM_IE (Bit 19)                                     */
#define I2C_CR1_ADDRM_IE_Msk              (0x80000UL)               /*!< ADDRM_IE (Bitfield-Mask: 0x01)                        */
#define I2C_CR1_RXNE_IE_Pos               (18UL)                    /*!< RXNE_IE (Bit 18)                                      */
#define I2C_CR1_RXNE_IE_Msk               (0x40000UL)               /*!< RXNE_IE (Bitfield-Mask: 0x01)                         */
#define I2C_CR1_TXE_IE_Pos                (17UL)                    /*!< TXE_IE (Bit 17)                                       */
#define I2C_CR1_TXE_IE_Msk                (0x20000UL)               /*!< TXE_IE (Bitfield-Mask: 0x01)                          */
#define I2C_CR1_TXC_IE_Pos                (16UL)                    /*!< TXC_IE (Bit 16)                                       */
#define I2C_CR1_TXC_IE_Msk                (0x10000UL)               /*!< TXC_IE (Bitfield-Mask: 0x01)                          */
#define I2C_CR1_DNF_Pos                   (12UL)                    /*!< DNF (Bit 12)                                          */
#define I2C_CR1_DNF_Msk                   (0xf000UL)                /*!< DNF (Bitfield-Mask: 0x0f)                             */
#define I2C_CR1_TIMEOUT_SEL_Pos           (8UL)                     /*!< TIMEOUT_SEL (Bit 8)                                   */
#define I2C_CR1_TIMEOUT_SEL_Msk           (0x700UL)                 /*!< TIMEOUT_SEL (Bitfield-Mask: 0x07)                     */
#define I2C_CR1_NOADDR_Pos                (7UL)                     /*!< NOADDR (Bit 7)                                        */
#define I2C_CR1_NOADDR_Msk                (0x80UL)                  /*!< NOADDR (Bitfield-Mask: 0x01)                          */
#define I2C_CR1_DIS_SLAVE_Pos             (6UL)                     /*!< DIS_SLAVE (Bit 6)                                     */
#define I2C_CR1_DIS_SLAVE_Msk             (0x40UL)                  /*!< DIS_SLAVE (Bitfield-Mask: 0x01)                       */
#define I2C_CR1_GC_EN_Pos                 (3UL)                     /*!< GC_EN (Bit 3)                                         */
#define I2C_CR1_GC_EN_Msk                 (0x8UL)                   /*!< GC_EN (Bitfield-Mask: 0x01)                           */
#define I2C_CR1_NO_STRETCH_Pos            (2UL)                     /*!< NO_STRETCH (Bit 2)                                    */
#define I2C_CR1_NO_STRETCH_Msk            (0x4UL)                   /*!< NO_STRETCH (Bitfield-Mask: 0x01)                      */
#define I2C_CR1_MS_Pos                    (1UL)                     /*!< MS (Bit 1)                                            */
#define I2C_CR1_MS_Msk                    (0x2UL)                   /*!< MS (Bitfield-Mask: 0x01)                              */
#define I2C_CR1_EN_Pos                    (0UL)                     /*!< EN (Bit 0)                                            */
#define I2C_CR1_EN_Msk                    (0x1UL)                   /*!< EN (Bitfield-Mask: 0x01)                              */
/* ==========================================================  CR2  ========================================================== */
#define I2C_CR2_RELOAD_Pos                (24UL)                    /*!< RELOAD (Bit 24)                                       */
#define I2C_CR2_RELOAD_Msk                (0x1000000UL)             /*!< RELOAD (Bitfield-Mask: 0x01)                          */
#define I2C_CR2_BYTES_NUM_Pos             (16UL)                    /*!< BYTES_NUM (Bit 16)                                    */
#define I2C_CR2_BYTES_NUM_Msk             (0xff0000UL)              /*!< BYTES_NUM (Bitfield-Mask: 0xff)                       */
#define I2C_CR2_TXE_SET_Pos               (15UL)                    /*!< TXE_SET (Bit 15)                                      */
#define I2C_CR2_TXE_SET_Msk               (0x8000UL)                /*!< TXE_SET (Bitfield-Mask: 0x01)                         */
#define I2C_CR2_NACK_Pos                  (14UL)                    /*!< NACK (Bit 14)                                         */
#define I2C_CR2_NACK_Msk                  (0x4000UL)                /*!< NACK (Bitfield-Mask: 0x01)                            */
#define I2C_CR2_START_STOP_Pos            (12UL)                    /*!< START_STOP (Bit 12)                                   */
#define I2C_CR2_START_STOP_Msk            (0x3000UL)                /*!< START_STOP (Bitfield-Mask: 0x03)                      */
#define I2C_CR2_WR_Pos                    (11UL)                    /*!< WR (Bit 11)                                           */
#define I2C_CR2_WR_Msk                    (0x800UL)                 /*!< WR (Bitfield-Mask: 0x01)                              */
#define I2C_CR2_ADDR10_Pos                (10UL)                    /*!< ADDR10 (Bit 10)                                       */
#define I2C_CR2_ADDR10_Msk                (0x400UL)                 /*!< ADDR10 (Bitfield-Mask: 0x01)                          */
#define I2C_CR2_SADDR_Pos                 (0UL)                     /*!< SADDR (Bit 0)                                         */
#define I2C_CR2_SADDR_Msk                 (0x3ffUL)                 /*!< SADDR (Bitfield-Mask: 0x3ff)                          */
/* ==========================================================  ISR  ========================================================== */
#define I2C_ISR_TIMEOUT_Pos               (15UL)                    /*!< TIMEOUT (Bit 15)                                      */
#define I2C_ISR_TIMEOUT_Msk               (0x8000UL)                /*!< TIMEOUT (Bitfield-Mask: 0x01)                         */
#define I2C_ISR_STARTF_Pos                (14UL)                    /*!< STARTF (Bit 14)                                       */
#define I2C_ISR_STARTF_Msk                (0x4000UL)                /*!< STARTF (Bitfield-Mask: 0x01)                          */
#define I2C_ISR_BUSY_Pos                  (13UL)                    /*!< BUSY (Bit 13)                                         */
#define I2C_ISR_BUSY_Msk                  (0x2000UL)                /*!< BUSY (Bitfield-Mask: 0x01)                            */
#define I2C_ISR_DIR_Pos                   (12UL)                    /*!< DIR (Bit 12)                                          */
#define I2C_ISR_DIR_Msk                   (0x1000UL)                /*!< DIR (Bitfield-Mask: 0x01)                             */
#define I2C_ISR_OVRR_UDRR_Pos             (11UL)                    /*!< OVRR_UDRR (Bit 11)                                    */
#define I2C_ISR_OVRR_UDRR_Msk             (0x800UL)                 /*!< OVRR_UDRR (Bitfield-Mask: 0x01)                       */
#define I2C_ISR_BUS_ERR_Pos               (10UL)                    /*!< BUS_ERR (Bit 10)                                      */
#define I2C_ISR_BUS_ERR_Msk               (0x400UL)                 /*!< BUS_ERR (Bitfield-Mask: 0x01)                         */
#define I2C_ISR_ARBI_LOST_Pos             (9UL)                     /*!< ARBI_LOST (Bit 9)                                     */
#define I2C_ISR_ARBI_LOST_Msk             (0x200UL)                 /*!< ARBI_LOST (Bitfield-Mask: 0x01)                       */
#define I2C_ISR_GC_Pos                    (8UL)                     /*!< GC (Bit 8)                                            */
#define I2C_ISR_GC_Msk                    (0x100UL)                 /*!< GC (Bitfield-Mask: 0x01)                              */
#define I2C_ISR_RXC_Pos                   (7UL)                     /*!< RXC (Bit 7)                                           */
#define I2C_ISR_RXC_Msk                   (0x80UL)                  /*!< RXC (Bitfield-Mask: 0x01)                             */
#define I2C_ISR_RXC_RE_Pos                (6UL)                     /*!< RXC_RE (Bit 6)                                        */
#define I2C_ISR_RXC_RE_Msk                (0x40UL)                  /*!< RXC_RE (Bitfield-Mask: 0x01)                          */
#define I2C_ISR_NACKF_Pos                 (5UL)                     /*!< NACKF (Bit 5)                                         */
#define I2C_ISR_NACKF_Msk                 (0x20UL)                  /*!< NACKF (Bitfield-Mask: 0x01)                           */
#define I2C_ISR_STOPF_Pos                 (4UL)                     /*!< STOPF (Bit 4)                                         */
#define I2C_ISR_STOPF_Msk                 (0x10UL)                  /*!< STOPF (Bitfield-Mask: 0x01)                           */
#define I2C_ISR_ADDRM_Pos                 (3UL)                     /*!< ADDRM (Bit 3)                                         */
#define I2C_ISR_ADDRM_Msk                 (0x8UL)                   /*!< ADDRM (Bitfield-Mask: 0x01)                           */
#define I2C_ISR_RXNE_Pos                  (2UL)                     /*!< RXNE (Bit 2)                                          */
#define I2C_ISR_RXNE_Msk                  (0x4UL)                   /*!< RXNE (Bitfield-Mask: 0x01)                            */
#define I2C_ISR_TXE_Pos                   (1UL)                     /*!< TXE (Bit 1)                                           */
#define I2C_ISR_TXE_Msk                   (0x2UL)                   /*!< TXE (Bitfield-Mask: 0x01)                             */
#define I2C_ISR_TXC_Pos                   (0UL)                     /*!< TXC (Bit 0)                                           */
#define I2C_ISR_TXC_Msk                   (0x1UL)                   /*!< TXC (Bitfield-Mask: 0x01)                             */
/* ========================================================  TIMING  ========================================================= */
#define I2C_TIMING_SCLDEL_I_Pos           (27UL)                    /*!< SCLDEL_I (Bit 27)                                     */
#define I2C_TIMING_SCLDEL_I_Msk           (0x38000000UL)            /*!< SCLDEL_I (Bitfield-Mask: 0x07)                        */
#define I2C_TIMING_SDADEL_I_Pos           (24UL)                    /*!< SDADEL_I (Bit 24)                                     */
#define I2C_TIMING_SDADEL_I_Msk           (0x7000000UL)             /*!< SDADEL_I (Bitfield-Mask: 0x07)                        */
#define I2C_TIMING_SCLDEL_O_Pos           (20UL)                    /*!< SCLDEL_O (Bit 20)                                     */
#define I2C_TIMING_SCLDEL_O_Msk           (0xf00000UL)              /*!< SCLDEL_O (Bitfield-Mask: 0x0f)                        */
#define I2C_TIMING_SDADEL_O_Pos           (16UL)                    /*!< SDADEL_O (Bit 16)                                     */
#define I2C_TIMING_SDADEL_O_Msk           (0xf0000UL)               /*!< SDADEL_O (Bitfield-Mask: 0x0f)                        */
#define I2C_TIMING_SCLH_Pos               (8UL)                     /*!< SCLH (Bit 8)                                          */
#define I2C_TIMING_SCLH_Msk               (0xff00UL)                /*!< SCLH (Bitfield-Mask: 0xff)                            */
#define I2C_TIMING_SCLL_Pos               (0UL)                     /*!< SCLL (Bit 0)                                          */
#define I2C_TIMING_SCLL_Msk               (0xffUL)                  /*!< SCLL (Bitfield-Mask: 0xff)                            */
/* ==========================================================  OAR  ========================================================== */
#define I2C_OAR_OWN_ADDR10_Pos            (10UL)                    /*!< OWN_ADDR10 (Bit 10)                                   */
#define I2C_OAR_OWN_ADDR10_Msk            (0x400UL)                 /*!< OWN_ADDR10 (Bitfield-Mask: 0x01)                      */
#define I2C_OAR_OWN_ADDR_Pos              (0UL)                     /*!< OWN_ADDR (Bit 0)                                      */
#define I2C_OAR_OWN_ADDR_Msk              (0x3ffUL)                 /*!< OWN_ADDR (Bitfield-Mask: 0x3ff)                       */
/* ==========================================================  TDR  ========================================================== */
#define I2C_TDR_TDR_Pos                   (0UL)                     /*!< TDR (Bit 0)                                           */
#define I2C_TDR_TDR_Msk                   (0xffUL)                  /*!< TDR (Bitfield-Mask: 0xff)                             */
/* ==========================================================  RDR  ========================================================== */
#define I2C_RDR_RDR_Pos                   (0UL)                     /*!< RDR (Bit 0)                                           */
#define I2C_RDR_RDR_Msk                   (0xffUL)                  /*!< RDR (Bitfield-Mask: 0xff)                             */


/* =========================================================================================================================== */
/* ================                                           ACMP                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CR  =========================================================== */
#define ACMP_CR_OCP_SEL_Pos               (16UL)                    /*!< OCP_SEL (Bit 16)                                      */
#define ACMP_CR_OCP_SEL_Msk               (0x70000UL)               /*!< OCP_SEL (Bitfield-Mask: 0x07)                         */
#define ACMP_CR_BEMFR_SEL2_Pos            (12UL)                    /*!< BEMFR_SEL2 (Bit 12)                                   */
#define ACMP_CR_BEMFR_SEL2_Msk            (0x3000UL)                /*!< BEMFR_SEL2 (Bitfield-Mask: 0x03)                      */
#define ACMP_CR_BEMFR_SEL1_Pos            (10UL)                    /*!< BEMFR_SEL1 (Bit 10)                                   */
#define ACMP_CR_BEMFR_SEL1_Msk            (0xc00UL)                 /*!< BEMFR_SEL1 (Bitfield-Mask: 0x03)                      */
#define ACMP_CR_BEMFR_SEL0_Pos            (8UL)                     /*!< BEMFR_SEL0 (Bit 8)                                    */
#define ACMP_CR_BEMFR_SEL0_Msk            (0x300UL)                 /*!< BEMFR_SEL0 (Bitfield-Mask: 0x03)                      */
#define ACMP_CR_VREF_SEL_Pos              (6UL)                     /*!< VREF_SEL (Bit 6)                                      */
#define ACMP_CR_VREF_SEL_Msk              (0x40UL)                  /*!< VREF_SEL (Bitfield-Mask: 0x01)                        */
#define ACMP_CR_BEMFR_EN_Pos              (5UL)                     /*!< BEMFR_EN (Bit 5)                                      */
#define ACMP_CR_BEMFR_EN_Msk              (0x20UL)                  /*!< BEMFR_EN (Bitfield-Mask: 0x01)                        */
#define ACMP_CR_RES_SEL_Pos               (0UL)                     /*!< RES_SEL (Bit 0)                                       */
#define ACMP_CR_RES_SEL_Msk               (0x1fUL)                  /*!< RES_SEL (Bitfield-Mask: 0x1f)                         */
/* ==========================================================  SR  =========================================================== */
#define ACMP_SR_ACMP1_RDY_Pos             (17UL)                    /*!< ACMP1_RDY (Bit 17)                                    */
#define ACMP_SR_ACMP1_RDY_Msk             (0x20000UL)               /*!< ACMP1_RDY (Bitfield-Mask: 0x01)                       */
#define ACMP_SR_ACMP0_RDY_Pos             (16UL)                    /*!< ACMP0_RDY (Bit 16)                                    */
#define ACMP_SR_ACMP0_RDY_Msk             (0x10000UL)               /*!< ACMP0_RDY (Bitfield-Mask: 0x01)                       */
#define ACMP_SR_ACMP1_RES_Pos             (9UL)                     /*!< ACMP1_RES (Bit 9)                                     */
#define ACMP_SR_ACMP1_RES_Msk             (0x200UL)                 /*!< ACMP1_RES (Bitfield-Mask: 0x01)                       */
#define ACMP_SR_ACMP0_RES_Pos             (8UL)                     /*!< ACMP0_RES (Bit 8)                                     */
#define ACMP_SR_ACMP0_RES_Msk             (0x100UL)                 /*!< ACMP0_RES (Bitfield-Mask: 0x01)                       */
#define ACMP_SR_ACMP1_IF_Pos              (1UL)                     /*!< ACMP1_IF (Bit 1)                                      */
#define ACMP_SR_ACMP1_IF_Msk              (0x2UL)                   /*!< ACMP1_IF (Bitfield-Mask: 0x01)                        */
#define ACMP_SR_ACMP0_IF_Pos              (0UL)                     /*!< ACMP0_IF (Bit 0)                                      */
#define ACMP_SR_ACMP0_IF_Msk              (0x1UL)                   /*!< ACMP0_IF (Bitfield-Mask: 0x01)                        */
/* =======================================================  ACMP0_CFG  ======================================================= */
#define ACMP_ACMP0_CFG_IN_N_SEL_Pos       (20UL)                    /*!< IN_N_SEL (Bit 20)                                     */
#define ACMP_ACMP0_CFG_IN_N_SEL_Msk       (0x700000UL)              /*!< IN_N_SEL (Bitfield-Mask: 0x07)                        */
#define ACMP_ACMP0_CFG_IN_P_SEL_Pos       (16UL)                    /*!< IN_P_SEL (Bit 16)                                     */
#define ACMP_ACMP0_CFG_IN_P_SEL_Msk       (0x70000UL)               /*!< IN_P_SEL (Bitfield-Mask: 0x07)                        */
#define ACMP_ACMP0_CFG_RES_HOLD_Pos       (13UL)                    /*!< RES_HOLD (Bit 13)                                     */
#define ACMP_ACMP0_CFG_RES_HOLD_Msk       (0x2000UL)                /*!< RES_HOLD (Bitfield-Mask: 0x01)                        */
#define ACMP_ACMP0_CFG_FLT_EN_Pos         (12UL)                    /*!< FLT_EN (Bit 12)                                       */
#define ACMP_ACMP0_CFG_FLT_EN_Msk         (0x1000UL)                /*!< FLT_EN (Bitfield-Mask: 0x01)                          */
#define ACMP_ACMP0_CFG_FLT_LEN_Pos        (10UL)                    /*!< FLT_LEN (Bit 10)                                      */
#define ACMP_ACMP0_CFG_FLT_LEN_Msk        (0xc00UL)                 /*!< FLT_LEN (Bitfield-Mask: 0x03)                         */
#define ACMP_ACMP0_CFG_FLT_SAMPLE_Pos     (8UL)                     /*!< FLT_SAMPLE (Bit 8)                                    */
#define ACMP_ACMP0_CFG_FLT_SAMPLE_Msk     (0x300UL)                 /*!< FLT_SAMPLE (Bitfield-Mask: 0x03)                      */
#define ACMP_ACMP0_CFG_HYS_EN_Pos         (6UL)                     /*!< HYS_EN (Bit 6)                                        */
#define ACMP_ACMP0_CFG_HYS_EN_Msk         (0x40UL)                  /*!< HYS_EN (Bitfield-Mask: 0x01)                          */
#define ACMP_ACMP0_CFG_INT_TYPE_Pos       (4UL)                     /*!< INT_TYPE (Bit 4)                                      */
#define ACMP_ACMP0_CFG_INT_TYPE_Msk       (0x30UL)                  /*!< INT_TYPE (Bitfield-Mask: 0x03)                        */
#define ACMP_ACMP0_CFG_IE_Pos             (3UL)                     /*!< IE (Bit 3)                                            */
#define ACMP_ACMP0_CFG_IE_Msk             (0x8UL)                   /*!< IE (Bitfield-Mask: 0x01)                              */
#define ACMP_ACMP0_CFG_POL_Pos            (1UL)                     /*!< POL (Bit 1)                                           */
#define ACMP_ACMP0_CFG_POL_Msk            (0x2UL)                   /*!< POL (Bitfield-Mask: 0x01)                             */
#define ACMP_ACMP0_CFG_EN_Pos             (0UL)                     /*!< EN (Bit 0)                                            */
#define ACMP_ACMP0_CFG_EN_Msk             (0x1UL)                   /*!< EN (Bitfield-Mask: 0x01)                              */
/* =======================================================  ACMP1_CFG  ======================================================= */
#define ACMP_ACMP1_CFG_IN_N_SEL_Pos       (20UL)                    /*!< IN_N_SEL (Bit 20)                                     */
#define ACMP_ACMP1_CFG_IN_N_SEL_Msk       (0x700000UL)              /*!< IN_N_SEL (Bitfield-Mask: 0x07)                        */
#define ACMP_ACMP1_CFG_IN_P_SEL_Pos       (16UL)                    /*!< IN_P_SEL (Bit 16)                                     */
#define ACMP_ACMP1_CFG_IN_P_SEL_Msk       (0x70000UL)               /*!< IN_P_SEL (Bitfield-Mask: 0x07)                        */
#define ACMP_ACMP1_CFG_RES_HOLD_Pos       (13UL)                    /*!< RES_HOLD (Bit 13)                                     */
#define ACMP_ACMP1_CFG_RES_HOLD_Msk       (0x2000UL)                /*!< RES_HOLD (Bitfield-Mask: 0x01)                        */
#define ACMP_ACMP1_CFG_FLT_EN_Pos         (12UL)                    /*!< FLT_EN (Bit 12)                                       */
#define ACMP_ACMP1_CFG_FLT_EN_Msk         (0x1000UL)                /*!< FLT_EN (Bitfield-Mask: 0x01)                          */
#define ACMP_ACMP1_CFG_FLT_LEN_Pos        (10UL)                    /*!< FLT_LEN (Bit 10)                                      */
#define ACMP_ACMP1_CFG_FLT_LEN_Msk        (0xc00UL)                 /*!< FLT_LEN (Bitfield-Mask: 0x03)                         */
#define ACMP_ACMP1_CFG_FLT_SAMPLE_Pos     (8UL)                     /*!< FLT_SAMPLE (Bit 8)                                    */
#define ACMP_ACMP1_CFG_FLT_SAMPLE_Msk     (0x300UL)                 /*!< FLT_SAMPLE (Bitfield-Mask: 0x03)                      */
#define ACMP_ACMP1_CFG_HYS_EN_Pos         (6UL)                     /*!< HYS_EN (Bit 6)                                        */
#define ACMP_ACMP1_CFG_HYS_EN_Msk         (0x40UL)                  /*!< HYS_EN (Bitfield-Mask: 0x01)                          */
#define ACMP_ACMP1_CFG_INT_TYPE_Pos       (4UL)                     /*!< INT_TYPE (Bit 4)                                      */
#define ACMP_ACMP1_CFG_INT_TYPE_Msk       (0x30UL)                  /*!< INT_TYPE (Bitfield-Mask: 0x03)                        */
#define ACMP_ACMP1_CFG_IE_Pos             (3UL)                     /*!< IE (Bit 3)                                            */
#define ACMP_ACMP1_CFG_IE_Msk             (0x8UL)                   /*!< IE (Bitfield-Mask: 0x01)                              */
#define ACMP_ACMP1_CFG_POL_Pos            (1UL)                     /*!< POL (Bit 1)                                           */
#define ACMP_ACMP1_CFG_POL_Msk            (0x2UL)                   /*!< POL (Bitfield-Mask: 0x01)                             */
#define ACMP_ACMP1_CFG_EN_Pos             (0UL)                     /*!< EN (Bit 0)                                            */
#define ACMP_ACMP1_CFG_EN_Msk             (0x1UL)                   /*!< EN (Bitfield-Mask: 0x01)                              */


/* =========================================================================================================================== */
/* ================                                           FLASH                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  CR  =========================================================== */
#define FLASH_CR_KEY_Pos                  (16UL)                    /*!< KEY (Bit 16)                                          */
#define FLASH_CR_KEY_Msk                  (0xffff0000UL)            /*!< KEY (Bitfield-Mask: 0xffff)                           */
#define FLASH_CR_PF_EN_Pos                (6UL)                     /*!< PF_EN (Bit 6)                                         */
#define FLASH_CR_PF_EN_Msk                (0x40UL)                  /*!< PF_EN (Bitfield-Mask: 0x01)                           */
#define FLASH_CR_WS_Pos                   (4UL)                     /*!< WS (Bit 4)                                            */
#define FLASH_CR_WS_Msk                   (0x30UL)                  /*!< WS (Bitfield-Mask: 0x03)                              */
#define FLASH_CR_OP_MODE_Pos              (1UL)                     /*!< OP_MODE (Bit 1)                                       */
#define FLASH_CR_OP_MODE_Msk              (0xeUL)                   /*!< OP_MODE (Bitfield-Mask: 0x07)                         */
#define FLASH_CR_OP_START_Pos             (0UL)                     /*!< OP_START (Bit 0)                                      */
#define FLASH_CR_OP_START_Msk             (0x1UL)                   /*!< OP_START (Bitfield-Mask: 0x01)                        */
/* =========================================================  ADDR  ========================================================== */
#define FLASH_ADDR_ADDR_Pos               (0UL)                     /*!< ADDR (Bit 0)                                          */
#define FLASH_ADDR_ADDR_Msk               (0xffffffffUL)            /*!< ADDR (Bitfield-Mask: 0xffffffff)                      */
/* =========================================================  DATA  ========================================================== */
#define FLASH_DATA_DATA_Pos               (0UL)                     /*!< DATA (Bit 0)                                          */
#define FLASH_DATA_DATA_Msk               (0xffffffffUL)            /*!< DATA (Bitfield-Mask: 0xffffffff)                      */
/* ========================================================  CR_LOCK  ======================================================== */
#define FLASH_CR_LOCK_KEY_Pos             (16UL)                    /*!< KEY (Bit 16)                                          */
#define FLASH_CR_LOCK_KEY_Msk             (0xffff0000UL)            /*!< KEY (Bitfield-Mask: 0xffff)                           */
#define FLASH_CR_LOCK_LK_Pos              (0UL)                     /*!< LK (Bit 0)                                            */
#define FLASH_CR_LOCK_LK_Msk              (0x1UL)                   /*!< LK (Bitfield-Mask: 0x01)                              */
/* ==========================================================  SR  =========================================================== */
#define FLASH_SR_ADDR_ERR_Pos             (6UL)                     /*!< ADDR_ERR (Bit 6)                                      */
#define FLASH_SR_ADDR_ERR_Msk             (0x40UL)                  /*!< ADDR_ERR (Bitfield-Mask: 0x01)                        */
#define FLASH_SR_OP_WP_ERR_Pos            (5UL)                     /*!< OP_WP_ERR (Bit 5)                                     */
#define FLASH_SR_OP_WP_ERR_Msk            (0x20UL)                  /*!< OP_WP_ERR (Bitfield-Mask: 0x01)                       */
#define FLASH_SR_MN_WP_ERR_Pos            (4UL)                     /*!< MN_WP_ERR (Bit 4)                                     */
#define FLASH_SR_MN_WP_ERR_Msk            (0x10UL)                  /*!< MN_WP_ERR (Bitfield-Mask: 0x01)                       */
#define FLASH_SR_CPE_WP_ERR_Pos           (3UL)                     /*!< CPE_WP_ERR (Bit 3)                                    */
#define FLASH_SR_CPE_WP_ERR_Msk           (0x8UL)                   /*!< CPE_WP_ERR (Bitfield-Mask: 0x01)                      */
#define FLASH_SR_CR_LK_ERR_Pos            (2UL)                     /*!< CR_LK_ERR (Bit 2)                                     */
#define FLASH_SR_CR_LK_ERR_Msk            (0x4UL)                   /*!< CR_LK_ERR (Bitfield-Mask: 0x01)                       */
#define FLASH_SR_CR_BSY_ERR_Pos           (1UL)                     /*!< CR_BSY_ERR (Bit 1)                                    */
#define FLASH_SR_CR_BSY_ERR_Msk           (0x2UL)                   /*!< CR_BSY_ERR (Bitfield-Mask: 0x01)                      */
#define FLASH_SR_BUSY_Pos                 (0UL)                     /*!< BUSY (Bit 0)                                          */
#define FLASH_SR_BUSY_Msk                 (0x1UL)                   /*!< BUSY (Bitfield-Mask: 0x01)                            */
/* ========================================================  FAC_REC  ======================================================== */
#define FLASH_FAC_REC_KEY_Pos             (16UL)                    /*!< KEY (Bit 16)                                          */
#define FLASH_FAC_REC_KEY_Msk             (0xffff0000UL)            /*!< KEY (Bitfield-Mask: 0xffff)                           */
#define FLASH_FAC_REC_UNLK_DATA_Pos       (0UL)                     /*!< UNLK_DATA (Bit 0)                                     */
#define FLASH_FAC_REC_UNLK_DATA_Msk       (0xffffUL)                /*!< UNLK_DATA (Bitfield-Mask: 0xffff)                     */


/* =========================================================================================================================== */
/* ================                                            PVD                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CR  =========================================================== */
#define PVD_CR_IE_Pos                     (13UL)                    /*!< IE (Bit 13)                                           */
#define PVD_CR_IE_Msk                     (0x2000UL)                /*!< IE (Bitfield-Mask: 0x01)                              */
#define PVD_CR_FLT_EN_Pos                 (12UL)                    /*!< FLT_EN (Bit 12)                                       */
#define PVD_CR_FLT_EN_Msk                 (0x1000UL)                /*!< FLT_EN (Bitfield-Mask: 0x01)                          */
#define PVD_CR_FLT_LEN_Pos                (10UL)                    /*!< FLT_LEN (Bit 10)                                      */
#define PVD_CR_FLT_LEN_Msk                (0xc00UL)                 /*!< FLT_LEN (Bitfield-Mask: 0x03)                         */
#define PVD_CR_FLT_SAMPLE_Pos             (8UL)                     /*!< FLT_SAMPLE (Bit 8)                                    */
#define PVD_CR_FLT_SAMPLE_Msk             (0x300UL)                 /*!< FLT_SAMPLE (Bitfield-Mask: 0x03)                      */
#define PVD_CR_REF_SEL_Pos                (4UL)                     /*!< REF_SEL (Bit 4)                                       */
#define PVD_CR_REF_SEL_Msk                (0xf0UL)                  /*!< REF_SEL (Bitfield-Mask: 0x0f)                         */
#define PVD_CR_TRIG_RESULT_Pos            (3UL)                     /*!< TRIG_RESULT (Bit 3)                                   */
#define PVD_CR_TRIG_RESULT_Msk            (0x8UL)                   /*!< TRIG_RESULT (Bitfield-Mask: 0x01)                     */
#define PVD_CR_TRIG_TYPE_Pos              (1UL)                     /*!< TRIG_TYPE (Bit 1)                                     */
#define PVD_CR_TRIG_TYPE_Msk              (0x6UL)                   /*!< TRIG_TYPE (Bitfield-Mask: 0x03)                       */
#define PVD_CR_EN_Pos                     (0UL)                     /*!< EN (Bit 0)                                            */
#define PVD_CR_EN_Msk                     (0x1UL)                   /*!< EN (Bitfield-Mask: 0x01)                              */
/* ==========================================================  SR  =========================================================== */
#define PVD_SR_RDY_Pos                    (2UL)                     /*!< RDY (Bit 2)                                           */
#define PVD_SR_RDY_Msk                    (0x4UL)                   /*!< RDY (Bitfield-Mask: 0x01)                             */
#define PVD_SR_RES_Pos                    (1UL)                     /*!< RES (Bit 1)                                           */
#define PVD_SR_RES_Msk                    (0x2UL)                   /*!< RES (Bitfield-Mask: 0x01)                             */
#define PVD_SR_IF_Pos                     (0UL)                     /*!< IF (Bit 0)                                            */
#define PVD_SR_IF_Msk                     (0x1UL)                   /*!< IF (Bitfield-Mask: 0x01)                              */

/** @} */ /* End of group PosMask_peripherals */


/* define marco USE_STDPERIPH_DRIVER */
#if !defined  USE_STDPERIPH_DRIVER
#define USE_STDPERIPH_DRIVER
#endif 
#ifdef USE_STDPERIPH_DRIVER
#include "dpm32m0xx_libopt.h"
#endif /* USE_STDPERIPH_DRIVER */



#ifdef __cplusplus
}
#endif

#endif /* DPM32M030_H */


/** @} */ /* End of group dpm32m030 */

/** @} */ /* End of group DP Ltd. */
