/**
 *******************************************************************************
 * @file    tim_cuontinterrupt.c
 *
 * @brief   Implement system specific functions.
 *
 * @author  DP
 *
 * @version V1.0.0
 *
 * @date    2024-12-01
 *
 *******************************************************************************/

/*
    Copyright (c) 2024, DP Microelectronics Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

/* Files include */
#include "tim_cuontinterrupt.h"

/**
  * @addtogroup DPM32M030_LibSamples
  * @{
  */

/**
  * @addtogroup TIM
  * @{
  */

/**
  * @addtogroup TIM CuontInterrupt
  * @{
  */

/* Private typedef --------------------------------------------------------------*/
TIM_InitTypeStruct TIM_InitStruct;

/* Private define ---------------------------------------------------------------*/

/* Private macro ----------------------------------------------------------------*/

/* Private variables ------------------------------------------------------------*/

/* Private functions ------------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief   TIM0 IRQHandler Init.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void TIM0_IRQ_Handler(void)
{
  if(TIM_GetIntFlagStatus(TIM0) != RESET)
  {
    TIM_ClearIntFlag(TIM0);
    GPIO_ToggleBit(GPIOA, GPIO_PIN_1);
  }
}
/**
 *******************************************************************************
 * @brief   TIM GPIO Init.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void TIM_GPIOInit(void)
{
  /* Enable clock */
  RCC_Unlock();
  RCC_AHBPeriphClockCmd(RCC_AHB_PERIPH_GPIO, ENABLE);
  RCC_Lock();
  
  GPIO_InitTypeStruct TIM_GPIO_InitStruct;
  GPIO_StructInit(&TIM_GPIO_InitStruct);
  TIM_GPIO_InitStruct.GPIO_Mode = GPIO_MODE_OUTPUT;
  TIM_GPIO_InitStruct.GPIO_Speed = GPIO_SPEED_HIGH;
  TIM_GPIO_InitStruct.GPIO_OType = GPIO_OTYPE_PP;
  TIM_GPIO_InitStruct.GPIO_PuPd = GPIO_PUPD_NOPULL;

  TIM_GPIO_InitStruct.GPIO_Pin = GPIO_PIN_1;
  GPIO_Init(GPIOA, &TIM_GPIO_InitStruct);
  GPIO_ResetBit(GPIOA, GPIO_PIN_1);
}

/**
 *******************************************************************************
 * @brief   CuontInterrupt Sample.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void TIM_CuontInterrupt_Sample(void)
{
  /* GPIO Init */
  TIM_GPIOInit();

  /* Enable clock */
  RCC_Unlock();
  RCC_APBPeriphClockCmd(RCC_APB_PERIPH_TIM0, ENABLE);
  RCC_Lock();
  
  /* Config TIM0 */
  TIM_StructInit(&TIM_InitStruct);
  TIM_InitStruct.TIM_ReloadValue = 48000*100;
  TIM_InitStruct.TIM_CounterCycle = TIM_COUNTER_CYCLE_PERIOD;
  TIM_InitStruct.TIM_IntState = ENABLE;
  TIM_Init(TIM0, &TIM_InitStruct);
  
  /* Enable TIM0 */
  TIM_Cmd(TIM0, ENABLE);
  
  /* Enable ITM interrupt */
  NVIC_SetPriority(TIM0_IRQn, 2);
  NVIC_EnableIRQ(TIM0_IRQn);
  TIM_IntCmd(TIM0, ENABLE);
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT DP *****END OF FILE ***************************/
