;******************************************************************************
;* File Name          : startup_dpm32f0xx.s
;* Author             : DP Application Team
;* Description        : dpm32m0xx Devices vector table for MDK-ARM toolchain.
;*                      This module performs:
;*                      - Set the initial SP
;*                      - Set the initial PC == Reset_Handler
;*                      - Set the vector table entries with the exceptions ISR address
;*                      - Branches to __main in the C library (which eventually
;*                        calls main()).
;*                      After Reset the Cortex-M0 processor is in Thread mode,
;*                      priority is Privileged, and the Stack is set to Main.
;******************************************************************************
;* @attention
;*
;* Copyright (c) 2023 DP.
;* All rights reserved.
;*
;******************************************************************************

; Amount of memory (in bytes) allocated for Stack
; Tailor this value to your application needs
; <h> Stack Configuration
;   <o> Stack Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Stack_Size      EQU     0x00000200

                AREA    STACK, NOINIT, READWRITE, ALIGN=3
Stack_Mem       SPACE   Stack_Size
__initial_sp


; <h> Heap Configuration
;   <o>  Heap Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Heap_Size       EQU     0x00000200

                AREA    HEAP, NOINIT, READWRITE, ALIGN=3
__heap_base
Heap_Mem        SPACE   Heap_Size
__heap_limit

                PRESERVE8
                THUMB


; Vector Table Mapped to Address 0 at Reset
                AREA    RESET, DATA, READONLY
                EXPORT  __Vectors
                EXPORT  __Vectors_End
                EXPORT  __Vectors_Size

__Vectors       DCD     __initial_sp                   ; Top of Stack
                DCD     Reset_Handler                  ; Reset Handler
                DCD     NMI_Handler                    ; NMI Handler
                DCD     HardFault_Handler              ; Hard Fault Handler
                DCD     0                              ; Reserved
                DCD     0                              ; Reserved
                DCD     0                              ; Reserved
                DCD     0                              ; Reserved
                DCD     0                              ; Reserved
                DCD     0                              ; Reserved
                DCD     0                              ; Reserved
                DCD     SVC_Handler                    ; SVCall Handler
                DCD     0                              ; Reserved
                DCD     0                              ; Reserved
                DCD     PendSV_Handler                 ; PendSV Handler
                DCD     SysTick_Handler                ; SysTick Handler

                ; External Interrupts
                DCD     WDG_IRQHandler                 ; Window Watchdog
                DCD     PVD_IRQHandler                 ; PVD through EXTI Line detect
                DCD     TIM0_IRQHandler                ; TIM0
                DCD     TIM1_IRQHandler                ; TIM1
		DCD     0                              ; Reserved
                DCD     0                              ; Reserved
                DCD     CCT0_IRQHandler                ; CCT0
                DCD     0                              ; Reserved
                DCD     EPWM_IRQHandler                ; EPWM
                DCD     0                              ; Reserved
                DCD     0                              ; Reserved
                DCD     0                              ; Reserved
                DCD     UART0_IRQHandler               ; UART0
                DCD     UART1_IRQHandler               ; UART1
                DCD     0                              ; Reserved
                DCD     SPI0_IRQHandler                ; SPI0
                DCD     0                              ; Reserved
                DCD     I2C_IRQHandler                 ; I2C
                DCD     0                              ; Reserved
                DCD     0                              ; Reserved
                DCD     LPTIM_IRQHandler               ; Low power timer
                DCD     ADC0_IRQHandler                ; ADC0
                DCD     0                              ; Reserved
                DCD     GPIOA_IRQHandler               ; GPIOA
                DCD     GPIOB_IRQHandler               ; GPIOB
                DCD     GPIOD_IRQHandler               ; GPIOD
                DCD     0                              ; Reserved
		DCD     0                              ; Reserved
                DCD     ACMP_IRQHandler                ; ACMP0 1
                DCD     0                              ; Reserved
                DCD     0                              ; Reserved
                DCD     0                              ; Reserved
                
__Vectors_End

__Vectors_Size  EQU  __Vectors_End - __Vectors

                AREA    |.text|, CODE, READONLY

; Reset handler routine
Reset_Handler    PROC
                 EXPORT  Reset_Handler                 [WEAK]
        IMPORT  __main
        IMPORT  SystemInit  
                 LDR     R0, =SystemInit
                 BLX     R0
                 LDR     R0, =__main
                 BX      R0
                 ENDP

; Dummy Exception Handlers (infinite loops which can be modified)

NMI_Handler     PROC
                EXPORT  NMI_Handler                    [WEAK]
                B       .
                ENDP
HardFault_Handler\
                PROC
                EXPORT  HardFault_Handler              [WEAK]
                B       .
                ENDP
SVC_Handler     PROC
                EXPORT  SVC_Handler                    [WEAK]
                B       .
                ENDP
PendSV_Handler  PROC
                EXPORT  PendSV_Handler                 [WEAK]
                B       .
                ENDP
SysTick_Handler PROC
                EXPORT  SysTick_Handler                [WEAK]
                B       .
                ENDP

Default_Handler PROC

                EXPORT  WDG_IRQHandler                 [WEAK]
                EXPORT  PVD_IRQHandler                 [WEAK]
                EXPORT  TIM0_IRQHandler                [WEAK]
                EXPORT  TIM1_IRQHandler                [WEAK]
                EXPORT  CCT0_IRQHandler                [WEAK]
                EXPORT  EPWM_IRQHandler                [WEAK]
                EXPORT  UART0_IRQHandler               [WEAK]
                EXPORT  UART1_IRQHandler               [WEAK]
                EXPORT  SPI0_IRQHandler                [WEAK]
                EXPORT  I2C_IRQHandler                 [WEAK]
                EXPORT  LPTIM_IRQHandler               [WEAK]
                EXPORT  ADC0_IRQHandler                [WEAK]
                EXPORT  GPIOA_IRQHandler               [WEAK]
                EXPORT  GPIOB_IRQHandler               [WEAK]
                EXPORT  GPIOD_IRQHandler               [WEAK]
                EXPORT  ACMP_IRQHandler                [WEAK]


WDG_IRQHandler
PVD_IRQHandler
TIM0_IRQHandler
TIM1_IRQHandler
CCT0_IRQHandler
EPWM_IRQHandler
UART0_IRQHandler
UART1_IRQHandler
SPI0_IRQHandler
I2C_IRQHandler
LPTIM_IRQHandler
ADC0_IRQHandler
GPIOA_IRQHandler
GPIOB_IRQHandler
GPIOD_IRQHandler
ACMP_IRQHandler

                B       .

                ENDP

                ALIGN

;*******************************************************************************
; User Stack and Heap initialization
;*******************************************************************************
                 IF      :DEF:__MICROLIB
                
                 EXPORT  __initial_sp
                 EXPORT  __heap_base
                 EXPORT  __heap_limit
                
                 ELSE
                
                 IMPORT  __use_two_region_memory
                 EXPORT  __user_initial_stackheap
                 
__user_initial_stackheap

                 LDR     R0, =  Heap_Mem
                 LDR     R1, =(Stack_Mem + Stack_Size)
                 LDR     R2, = (Heap_Mem +  Heap_Size)
                 LDR     R3, = Stack_Mem
                 BX      LR

                 ALIGN

                 ENDIF

                 END

;************************ (C) COPYRIGHT DPMicroelectronics *****END OF FILE*****
