/**
 *******************************************************************************
 * @file    flash_readwaitandprefetch.c
 *
 * @brief   Implement system specific functions.
 *
 * @author  DP
 *
 * @version V1.0.1
 *
 * @date    2024-11-11
 *
 *******************************************************************************/

/*
    Copyright (c) 2024, DP Microelectronics Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

/* Files include */
#include "flash_useroption.h"

/**
  * @addtogroup DPM32M036_LibSamples
  * @{
  */

/**
  * @addtogroup FLash
  * @{
  */

/**
  * @addtogroup Flash UserOption
  * @{
  */

/* Private typedef --------------------------------------------------------------*/

/* Private define ---------------------------------------------------------------*/

/* Private macro ----------------------------------------------------------------*/

/* Private variables ------------------------------------------------------------*/
uint32_t WritePro[8] = {0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x80000000};
uint32_t UserData[8] = {0x5555AAAA, 0x12345678, 0x00000000, 0xFFFFFFFF, 0x11111111, 0x22222222, 0x33333333, 0x44444444};

/* Private functions ------------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief   Flash UserOption_Sample Sample.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void Flash_UserOption_Sample(void)
{
  /* Unlock flash */
  FLASH_Unlock();

  /* Clear pending flags (if any) */
  FLASH_ClearFlag(FLASH_FLAG_ERROR_CR_BSY);
  FLASH_ClearFlag(FLASH_FLAG_ERROR_CR_LK);
  FLASH_ClearFlag(FLASH_FLAG_ERROR_CPE_WP);
  FLASH_ClearFlag(FLASH_FLAG_ERROR_MN_WP);
  FLASH_ClearFlag(FLASH_FLAG_ERROR_OP_WP);
  FLASH_ClearFlag(FLASH_FLAG_ERROR_ADDR);

  /* Disable debug functions. */
  if(FLASH_OB0_FunctionConfig(FLASH_OB0_FUNCTION_DISDEBUG, DISABLE) != FLASH_OK)
  {
    /* Error occurred while disable debug functions.
       User can add here some code to deal with this error  */
    while(1)
    {
      DelayMs(100);
    }
  }

  /* Read project functions. */
  if(FLASH_OB0_FunctionConfig(FLASH_OB0_FUNCTION_READPRO, DISABLE) != FLASH_OK)
  {
    /* Error occurred while disable debug functions.
       User can add here some code to deal with this error  */
    while(1)
    {
      DelayMs(100);
    }
  }

  /* ENABLE ISP functions. */
  if(FLASH_OB0_FunctionConfig(FLASH_OB0_FUNCTION_DISISP, DISABLE) != FLASH_OK)
  {
    /* Error occurred while disable ISP functions.
       User can add here some code to deal with this error  */
    while(1)
    {
      DelayMs(100);
    }
  }

  /* ENABLE recover functions. */
  if(FLASH_OB0_FunctionConfig(FLASH_OB0_FUNCTION_DISRECOVE, DISABLE) != FLASH_OK)
  {
    /* Error occurred while disable recover functions.
       User can add here some code to deal with this error  */
    while(1)
    {
      DelayMs(100);
    }
  }

  /* Open flash read protect functions. */
  if(FLASH_OB0_FunctionConfig(FLASH_OB0_FUNCTION_OB0WP, DISABLE) != FLASH_OK)
  {
    /* Error occurred while open flash read protect functions.
       User can add here some code to deal with this error  */
    while(1)
    {
      DelayMs(100);
    }
  }

  /* BOOTLOADER_ENTRY_ADDR. */
  FLASH_ProgramWord(BOOTLOADER_ENTRY_ADDR, 0x18000000);
  
  /* DISABLE page write protect functions. */
  if(FLASH_OB0_WriteProBufConfig(WritePro, 8) != FLASH_OK)
  {
    /* Error occurred while enable page write protect functions.
       User can add here some code to deal with this error  */
    while(1)
    {
      DelayMs(100);
    }
  }

  /* Enable page 255 write protect functions. */
  if(FLASH_OB0_WriteProConfig(255, DISABLE) != FLASH_OK)
  {
    /* Error occurred while enable page 255 write protect functions.
       User can add here some code to deal with this error  */
    while(1)
    {
      DelayMs(100);
    }
  }

  /* Enable user option page0 configurations.
     Power on the system again, the new configuration will take effect. */
  if(FLASH_OB0_Cmd(ENABLE) != FLASH_OK)
  {
    /* Error occurred while enable user option page0 configurations.
       User can add here some code to deal with this error  */
    while(1)
    {
      DelayMs(100);
    }
  }
  if(FLASH_OB1_Erase() != FLASH_OK)
  {
    /* Error occurred while enable user option page0 configurations.
       User can add here some code to deal with this error  */
    while(1)
    {
      DelayMs(100);
    }
  }
  
  uint32_t OP1WriteAddr = FLASH_OB1_USR_DATA_START_ADDR;
  for(uint8_t i = 0; i < 8; i++)
  {
    if(FLASH_OB1_ProgramUserData(OP1WriteAddr, UserData[i]) != FLASH_OK)
    {
      /* Error occurred while enable user option page0 configurations.
         User can add here some code to deal with this error  */
      while(1)
      {
        DelayMs(100);
      }
    }
    OP1WriteAddr += 4;
  }

  /* Lock flash */
  FLASH_Lock();

}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT DP *****END OF FILE ***************************/
