/**
 *******************************************************************************
 * @file    dpm32m015_libopy.h
 *
 * @brief   This file contains all firmware library prototypes that DPM32M030 has.
 *
 * @author  DP
 *
 * @version V1.0.1
 *
 * @date    2024-11-11
 *******************************************************************************/

/*
    Copyright (c) 2024, DP Microelectronics Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

/* Define to prevent recursive inclusion -----------------------------------------------------------------------------*/
#ifndef DPM32M015_LIBOPT_H
#define DPM32M015_LIBOPT_H

/* Files includes ----------------------------------------------------------------------------------------------------*/
#include "dpm32m0xx_adc.h"
#include "dpm32m0xx_acmp.h"
#include "dpm32m0xx_cct.h"
#include "dpm32m0xx_crc.h"
#include "dpm32m0xx_dbg.h"
#include "dpm32m0xx_epwm.h"
#include "dpm32m0xx_flash.h"
#include "dpm32m0xx_gpio.h"
#include "dpm32m0xx_i2c.h"
#include "dpm32m0xx_lptim.h"
#include "dpm32m0xx_pga.h"
#include "dpm32m0xx_pvd.h"
#include "dpm32m0xx_rcc.h"
#include "dpm32m0xx_spi.h"
#include "dpm32m0xx_tim.h"
#include "dpm32m0xx_uart.h"
#include "dpm32m0xx_wdg.h"
#include "dpm32m0xx_des.h"
#endif /* DPM32M015_LIBOPT_H */

/************************ (C) COPYRIGHT DP *****END OF FILE ***************************/

