/**
 *******************************************************************************
 * @file    acmp_interrupt.c
 *
 * @brief   Implement system specific functions.
 *
 * @author  DP
 *
 * @version V1.0.0
 *
 * @date    2024-12-01
 *
 *******************************************************************************/

/*
    Copyright (c) 2024, DP Microelectronics Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

/* Files include */
#include "acmp_interrupt.h"

/**
  * @addtogroup DPM32M015_LibSamples
  * @{
  */

/**
  * @addtogroup ACMP
  * @{
  */

/**
  * @addtogroup ACMP INTERRUPT
  * @{
  */

/* Private typedef --------------------------------------------------------------*/

/* Private define ---------------------------------------------------------------*/

/* Private macro ----------------------------------------------------------------*/

/* Private variables ------------------------------------------------------------*/

/* Private functions ------------------------------------------------------------*/
/**
 *******************************************************************************
 * @brief   ACMP IRQ Handler.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void ACMP_IRQ_Handler(void)
{
  if(ACMP_GetIntFlagStatus(ACMP_CH1) != RESET)
  {
    ACMP_ClearIntFlag(ACMP_CH1);
    GPIO_ToggleBit(GPIOA,GPIO_PIN_0);
  }
}
/**
 *******************************************************************************
 * @brief   ACMP Init.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void ACMP_InitConfig(void)
{
  /* Enable clock */
  RCC_Unlock();
  RCC_APBPeriphClockCmd(RCC_APB_PERIPH_ACMP, ENABLE);
  RCC_Lock();
  
  /* Configure ACMP negative Vref dvi*/
  ACMP_ResSelect(ACMP_RES_SEL1);
  ACMP_VrefSelect(ACMP_VREF_VDD);
  
  /* Configure ACMP_InitStruct */
  ACMP_InitTypeStruct ACMP_InitStruct;
  ACMP_StructInit(&ACMP_InitStruct);
  ACMP_InitStruct.ACMP_Polarity = ACMP_POL_NORMAL;
  ACMP_InitStruct.ACMP_Filter.FilterSample = ACMP_FILTER_SAMPLE_DIV16;
  ACMP_InitStruct.ACMP_Filter.FilterLen = ACMP_FILTER_LEN16;
  ACMP_InitStruct.ACMP_Filter.FilterCmd = DISABLE;
  ACMP_InitStruct.ACMP_HYSCmd = DISABLE;
  ACMP_InitStruct.ACMP_HoldCmd = DISABLE;
  /* Configure the positive and the negative to connect to GPIO */
  ACMP_InitStruct.ACMP_PInput = ACMP_IN_P_SEL_ACMP_IN0;
  ACMP_InitStruct.ACMP_PInput = ACMP_IN_P_SEL_ACMP_IN1;
  /* Init ACMP1 */
  ACMP_Init(ACMP_CH1, &ACMP_InitStruct);
}

/**
 *******************************************************************************
 * @brief   ACMP GPIO Init.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void ACMP_GPIOInit(void)
{
  /* Enable clock */
  RCC_Unlock();
  RCC_AHBPeriphClockCmd(RCC_AHB_PERIPH_GPIO, ENABLE);
  RCC_Lock();
  /* Configure ACMP_IN0_IN1 Input GPIO */
  GPIO_InitTypeStruct GPIO_InitStruct;
  GPIO_StructInit(&GPIO_InitStruct);
  GPIO_InitStruct.GPIO_Mode = GPIO_MODE_ANALOG;
  GPIO_InitStruct.GPIO_PuPd = GPIO_PUPD_NOPULL;
  GPIO_InitStruct.GPIO_Pin = GPIO_PIN_4 | GPIO_PIN_5 ;
  GPIO_Init(GPIOA, &GPIO_InitStruct);
  GPIO_AnaAFConfig(GPIOA, GPIO_PIN_4, GPIO_ANA_AF_1);
  GPIO_AnaAFConfig(GPIOA, GPIO_PIN_5, GPIO_ANA_AF_1);

  /* Toggle IO */
  GPIO_InitStruct.GPIO_Mode = GPIO_MODE_OUTPUT;
  GPIO_InitStruct.GPIO_Pin = GPIO_PIN_0;
  GPIO_Init(GPIOA, &GPIO_InitStruct);
}

/**
 *******************************************************************************
 * @brief   ACMP Interrupt Sample.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void ACMP_Interrupt_Sample(void)
{
  /* Config ACMP GPIO */
  ACMP_GPIOInit();
  /* Init ACMP */
  ACMP_InitConfig();

  /* Enable ACMP1 */
  ACMP_Cmd(ACMP_CH1, ENABLE);
  /* Wait for Ready Status */
  while(ACMP_GetReadyStatus(ACMP_CH1) != SET);

  /* Config ACMP Interrupt*/
  ACMP_IntCmd(ACMP_CH1, ACMP_INT_TYPE_RISING_FALLING, ENABLE);
  NVIC_SetPriority(ACMP_IRQn, 2);
  NVIC_EnableIRQ(ACMP_IRQn);
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT DP *****END OF FILE ***************************/
