/**
 *******************************************************************************
 * @file    acmp_overcurrentprotection.c
 *
 * @brief   Implement system specific functions.
 *
 * @author  DP
 *
 * @version V1.0.0
 *
 * @date    2024-12-01
 *
 *******************************************************************************/

/*
    Copyright (c) 2024, DP Microelectronics Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

/* Files include */
#include "acmp_overcurrentprotection.h"

/**
  * @addtogroup DPM32M015_LibSamples
  * @{
  */

/**
  * @addtogroup ACMP
  * @{
  */

/**
  * @addtogroup ACMP OCP
  * @{
  */

/* Private typedef --------------------------------------------------------------*/

/* Private define ---------------------------------------------------------------*/

/* Private macro ----------------------------------------------------------------*/

/* Private variables ------------------------------------------------------------*/

/* Private functions ------------------------------------------------------------*/
/**
 *******************************************************************************
 * @brief   ACMP GPIO Init.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void ACMP_GPIOInit(void)
{
  /* Enable clock */
  RCC_Unlock();
  RCC_AHBPeriphClockCmd(RCC_AHB_PERIPH_GPIO, ENABLE);
  RCC_Lock();
  /* Configure ACMP_IN0 Input GPIO */
  GPIO_InitTypeStruct GPIO_InitStruct;
  GPIO_StructInit(&GPIO_InitStruct);
  GPIO_InitStruct.GPIO_Mode = GPIO_MODE_ANALOG;
  GPIO_InitStruct.GPIO_PuPd = GPIO_PUPD_NOPULL;
  GPIO_InitStruct.GPIO_Pin = GPIO_PIN_4  ;
  GPIO_Init(GPIOA, &GPIO_InitStruct);
  GPIO_AnaAFConfig(GPIOA, GPIO_PIN_4, GPIO_ANA_AF_1);  
  /* ACMP output result */
  GPIO_InitStruct.GPIO_Mode = GPIO_MODE_ALT_FUNC;
  GPIO_InitStruct.GPIO_OType = GPIO_OTYPE_PP;
  GPIO_InitStruct.GPIO_PuPd = GPIO_PUPD_NOPULL;
  GPIO_InitStruct.GPIO_Speed = GPIO_SPEED_MAX;
  GPIO_InitStruct.GPIO_Pin = GPIO_PIN_1  ;
  GPIO_Init(GPIOB, &GPIO_InitStruct);
  GPIO_AltFuncConfig(GPIOB, GPIO_PIN_1, GPIO_ALT_FUNC_3);
}
/**
 *******************************************************************************
 * @brief   PGA GPIO Init.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void PGA_GPIOInit(void)
{
  /* Enable clock */
  RCC_Unlock();
  RCC_AHBPeriphClockCmd(RCC_AHB_PERIPH_GPIO, ENABLE);
  RCC_Lock();
  
  GPIO_InitTypeStruct GPIO_InitType;
  GPIO_StructInit(&GPIO_InitType);
  GPIO_InitType.GPIO_Mode = GPIO_MODE_ANALOG;
  GPIO_InitType.GPIO_Pin = GPIO_PIN_0 | GPIO_PIN_1;
  GPIO_Init(GPIOA, &GPIO_InitType);
  GPIO_AnaAFConfig(GPIOA, GPIO_PIN_0, GPIO_ANA_AF_1);
  GPIO_AnaAFConfig(GPIOA, GPIO_PIN_1, GPIO_ANA_AF_1);
}
/**
 *******************************************************************************
 * @brief   ACMP Init.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void ACMP_ConfigInit(void)
{
  /* Enable clock */
  RCC_Unlock();
  RCC_APBPeriphClockCmd(RCC_APB_PERIPH_ACMP, ENABLE);
  RCC_Lock();
  
  /* Configure ACMP negative Vref dvi*/
  ACMP_ResSelect(ACMP_RES_SEL20);
  ACMP_VrefSelect(ACMP_VREF_VDD);
  
  /* Configure ACMP_InitStruct */
  ACMP_InitTypeStruct ACMP_InitStruct;
  ACMP_StructInit(&ACMP_InitStruct);
  ACMP_InitStruct.ACMP_Polarity = ACMP_POL_NORMAL;
  ACMP_InitStruct.ACMP_Filter.FilterSample = ACMP_FILTER_SAMPLE_DIV16;
  ACMP_InitStruct.ACMP_Filter.FilterLen = ACMP_FILTER_LEN16;
  ACMP_InitStruct.ACMP_Filter.FilterCmd = DISABLE;
  ACMP_InitStruct.ACMP_HYSCmd = DISABLE;
  ACMP_InitStruct.ACMP_HoldCmd = DISABLE;
  /* Configure the positive and negative to connect to GPIO */
  ACMP_InitStruct.ACMP_PInput = ACMP_IN_P_SEL_OCP;
  ACMP_InitStruct.ACMP_NInput = ACMP_IN_N_SEL_ACMP_IN0;
  /* Init ACMP1 */
  ACMP_Init(ACMP_CH1, &ACMP_InitStruct);
}
/**
 *******************************************************************************
 * @brief   PGA Init.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void PGA_ConfigInit(void)
{
  PGA_DeInit(PGA_CH0);
  PGA_InitTypeStruct PGA_InitStruct;
  PGA_StructInit(&PGA_InitStruct);
  PGA_InitStruct.PGA_Mode = PGA_INPUT_MODE_DIFFERENTIAL;
  PGA_InitStruct.PGA_Gain = PGA_AMP_GAIN1;
  PGA_InitStruct.PGA_OffsetState = DISABLE;
  PGA_InitStruct.PGA_OffsetSel = PGA_OFFSET_SEL_AVDD;
  PGA_Init(PGA_CH0, &PGA_InitStruct);
  PGA_Cmd(PGA_CH0, ENABLE);
}

/**
 *******************************************************************************
 * @brief   ACMP OverCurrentProtection Sample.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void ACMP_OverCurrentProtection_Sample(void)
{
  /* Config ACMP GPIO */
  ACMP_GPIOInit();
  /* Config PGA GPIO */
  PGA_GPIOInit();
  /* Init ACMP */
  ACMP_ConfigInit();
  /* Init PGA */
  PGA_ConfigInit();
  /* Config OCP input select PGA0_OUT */
  ACMP_OCPInputSelect(ACMP_OCP_INPUT_PGA0_OUT);
  /* Enable ACMP1 */
  ACMP_Cmd(ACMP_CH1, ENABLE);
  /* Wait for Ready Status */
  while(ACMP_GetReadyStatus(ACMP_CH1) != SET);
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT DP *****END OF FILE ***************************/
