/**
 *******************************************************************************
 * @file    cct_inputcaptureinterrupt.c
 *
 * @brief   Implement system specific functions.
 *
 * @author  DP
 *
 * @version V1.0.0
 *
 * @date    2024-12-01
 *
 *******************************************************************************/

/*
    Copyright (c) 2024, DP Microelectronics Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

/* Files include */
#include "cct_inputcaptureinterrupt.h"

/**
  * @addtogroup DPM32M015_LibSamples
  * @{
  */

/**
  * @addtogroup CCT
  * @{
  */

/**
  * @addtogroup CCT InputCapture
  * @{
  */

/* Private typedef --------------------------------------------------------------*/

/* Private define ---------------------------------------------------------------*/

/* Private macro ----------------------------------------------------------------*/

/* Private variables ------------------------------------------------------------*/
 float CH0Time , CH1Time , CH2Time ;
/* Private functions ------------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief   CCT IRQ Handler.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void CCT_IRQ_Handler(void)
{
  if(CCT_GetIntFlagStatus(CCT0, CCT_INT_FLAG_OVERFLOW) == SET)
  {
    CCT_ClearIntFlag(CCT0, CCT_INT_FLAG_OVERFLOW);
  }
  
  if(CCT_GetIntFlagStatus(CCT0, CCT_INT_FLAG_CH0_CAPTURE) == SET)
  {
    CCT_ClearIntFlag(CCT0, CCT_INT_FLAG_CH0_CAPTURE);
    CH0Time = CCT_GetCapture0(CCT0);
  }

  if(CCT_GetIntFlagStatus(CCT0, CCT_INT_FLAG_CH1_CAPTURE) == SET)
  {
    CCT_ClearIntFlag(CCT0, CCT_INT_FLAG_CH1_CAPTURE);
    CH1Time = CCT_GetCapture1(CCT0);
  }

  if(CCT_GetIntFlagStatus(CCT0, CCT_INT_FLAG_CH2_CAPTURE) == SET)
  {
    CCT_ClearIntFlag(CCT0, CCT_INT_FLAG_CH2_CAPTURE);
    CH2Time = CCT_GetCapture2(CCT0);
  }
}


/**
 *******************************************************************************
 * @brief   CCT Config.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void CCT_Config(void)
{
  /* Enable clock */
  RCC_Unlock();
  RCC_APBPeriphClockCmd(RCC_APB_PERIPH_CCT0, ENABLE);
  RCC_Lock();
  
  /* Config CCT0 */
  CCT_TimeBaseInitTypeStruct CCT_TimeBaseInitStruct;
  CCT_TimeBaseStructInit(&CCT_TimeBaseInitStruct);
  CCT_TimeBaseInitStruct.CCT_CounterCycle = CCT_COUNTER_CYCLE_PERIOD;
  CCT_TimeBaseInitStruct.CCT_ClockDivision = CCT_CLK_DIV128;
  CCT_TimeBaseInitStruct.CCT_ReloadValue = 48000 - 1;
  CCT_TimeBaseInit(CCT0, &CCT_TimeBaseInitStruct);
  CCT_Cmd(CCT0, ENABLE);
  /* Config CCT0 CH0-CH1-CH2  input capture */
  CCT_ICInitTypeStruct CCT_ICInitStruct;
  CCT_ICStructInit(&CCT_ICInitStruct);
  CCT_ICInitStruct.CCT_ICSingalSel = CCT_IC_SINGAL_SOURCE_PIN;
  CCT_ICInitStruct.CCT_ICFiltLen = CCT_IC_FILT_LEN16;
  CCT_ICInitStruct.CCT_ICFiltSampDiv = CCT_IC_FILT_SAMPLE_DIV16;
  CCT_ICInitStruct.CCT_ICAction = CCT_IC_ACTION_CLEAR_CNT;
  CCT_ICInitStruct.CCT_ICPolarity = CCT_IC_POLARITY_RISING;
  CCT_IC0Init(CCT0, &CCT_ICInitStruct);
  CCT_IC1Init(CCT0, &CCT_ICInitStruct);
  CCT_IC2Init(CCT0, &CCT_ICInitStruct);
  /* Enable CCT0 CH0 */
  CCT_CH0Cmd(CCT0, ENABLE);
  /* Enable CCT0 CH1 */
  CCT_CH1Cmd(CCT0, ENABLE);
  /* Enable CCT0 CH2 */
  CCT_CH2Cmd(CCT0, ENABLE);
}

/**
 *******************************************************************************
 * @brief   CCT GPIO Init.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void CCT_GPIOInit(void)
{
  /* Enable clock */
  RCC_Unlock();
  RCC_AHBPeriphClockCmd(RCC_AHB_PERIPH_GPIO, ENABLE);
  RCC_Lock();
  
  /* Config CCT0 GPIO */
  GPIO_InitTypeStruct CCT_GPIO_InitStruct;
  GPIO_StructInit(&CCT_GPIO_InitStruct);
  CCT_GPIO_InitStruct.GPIO_Mode = GPIO_MODE_ALT_FUNC;
  CCT_GPIO_InitStruct.GPIO_Speed = GPIO_SPEED_HIGH;
  CCT_GPIO_InitStruct.GPIO_OType = GPIO_OTYPE_PP;
  CCT_GPIO_InitStruct.GPIO_PuPd = GPIO_PUPD_NOPULL;
  CCT_GPIO_InitStruct.GPIO_Pin = GPIO_PIN_2 | GPIO_PIN_3 | GPIO_PIN_6;
  GPIO_Init(GPIOA, &CCT_GPIO_InitStruct);
  GPIO_AltFuncConfig(GPIOA, GPIO_PIN_2, GPIO_ALT_FUNC_0);
  GPIO_AltFuncConfig(GPIOA, GPIO_PIN_3, GPIO_ALT_FUNC_0);
  GPIO_AltFuncConfig(GPIOA, GPIO_PIN_6, GPIO_ALT_FUNC_1);
}

/**
 *******************************************************************************
 * @brief   CCT InputCapture Sample.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void CCT_InputCaptureInterrupt_Sample(void)
{
  /* CCT GPIO Init */
  CCT_GPIOInit();
  /* CCT Config */
  CCT_Config();
   
  /* CCT capture interrupt */
  NVIC_SetPriority(CCT0_IRQn, 2);
  NVIC_EnableIRQ(CCT0_IRQn);
  
  CCT_IntCmd(CCT0, CCT_INT_TYPE_OVERFLOW, ENABLE);
  CCT_IntCmd(CCT0, CCT_INT_TYPE_CH0_CAP, ENABLE);
  CCT_IntCmd(CCT0, CCT_INT_TYPE_CH1_CAP, ENABLE);
  CCT_IntCmd(CCT0, CCT_INT_TYPE_CH2_CAP, ENABLE);
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT DP *****END OF FILE ***************************/
