/**
 *******************************************************************************
 * @file    dbg_debugepwm.c
 *
 * @brief   Implement system specific functions.
 *
 * @author  DP
 *
 * @version V1.0.0
 *
 * @date    2024-12-01
 *
 *******************************************************************************/

/*
    Copyright (c) 2024, DP Microelectronics Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

/* Files include */
#include "dbg_debugepwm.h"

/**
  * @addtogroup DPM32M015_LibSamples
  * @{
  */

/**
  * @addtogroup DBG
  * @{
  */

/**
  * @addtogroup DBG DebugEPWM
  * @{
  */

/* Private typedef --------------------------------------------------------------*/

/* Private define ---------------------------------------------------------------*/

/* Private macro ----------------------------------------------------------------*/

/* Private variables ------------------------------------------------------------*/
uint32_t reloadValue = 48000000 / 128 / 100 - 1; // 100ms;
/* Private functions ------------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief   DEBUG EPWM GPIO Init.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void DEBUG_EPWMGPIOInit(void)
{
  /* Enable clock */
  RCC_Unlock();
  RCC_AHBPeriphClockCmd(RCC_AHB_PERIPH_GPIO, ENABLE);
  RCC_Lock();
 
  GPIO_InitTypeStruct EPWM_GPIO_InitStruct;
  /* Config EPWM GPIO */
  GPIO_StructInit(&EPWM_GPIO_InitStruct);
  EPWM_GPIO_InitStruct.GPIO_Mode = GPIO_MODE_ALT_FUNC;
  EPWM_GPIO_InitStruct.GPIO_Speed = GPIO_SPEED_HIGH;
  EPWM_GPIO_InitStruct.GPIO_OType = GPIO_OTYPE_PP;
  EPWM_GPIO_InitStruct.GPIO_PuPd = GPIO_PUPD_NOPULL;
  EPWM_GPIO_InitStruct.GPIO_Pin = GPIO_PIN_8 | GPIO_PIN_7;
  GPIO_Init(GPIOA, &EPWM_GPIO_InitStruct);
  GPIO_AltFuncConfig(GPIOA, GPIO_PIN_8, GPIO_ALT_FUNC_2);
  GPIO_AltFuncConfig(GPIOA, GPIO_PIN_7, GPIO_ALT_FUNC_2);
  GPIO_ResetBit(GPIOA, GPIO_PIN_8);
  GPIO_ResetBit(GPIOA, GPIO_PIN_7);
}
/**
 *******************************************************************************
 * @brief   DEBUG EPWM Init.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void DEBUG_EPWMInit(void)
{
  /* Enable clock */
  RCC_Unlock();
  RCC_APBPeriphClockCmd(RCC_APB_PERIPH_EPWM, ENABLE);
  RCC_Lock();
  
  EPWM_TimeBaseInitTypeStruct EPWM_TimeBaseInitStruct;
  EPWM_TimeBaseStructInit(&EPWM_TimeBaseInitStruct);
  EPWM_TimeBaseInitStruct.EPWM_ClockDiv = EPWM_CLK_DIV128;
  EPWM_TimeBaseInitStruct.EPWM_CounterCycle = EPWM_COUNTER_CYCLE_PERIOD;
  EPWM_TimeBaseInitStruct.EPWM_CounterMode = EPWM_COUNTER_MODE_INCREASE_DECREASE;
  EPWM_TimeBaseInitStruct.EPWM_ReloadValue = reloadValue;
  EPWM_TimeBaseInit(&EPWM_TimeBaseInitStruct);
  EPWM_Cmd(ENABLE);
  
  EPWM_CHInitTypeStruct EPWM_CHInitStruct;
  EPWM_CHStructInit(&EPWM_CHInitStruct);
  EPWM_CHInitStruct.EPWM_Compare1Value = reloadValue / 2;
  EPWM_CHInitStruct.EPWM_Compare2Value = reloadValue / 2;
  EPWM_CHInitStruct.EPWM_CHInitStatus = EPWM_CH_INIT_STATUS_0;
  EPWM_CHInitStruct.EPWM_Compare1Action = EPWM_CMP_ACT_OUTPUT_FLIP;
  EPWM_CHInitStruct.EPWM_Compare2Action = EPWM_CMP_ACT_OUTPUT_FLIP;
  EPWM_CHInitStruct.EPWM_NPolarity = EPWM_CH_OUT_POLARITY_NORMAL;
  EPWM_CHInitStruct.EPWM_PPolarity = EPWM_CH_OUT_POLARITY_NORMAL;
  EPWM_CHInitStruct.EPWM_Compare1Dir = EPWM_CMP_DIR_INCREASE;
  EPWM_CHInitStruct.EPWM_Compare2Dir = EPWM_CMP_DIR_DECREASE;
  EPWM_CHInit(EPWM_CH0, &EPWM_CHInitStruct);
  EPWM_CHCmd(EPWM_CH0, ENABLE);
}
/**
 *******************************************************************************
 * @brief   Demo Sample.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void DBG_DebugEPWM_Sample(void)
{
  /* EPWM GPIO Init */
  DEBUG_EPWMGPIOInit();
  /* EPWM config */ 
  DEBUG_EPWMInit();
  /* Config EPWM counter mode in debug mode */
  DBG_PeriphConfig(DBG_PERIPH_EPWM, DBG_STATE_PAUSE);
  DelayMs(100);
  
  DBG_PeriphConfig(DBG_PERIPH_EPWM, DBG_STATE_CONTINUE);
  DelayMs(100);
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT DP *****END OF FILE ***************************/
