/**
 *******************************************************************************
 * @file    flash_erasewriteread.c
 *
 * @brief   Implement system specific functions.
 *
 * @author  DP
 *
 * @version V1.0.0
 *
 * @date    2024-12-01
 *
 *******************************************************************************/

/*
    Copyright (c) 2024, DP Microelectronics Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

/* Files include */
#include "flash_erasewriteread.h"

/**
  * @addtogroup DPM32M015_LibSamples
  * @{
  */

/**
  * @addtogroup FLash
  * @{
  */

/**
  * @addtogroup Flash EraseWriteRead
  * @{
  */

/* Private typedef --------------------------------------------------------------*/

/* Private define ---------------------------------------------------------------*/
#define FLASH_OPERATE_ADDR   (DPM_FLASH_BASE + 24*DPM_PAGE_SIZE)   /* last page flash address. */
/* Private macro ----------------------------------------------------------------*/

/* Private variables ------------------------------------------------------------*/
uint32_t uwAddress = 0;
uint32_t readData = 0;
uint32_t writeBuf[5] = {0x99999999, 0x55555555, 0x77777777, 0x66666666, 0x33333333};
/* Private functions ------------------------------------------------------------*/
/**
 *******************************************************************************
 * @brief   Flash EraseWriteRead Sample.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void Flash_EraseWriteRead_Sample(void)
{
    /* Unlock flash */
  FLASH_Unlock();

  /* Page erase. */
  if(FLASH_ErasePage(FLASH_OPERATE_ADDR) != FLASH_OK)
  {
    /* Error occurred while page erase.
       User can add here some code to deal with this error  */
    while(1)
    {
      DelayMs(100);
    }
  }

  /* Check if the programmed data is erased */
  uwAddress = FLASH_OPERATE_ADDR;

  for(uint8_t i = 0; i < 5; i++)
  {
    readData = FLASH_ReadWord(uwAddress);

    if(readData != 0xFFFFFFFF)
    {
      /* Error occurred while reading data in Flash memory.
        User can add here some code to deal with this error */
      while(1)
      {
        DelayMs(100);
      }
    }

    uwAddress = uwAddress + 4;
  }

  /*  Program the user Flash area word by word */
  uwAddress = FLASH_OPERATE_ADDR;

  for(uint8_t i = 0; i < 5; i++)
  {
    if(FLASH_ProgramWord(uwAddress, writeBuf[i]) == FLASH_OK)
    {
      uwAddress = uwAddress + 4;
    }
    else
    {
      /* Error occurred while writing data in Flash memory.
      User can add here some code to deal with this error */

      while(1)
      {
        DelayMs(100);
      }
    }
  }

  /* Check if the programmed data is OK */
  uwAddress = FLASH_OPERATE_ADDR;

  for(uint8_t i = 0; i < 5; i++)
  {
    readData = FLASH_ReadWord(uwAddress);

    if(readData != writeBuf[i])
    {
      /* Error occurred while reading data in Flash memory.
        User can add here some code to deal with this error */
      while(1)
      {
        DelayMs(100);
      }
    }

    uwAddress = uwAddress + 4;
  }

  /* Lock flash */
  FLASH_Lock();

}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT DP *****END OF FILE ***************************/
