/**
 *******************************************************************************
 * @file    lowpowerstop_gpiowakeup.c
 *
 * @brief   Implement system specific functions.
 *
 * @author  DP
 *
 * @version V1.0.0
 *
 * @date    2024-12-01
 *
 *******************************************************************************/

/*
    Copyright (c) 2024, DP Microelectronics Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

/* Files include */
#include "lowpowerstop_gpiowakeup.h"

/**
  * @addtogroup DPM32M015_LibSamples
  * @{
  */

/**
  * @addtogroup LowPower
  * @{
  */

/**
  * @addtogroup LowPower StopMode GPIOWakeup
  * @{
  */

/* Private typedef --------------------------------------------------------------*/

/* Private define ---------------------------------------------------------------*/

/* Private macro ----------------------------------------------------------------*/

/* Private variables ------------------------------------------------------------*/

/* Private functions ------------------------------------------------------------*/
/**
 *******************************************************************************
 * @brief   GPIOA IRQ Handler.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void GPIOA_IRQ_Handler(void)
{
  if(RESET != GPIO_GetIntFlagStatus(GPIOA,GPIO_PIN_0))
  {
    GPIO_ClearIntFlag(GPIOA, GPIO_PIN_0);
  }
}

/**
 *******************************************************************************
 * @brief   GPIO Config.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void GPIO_ConfigInit(void)
{
  /* Enable clock */
  RCC_Unlock();
  RCC_AHBPeriphClockCmd(RCC_AHB_PERIPH_GPIO, ENABLE);
  RCC_Lock();

  GPIO_InitTypeStruct GPIO_InitStruct;
  GPIO_StructInit(&GPIO_InitStruct);
  /* Config OUTPUT mode */
  GPIO_InitStruct.GPIO_Mode = GPIO_MODE_INPUT;
  GPIO_InitStruct.GPIO_Speed = GPIO_SPEED_HIGH;
  GPIO_InitStruct.GPIO_OType = GPIO_OTYPE_PP;
  GPIO_InitStruct.GPIO_PuPd = GPIO_PUPD_DOWN;
  GPIO_InitStruct.GPIO_Pin = GPIO_PIN_0;  
  /* Init GPIO PB10 */
  GPIO_Init(GPIOA, &GPIO_InitStruct);
  /* Config rising interrupt */;
  GPIO_IntConfig(GPIOA, GPIO_PIN_0, GPIO_INT_RISING);
  /* Enable interrupt */
  NVIC_SetPriority(GPIOA_IRQn, 2);
  NVIC_EnableIRQ(GPIOA_IRQn);
  GPIO_IntEnable(GPIOA, GPIO_PIN_0);  
}

/**
 *******************************************************************************
 * @brief   LowPower Stop mode GPIO Wakeup Sample.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void LowPower_Stop_GPIOWakeup_Sample(void)
{
  /* GPIO Config */
  GPIO_ConfigInit();
  
  /* Enable clock */
  RCC_Unlock();
  
  /* Enter stop mode */
  RCC_EnterLowPowerMode(RCC_LOW_POWER_MODE_STOP, RCC_LOW_POWER_ENTRY_WFI);

}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT DP *****END OF FILE ***************************/
