/**
 *******************************************************************************
 * @file    pga_differentialinput.c
 *
 * @brief   Implement system specific functions.
 *
 * @author  DP
 *
 * @version V1.0.0
 *
 * @date    2024-12-01
 *
 *******************************************************************************/

/*
    Copyright (c) 2024, DP Microelectronics Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

/* Files include */
#include "pga_differentialinput.h"

/**
  * @addtogroup DPM32M015_LibSamples
  * @{
  */

/**
  * @addtogroup PGA
  * @{
  */

/**
  * @addtogroup PGA DifferentialInput
  * @{
  */

/* Private typedef --------------------------------------------------------------*/

/* Private define ---------------------------------------------------------------*/
uint16_t ADCCode = 0;
uint16_t vol = 0;
/* Private macro ----------------------------------------------------------------*/

/* Private variables ------------------------------------------------------------*/

/* Private functions ------------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief   PGA GPIO Init.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void PGA_GPIOInit(void)
{
  /* Enable clock */
  RCC_Unlock();
  RCC_AHBPeriphClockCmd(RCC_AHB_PERIPH_GPIO, ENABLE);
  RCC_Lock();
  
  /* PGA GPIO Config */
  GPIO_InitTypeStruct PGA_GPIOInitStruct;
  GPIO_StructInit(&PGA_GPIOInitStruct);
  PGA_GPIOInitStruct.GPIO_Pin = GPIO_PIN_0 | GPIO_PIN_1;
  PGA_GPIOInitStruct.GPIO_PuPd = GPIO_PUPD_NOPULL;
  PGA_GPIOInitStruct.GPIO_OType = GPIO_OTYPE_PP;
  PGA_GPIOInitStruct.GPIO_Mode = GPIO_MODE_ANALOG;
  PGA_GPIOInitStruct.GPIO_Speed = GPIO_SPEED_HIGH;
  GPIO_Init(GPIOA, &PGA_GPIOInitStruct);
  GPIO_AnaAFConfig(GPIOA, GPIO_PIN_0 | GPIO_PIN_1, GPIO_ANA_AF_1);
  /* PGA output IO */
  PGA_GPIOInitStruct.GPIO_Pin = GPIO_PIN_0 ;
  GPIO_Init(GPIOD, &PGA_GPIOInitStruct);
  GPIO_AnaAFConfig(GPIOD, GPIO_PIN_0, GPIO_ANA_AF_0);
 }

 /**
 *******************************************************************************
 * @brief   PGA config.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void PGA_ConfigInit(void)
{
  /* PGA Config*/
  PGA_InitTypeStruct PGA_InitStruct;
  PGA_StructInit(&PGA_InitStruct);
  PGA_InitStruct.PGA_Mode = PGA_INPUT_MODE_DIFFERENTIAL;
  PGA_InitStruct.PGA_Gain = PGA_AMP_GAIN1;
  PGA_InitStruct.PGA_OffsetSel = PGA_OFFSET_SEL_AVDD;
  PGA_InitStruct.PGA_OffsetState = DISABLE;
  PGA_Init(PGA_CH0, &PGA_InitStruct);
  /* PGA Enable */
  PGA_Cmd(PGA_CH0, ENABLE);
  /* Output filtering circuit, input source selection PGA */
  PGA_FiltSelect(PGA_FILT_SEL_PGA0);
  /* Enable output filtering */
  PGA_FiltCmd(ENABLE );
}

 
/**
 *******************************************************************************
 * @brief   PGA ADC sample config.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void PGA_ADCSampleConfig(void)
{
  /* Enable clock */
  RCC_Unlock();
  RCC_APBPeriphClockCmd(RCC_APB_PERIPH_ADC, ENABLE);
  RCC_Lock();
  
  /* Config ADC */
  //ADC Commom configuration
  ADCCOM_InitTypeStruct ADCCOM_InitType;
  ADCCOM_StructInit(&ADCCOM_InitType);
  ADCCOM_InitType.SampleAccuracy = ADC_Sample_Accuracy_12Bit;
  ADCCOM_InitType.PGASel = ADC_PGA_SEL_0;
  ADCCOM_Init(&ADCCOM_InitType);
  //ADCCommonChannel configuration
  ADCCOM_ChannelStruct ADCCOM_Channel;
  ADCCOM_ChannelStructInit(&ADCCOM_Channel);
  ADCCOM_Channel.OversampleEnable = DISABLE;
  ADCCOM_Channel.SampleTimeSel = ADC_SAMPLE_TIME_SEL0;
  ADCCOM_Channel.Offset = 0;
  ADCCOM_Channel.Channel = ADC_Channel_0;
  ADCCOM_ChannelConfig(&ADCCOM_Channel);

  //ADCChannel configuration
  ADC_ChannelStruct ADC_Channel;
  ADC_ChannelStructInit(&ADC_Channel);
  ADC_Channel.DataAlign = ADC_DATA_ALIGN_RIGHT;
  ADC_Channel.DataSign = ADC_DATA_UNSIGNED;
  ADC_Channel.Channel = ADC_Channel_0;
  ADC_ChannelConfig(ADC0, &ADC_Channel);
  //ADC config
  ADC_InitTypeStruct ADC_InitStruct;
  ADC_StructInit(&ADC_InitStruct);
  ADC_InitStruct.TrigMode = ADC_TRIG_SW_SINGLE_CONV;
  ADC_InitStruct.SoftTrigChannel = ADC_Channel_0;
  ADC_Init(ADC0, &ADC_InitStruct);
  ADC_Cmd(ADC0, ENABLE);
  DelayMs(1);
}

/**
 *******************************************************************************
 * @brief   PGA DifferentialInput Sample.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void PGA_DifferentialInput_Sample(void)
{
  /* PGA GPIO Init */
  PGA_GPIOInit();
  /* PGA Config*/
  PGA_ConfigInit();
  
  /* ADC Config */
  PGA_ADCSampleConfig();
  /* ADCx StartConversion */
  ADC_StartConversion(ADC0);
  while(ADC_GetIntFlagStatus(ADC0, ADC_INT_FLAG_EOC) != SET);
  /* ADC0 GetSingleData */
  ADCCode = ADC_GetSingleData(ADC0);
  vol = ADCCode* 3300 / 4096;
  /* ADCx StopConversion */
  ADC_StopConversion(ADC0);
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT DP *****END OF FILE ***************************/
