/**
 *******************************************************************************
 * @file    pvd_interrupt.c
 *
 * @brief   Implement system specific functions.
 *
 * @author  DP
 *
 * @version V1.0.0
 *
 * @date    2024-12-01
 *
 *******************************************************************************/

/*
    Copyright (c) 2024, DP Microelectronics Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

/* Files include */
#include "pvd_interrupt.h"

/**
  * @addtogroup DPM32M015_LibSamples
  * @{
  */

/**
  * @addtogroup PVD
  * @{
  */

/**
  * @addtogroup PVD Interrupt
  * @{
  */

/* Private typedef --------------------------------------------------------------*/
PVD_InitTypeStruct PVD_InitStruct;

/* Private define ---------------------------------------------------------------*/

/* Private macro ----------------------------------------------------------------*/

/* Private variables ------------------------------------------------------------*/

/* Private functions ------------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief   PVD IRQ Handler.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void PVD_IRQ_Handler(void)
{
  if(PVD_GetIntFlagStatus() != RESET)
  {
    PVD_ClearIntFlag();
  }
}

/**
 *******************************************************************************
 * @brief   PVD Interrupt Sample.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void PVD_Interrupt_Sample(void)
{
  /* Enable clock */
  RCC_Unlock();
  RCC_APBPeriphClockCmd(RCC_APB_PERIPH_PVD, ENABLE);
  RCC_Lock();

  /* Config PVD */
  PVD_StructInit(&PVD_InitStruct);
  PVD_InitStruct.PVD_TriggerType = PVD_TRIGGER_TYPE_HIGH_LEVEL;
  PVD_InitStruct.PVD_TriggerResult = PVD_TRIGGER_RESULT_INT;
  PVD_InitStruct.PVD_VrefSel = PVD_VREF_SEL_42;
  PVD_InitStruct.PVD_Filter.FiltSample = PVD_FILTER_SAMPLE_PCLK32;
  PVD_InitStruct.PVD_Filter.FiltLen = PVD_FILTER_LEN32;
  PVD_InitStruct.PVD_Filter.FiltState = ENABLE;
  PVD_Init(&PVD_InitStruct);
  /* Enable PVD */
  PVD_Cmd(ENABLE);
  /* Enable PVD Interrupt */
  NVIC_SetPriority(PVD_IRQn, 2);
  NVIC_EnableIRQ(PVD_IRQn);
  PVD_IntCmd(ENABLE);
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT DP *****END OF FILE ***************************/
