/**
 *******************************************************************************
 * @file    rcc_sysclkconfig.c
 *
 * @brief   Implement system specific functions.
 *
 * @author  DP
 *
 * @version V1.0.0
 *
 * @date    2024-12-01
 *
 *******************************************************************************/

/*
    Copyright (c) 2024, DP Microelectronics Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

/* Files include */
#include "rcc_sysclkconfig.h"

/**
  * @addtogroup DPM32M015_LibSamples
  * @{
  */

/**
  * @addtogroup RCC
  * @{
  */

/**
  * @addtogroup RCC SysclkConfig
  * @{
  */
  
/* Private typedef --------------------------------------------------------------*/

/* Private define ---------------------------------------------------------------*/

/* Private macro ----------------------------------------------------------------*/

/* Private variables ------------------------------------------------------------*/

/* Private functions ------------------------------------------------------------*/
/**
 *******************************************************************************
 * @brief   Configure HCLK and PCLK.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void HCLK_PCLK_Config(void)
{
  RCC_Unlock();
  
  RCC_ClkInitTypeStruct RCC_ClkInitStruct;
  RCC_ClockStructInit(&RCC_ClkInitStruct);
  /* Clock type configured */
  RCC_ClkInitStruct.RCC_ClockType = (uint32_t)(RCC_CLOCK_TYPE_HCLK | RCC_CLOCK_TYPE_PCLK);
  /* Congfig HCLK clock source */
  RCC_ClkInitStruct.HCLKDivider = RCC_SYSCLK_DIV1;
  /* Congfig PCLK clock source */
  RCC_ClkInitStruct.PCLKDivider = RCC_HCLK_DIV1;
  RCC_ClockConfig(&RCC_ClkInitStruct);                                                                            

  RCC_Lock();
}
/**
 *******************************************************************************
 * @brief   Switching LSI for LSCLK initialization.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void LSI_Config(void)
{
  /* Enable LSI */
  RCC_Unlock();
  
  RCC_OscInitTypeStruct RCC_OscInitStruct;
  RCC_OscStructInit(&RCC_OscInitStruct);
  RCC_OscInitStruct.RCC_OscillatorType = RCC_OSCILLATOR_TYPE_LSI;
  RCC_OscInitStruct.RCC_LSIState = RCC_LSI_ON;
  RCC_OscConfig(&RCC_OscInitStruct);
 
  RCC_Lock();
}

/**
 *******************************************************************************
 * @brief   RCC SysclkConfig Sample.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void RCC_SysclkConfig_Sample(void)
{
  /* Configure HCLK and PCLK */
  HCLK_PCLK_Config();

  /* Switching LSI for LSCLK */
  LSI_Config();
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT DP *****END OF FILE ***************************/
