/**
 *******************************************************************************
 * @file    spi_mastercontinuereceive.c
 *
 * @brief   Implement system specific functions.
 *
 * @author  DP
 *
 * @version V1.0.0
 *
 * @date    2024-12-01
 *
 *******************************************************************************/

/*
    Copyright (c) 2024, DP Microelectronics Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

/* Files include */
#include "spi_mastercontinuereceive.h"

/**
  * @addtogroup DPM32M015_LibSamples
  * @{
  */

/**
  * @addtogroup SPI
  * @{
  */

/**
  * @addtogroup SPI MasterFrameInterval
  * @{
  */

/* Private typedef --------------------------------------------------------------*/

/* Private define ---------------------------------------------------------------*/
uint16_t spi_rx_buf[5] ;

/* Private macro ----------------------------------------------------------------*/

/* Private variables ------------------------------------------------------------*/

/* Private functions ------------------------------------------------------------*/
/**
 *******************************************************************************
 * @brief   SPI config Init.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void SPI_Config(void)
{
  /* Enable clock */
  RCC_Unlock();
  RCC_APBPeriphClockCmd(RCC_APB_PERIPH_SPI0, ENABLE);
  RCC_Lock();
  
  SPI_InitTypeStruct SPI_InitStruct;
  SPI_StructInit(&SPI_InitStruct);
  /* Config SPI0 */
  SPI_InitStruct.SPI_Mode = SPI_MODE_MASTER;
  SPI_InitStruct.SPI_DataSize = SPI_DATASIZE_8BIT;
  SPI_InitStruct.SPI_CPOL = SPI_CPOL_LOW;
  SPI_InitStruct.SPI_CPHA = SPI_CPHA_1EDGE;
  SPI_InitStruct.SPI_BaudRatePrescaler = SPI_BAUDRATE_PRESCALER_128;
  SPI_InitStruct.SPI_FirstBit = SPI_FRIST_BIT_MSB;
  SPI_InitStruct.SPI_NSSSlectEn = SPI_NSS_SELECT_DISABLE;
  SPI_Init(SPI0, &SPI_InitStruct);
}

/**
 *******************************************************************************
 * @brief   SPI GPIO Init.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void SPI_GPIOInit(void)
{
  GPIO_InitTypeStruct GPIO_InitStruct;

  /* Enable clock */
  RCC_Unlock();
  RCC_AHBPeriphClockCmd(RCC_AHB_PERIPH_GPIO, ENABLE);
  RCC_Lock();
  /* Config GPIO */
  GPIO_StructInit(&GPIO_InitStruct);
  GPIO_InitStruct.GPIO_Mode = GPIO_MODE_ALT_FUNC;
  GPIO_InitStruct.GPIO_Speed = GPIO_SPEED_HIGH;
  GPIO_InitStruct.GPIO_OType = GPIO_OTYPE_PP;
  GPIO_InitStruct.GPIO_PuPd = GPIO_PUPD_NOPULL;
  //SCLK
  GPIO_InitStruct.GPIO_Pin = GPIO_PIN_3;//PA5
  GPIO_Init(GPIOB, &GPIO_InitStruct);
  GPIO_AltFuncConfig(GPIOB, GPIO_PIN_3, GPIO_ALT_FUNC_0);
  //MISO
  GPIO_InitStruct.GPIO_Pin = GPIO_PIN_4;//PA6
  GPIO_Init(GPIOB, &GPIO_InitStruct);
  GPIO_AltFuncConfig(GPIOB, GPIO_PIN_4, GPIO_ALT_FUNC_0);
  //MOSI
  GPIO_InitStruct.GPIO_Pin = GPIO_PIN_5;//PA7
  GPIO_Init(GPIOB, &GPIO_InitStruct);
  GPIO_AltFuncConfig(GPIOB, GPIO_PIN_5, GPIO_ALT_FUNC_0);
  //CS
  GPIO_InitStruct.GPIO_Mode = GPIO_MODE_OUTPUT;
  GPIO_InitStruct.GPIO_PuPd = GPIO_PUPD_UP;
  GPIO_InitStruct.GPIO_Pin = GPIO_PIN_15;//PA4
  GPIO_Init(GPIOA, &GPIO_InitStruct);
  GPIO_AltFuncConfig(GPIOA, GPIO_PIN_15, GPIO_ALT_FUNC_0);
}
/**
 *******************************************************************************
 * @brief   SPI continue receive.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void SPI_ContReceive(uint16_t size)
{
  uint8_t rxXferCnt = size;

  /* Enable master continue receive */
  SPI_MasterContinueRecvCmd(SPI0, ENABLE);
  
  while(rxXferCnt > 0U)
  {
    if((SPI_GetIntFlagStatus(SPI0, SPI_INT_FLAG_RXNE) == SET) && (rxXferCnt > 0U))
    {
      spi_rx_buf[size - rxXferCnt] = SPI_ReceiveData(SPI0);
      rxXferCnt--;

      if(rxXferCnt == 0)
      {
        SPI_MasterContinueRecvCmd(SPI0, DISABLE);
      }
    }
  }
}
/**
 *******************************************************************************
 * @brief   SPI MasterContinueReceive Sample.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void SPI_MasterContinueReceive_Sample(void)
{
  /* GPIO Init */
  SPI_GPIOInit();
  
  /* SPI config */
  SPI_Config();
  
  /* Config frame interval */
  SPI_TransmitCmd(SPI0, DISABLE);
  SPI_MasterFrameIntervalConfig(SPI0, 0x02);
  SPI_MasterContinueRecvCmd(SPI0, DISABLE);
  SPI_Cmd(SPI0, ENABLE);
  
  /* Reset CS */
  GPIO_ResetBit(GPIOA, GPIO_PIN_15);
  
  /* Config continue receive */
  SPI_ContReceive(5);
  
  /* Set CS */
  GPIO_SetBit(GPIOA, GPIO_PIN_15);
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT DP *****END OF FILE ***************************/
