/**
 *******************************************************************************
 * @file    wdg_interruptfeeddog.c
 *
 * @brief   Implement system specific functions.
 *
 * @author  DP
 *
 * @version V1.0.0
 *
 * @date    2024-12-01
 *
 *******************************************************************************/

/*
    Copyright (c) 2024, DP Microelectronics Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

/* Files include */
#include "wdg_interruptfeeddog.h"

/**
  * @addtogroup DPM32M015_LibSamples
  * @{
  */

/**
  * @addtogroup WDG
  * @{
  */

/**
  * @addtogroup WDG InterruptFeedDog
  * @{
  */

/* Private typedef --------------------------------------------------------------*/

/* Private define ---------------------------------------------------------------*/

/* Private macro ----------------------------------------------------------------*/

/* Private variables ------------------------------------------------------------*/

/* Private functions ------------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief   Demo Init.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void WDG_IRQ_Handler(void)
{
  if(WDG_GetIntFlagStatus() != RESET)
  {
    WDG_FeedDog();
    WDG_ClearIntFlag();
  }
}

/**
 *******************************************************************************
 * @brief   Demo Sample.
 * @param   None.
 * @retval  None.
 ******************************************************************************/
void WDG_InterruptFeedDog_Sample(void)
{
  /* Enable LSI */
  RCC_Unlock();
  RCC_OscInitTypeStruct RCC_OscInitStruct;
  RCC_OscStructInit(&RCC_OscInitStruct);
  RCC_OscInitStruct.RCC_OscillatorType = RCC_OSCILLATOR_TYPE_LSI;
  RCC_OscInitStruct.RCC_LSIState = RCC_LSI_ON;
  RCC_OscConfig(&RCC_OscInitStruct);
  DelayMs(1);
  
  /* Config WDG */
  WDG_DeInit();
  WDG_InitTypeStruct WDG_InitStruct;
  WDG_InitStruct.WDG_Mode = WDG_MODE_14BIT;
  WDG_Init(&WDG_InitStruct);
  
  /* Config WDG interrupt */
  NVIC_SetPriority(WDG_IRQn, 1);
  NVIC_EnableIRQ(WDG_IRQn);
  WDG_IntCmd(ENABLE);
  
  WDG_Cmd(ENABLE);

  /* Enable WDG and lock position */
  WDG_MaskEnable();
  /* Obtain the status of WDG enabled lock position */
  FlagState State =WDG_GetMaskStatus();
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT DP *****END OF FILE ***************************/
