/**
 *******************************************************************************
 * @file    dpm32m0xx_lptim.h
 *
 * @brief   Header file for LPTIM firmware driver.
 *
 * @author  DPM
 *
 * @version V1.0.0
 *
 * @date    2023-11-01
 *
 *******************************************************************************/

#ifndef __DPM32M0XX_LPTIM_H__
#define __DPM32M0XX_LPTIM_H__

#ifdef __cplusplus
extern "C" {
#endif

#if defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wpadded"
#endif

#include "dpm32m0xx.h"



/**
 ******************************************************************************
 * @brief LPTIM initialization structure definition.
 *****************************************************************************/
typedef struct
{
  uint32_t                  LPTIM_PeriodValue;      /*!< Specifies the period value. */
} LPTIM_InitTypeStruct;

/* Deinitializes and initialization and cmd functions. */
void                    LPTIM_DeInit(void);
void                    LPTIM_Init(LPTIM_InitTypeStruct *LPTIM_InitType);
void                    LPTIM_Cmd(FunctionalState NewState);

/* LPTIM counter configuration and period value configuration functions. */
void                    LPTIM_SetPeriod(uint32_t Period_Value);
uint32_t                LPTIM_GetCount(void);

/* LPTIM interrupt related functions. */
void                    LPTIM_IntCmd(FunctionalState NewState);
FunctionalState         LPTIM_GetIntCmdStatus(void);
FlagState               LPTIM_GetIntFlagStatus(void);
void                    LPTIM_ClearIntFlag(void);


#if defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
#pragma clang diagnostic pop
#endif

#ifdef __cplusplus
}

#endif

#endif /* __DPM32M0XX_LPTIM_H__ */
